/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.OidEntry;
import javax.baja.nre.util.Array;

public class OidElement
implements MibConst {
    OidElement parent = null;
    OidElement child = null;
    OidElement next = null;
    long index = 0L;
    int level = 0;
    int entryType = 0;

    public OidElement(long index) {
        this.index = index;
    }

    public OidElement getChild(long index) {
        OidElement c = this.child;
        while (c != null) {
            if (c.index == index) {
                return c;
            }
            c = c.next;
        }
        return null;
    }

    OidElement getNextChild(long index) {
        OidElement c = this.child;
        while (c != null) {
            if (c.index > index) {
                return c;
            }
            c = c.next;
        }
        return null;
    }

    public void addChild(OidElement newChild) {
        newChild.parent = this;
        newChild.level = this.level + 1;
        if (this.child == null) {
            this.child = newChild;
        } else {
            OidElement peer = this.child;
            while (peer.next != null) {
                peer = peer.next;
            }
            peer.next = newChild;
        }
    }

    public String toString() {
        return "index = " + this.index + "  level = " + this.level + " type = " + this.typeToString();
    }

    public OidEntry[] getOidEntries() {
        Array a = new Array(OidEntry.class);
        this.getOidEntries(this, (Array<OidEntry>)a);
        return (OidEntry[])a.trim();
    }

    void getOidEntries(OidElement e, Array<OidEntry> a) {
        if (e == null) {
            return;
        }
        while (e != null) {
            if (e.isOidEntry()) {
                a.add((Object)((OidEntry)e));
            }
            this.getOidEntries(e.child, a);
            e = e.next;
        }
    }

    public boolean isOidEntry() {
        return false;
    }

    String typeToString() {
        switch (this.entryType) {
            case 1: {
                return "ROOT";
            }
            case 3: {
                return "SIMPLE";
            }
            case 4: {
                return "TABLE";
            }
        }
        return "unknown";
    }
}

