/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.point;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.point.BSnmpProxyExt;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.util.DisplayHintParser;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSnmpStringProxyExt
extends BSnmpProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpStringProxyExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void setValue(SnmpVar var) {
        try {
            String displayHint = this.getDisplayHint();
            String sval = SnmpUtil.getString(var);
            if (this.isRaw() && var instanceof SnmpString) {
                sval = DrByteArrayUtil.toString((byte[])((SnmpString)var).getRawData());
            } else if (var instanceof SnmpString) {
                sval = DisplayHintParser.stringDisplay(((SnmpString)var).getRawData(), displayHint);
            }
            this.readOk((BStatusValue)new BStatusString(sval));
        }
        catch (Throwable e) {
            this.readFail(e.getMessage());
        }
    }

    @Override
    protected SnmpVar getVariable(BStatusValue out) {
        String sVal = "";
        sVal = out == null ? ((BStatusString)this.getWriteValue()).getValue() : ((BStatusString)out).getValue();
        if (this.isRaw() && this.getVariableType().equals((Object)BSnmpVariableTypeEnum.stringType)) {
            return new SnmpString(DrByteArrayUtil.getBytes((String)sVal));
        }
        return SnmpUtil.getSnmpVar(sVal, this.getVariableType());
    }

    private boolean isRaw() {
        return this.getDeviceFacets().getb("raw", false);
    }
}

