/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SnmpReceive
implements Runnable,
SnmpConst {
    private static final int NO_ACCESS = 0;
    private static final int READ_ONLY = 1;
    private static final int READ_WRITE = 2;
    private static final int PACKET_SIZE = 1500;
    private boolean done;
    private BSnmpNetwork snmp;
    private DatagramSocket sock;
    private Thread myThread;
    private Logger log;

    public SnmpReceive(BSnmpNetwork snmp) {
        this.snmp = snmp;
        this.log = snmp.log();
    }

    public final void start() {
        try {
            this.sock = this.snmp.getSnmpReceivePort().getBindToLoopback() ? new DatagramSocket(this.snmp.getSnmpReceivePort().getBindingPort(), InetAddress.getByName(null)) : new DatagramSocket(this.snmp.getSnmpReceivePort().getBindingPort());
        }
        catch (Throwable e) {
            if (this.snmp != null) {
                this.log.severe("SnmpReceive: unable to create socket on port " + this.snmp.getSnmpReceivePort() + " " + e.toString());
            }
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("*** Starting SnmpReceive Service " + this.sock.getLocalPort());
        }
        this.done = false;
        this.myThread = new Thread((Runnable)this, "Snmp:Receive");
        this.myThread.start();
    }

    public final void stop() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("*** Stopping SnmpReceive Service");
        }
        this.done = true;
        if (this.sock != null) {
            this.sock.close();
        }
    }

    @Override
    public void run() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("SnmpReceive thread is now running.");
        }
        DatagramPacket pack = new DatagramPacket(new byte[1500], 1500);
        while (!this.done) {
            pack.setLength(1500);
            SnmpPDU pdu = ComUtil.receive(this.snmp, this.sock, pack);
            if (pdu != null && pdu.getVersion() > 1) continue;
            SnmpPDU resp = null;
            if (pdu == null) continue;
            int access = this.checkReceivedRequest(pdu);
            if (access == 0) {
                if (!this.log.isLoggable(Level.FINE)) continue;
                this.log.fine("Access denied.");
                continue;
            }
            if (pdu.isFull()) {
                resp = new SnmpPDU();
                resp.setErrstat(1);
                resp.setErrindex(0);
            } else {
                try {
                    int command = pdu.getCommand() & 0xFF;
                    switch (command) {
                        case 160: {
                            resp = this.processGet(pdu);
                            break;
                        }
                        case 161: {
                            resp = this.processGetNext(pdu);
                            break;
                        }
                        case 165: {
                            resp = this.processBulkRequest(pdu);
                            break;
                        }
                        case 163: {
                            if (access == 2) {
                                resp = this.processSet(pdu);
                            }
                            break;
                        }
                        default: {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Received Unprocessable SNMP request (Command: " + pdu.getCommand() + ")");
                            }
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    this.log.severe("Exception processing pdu:" + e.toString());
                }
            }
            if (resp == null) continue;
            this.sendResponse(pdu, resp);
        }
    }

    private int checkReceivedRequest(SnmpPDU pdu) {
        if (this.snmp.getIgnoreRequestsFromUnrecognizedSources() && !this.sourceIpRecognized(pdu.getSourceIp().getHostAddress())) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Access denied: Unrecognized source");
            }
            return 0;
        }
        if (!this.snmp.getCheckCommunityOnRequests()) {
            return 2;
        }
        if (pdu.getCommunity().equals(this.snmp.getReadWriteCommunity())) {
            return 2;
        }
        if (pdu.getCommunity().equals(this.snmp.getReadOnlyCommunity())) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("ReadOnly access: Not readWrite community member");
            }
            return 1;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Access denied: Not community member");
        }
        return 0;
    }

    private boolean sourceIpRecognized(String source) {
        String[] addressList = this.snmp.getRecognizedSources().getAddressList();
        if (addressList == null || addressList.length <= 0) {
            return false;
        }
        for (int i = 0; i < addressList.length; ++i) {
            if (!source.equals(addressList[i])) continue;
            return true;
        }
        return false;
    }

    private void sendResponse(SnmpPDU pdu, SnmpPDU resp) {
        try {
            resp.setVersion(pdu.getVersion());
            resp.setReqid(pdu.getReqid());
            resp.setCommunity(pdu.getCommunity());
            resp.setCommand(162);
            resp.setRemotePort(pdu.getRemotePort());
            resp.setDestinationIp(pdu.getSourceIp());
            ComUtil.send(this.snmp, resp, this.sock);
        }
        catch (Throwable e) {
            this.log.severe("Exception while sending response: " + e.toString());
        }
    }

    private SnmpPDU processSet(SnmpPDU pdu) {
        int error;
        int i;
        int ver = pdu.getVersion();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        SnmpPDU resp = new SnmpPDU();
        for (i = 0; i < vbs.length; ++i) {
            error = this.snmp.getMib().validateForSet(vbs[i], resp, ver);
            if (error == 0) continue;
            resp.setErrstat(error);
            resp.setErrindex(i + 1);
            return resp;
        }
        for (i = 0; i < vbs.length; ++i) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("set var " + vbs[i].toString());
            }
            if ((error = this.snmp.getMib().processSet(vbs[i], resp, ver)) == 0) continue;
            resp.clearVariableBindings();
            if (ver == 0) {
                resp.setErrstat(error);
                resp.setErrindex(i + 1);
                break;
            }
            resp.setErrstat(i == 0 ? 14 : 15);
            resp.setErrindex(0);
            break;
        }
        return resp;
    }

    private SnmpPDU processGet(SnmpPDU pdu) {
        int ver = pdu.getVersion();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        SnmpPDU resp = new SnmpPDU();
        for (int i = 0; i < vbs.length; ++i) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("get var " + vbs[i].toString());
            }
            SnmpOID oid = vbs[i].getObjectID();
            int error = this.snmp.getMib().processGet(oid, resp, ver);
            if (error == 0 || ver != 0) continue;
            resp.clearVariableBindings();
            resp.setErrstat(error);
            resp.setErrindex(i + 1);
            break;
        }
        return resp;
    }

    private SnmpPDU processGetNext(SnmpPDU pdu) {
        int ver = pdu.getVersion();
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        SnmpPDU resp = new SnmpPDU();
        for (int i = 0; i < vbs.length; ++i) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("getNext var " + vbs[i].toString());
            }
            SnmpOID oid = vbs[i].getObjectID();
            SnmpVarBind varBind = this.snmp.getMib().processGetNext(oid);
            if (varBind == null) {
                if (ver == 0) {
                    resp.clearVariableBindings();
                    resp.setErrstat(2);
                    resp.setErrindex(i + 1);
                    return resp;
                }
                varBind = new SnmpVarBind(oid, new SnmpExceptionVar(130));
            }
            resp.addVariableBinding(varBind);
        }
        return resp;
    }

    private SnmpPDU processBulkRequest(SnmpPDU pdu) {
        int maxRpt;
        SnmpVarBind[] vbs = pdu.getVaribleBindingArray();
        int nonRptCnt = pdu.getNonRepeaters();
        if (nonRptCnt > vbs.length) {
            nonRptCnt = vbs.length;
        }
        if ((maxRpt = pdu.getMaxRepetitions()) < 0) {
            maxRpt = 0;
        }
        SnmpPDU resp = new SnmpPDU();
        for (int i = 0; i < nonRptCnt; ++i) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("getBulk var " + vbs[i].toString());
            }
            SnmpOID oid = vbs[i].getObjectID();
            SnmpVarBind varBind = this.snmp.getMib().processGetNext(oid);
            if (varBind == null) {
                varBind = new SnmpVarBind(oid, new SnmpExceptionVar(130));
            }
            resp.addVariableBinding(varBind);
        }
        int rptCnt = vbs.length - nonRptCnt;
        SnmpOID[] oids = new SnmpOID[rptCnt];
        for (int i = 0; i < rptCnt; ++i) {
            oids[i] = vbs[i + nonRptCnt].getObjectID();
        }
        for (int n = 0; n < maxRpt; ++n) {
            for (int i = 0; i < rptCnt; ++i) {
                SnmpVarBind varBind = this.snmp.getMib().processGetNext(oids[i]);
                if (varBind == null) {
                    varBind = new SnmpVarBind(oids[i], new SnmpExceptionVar(130));
                }
                oids[i] = varBind.getObjectID();
                resp.addVariableBinding(varBind);
            }
        }
        Vector<SnmpVarBind> v = resp.getVariableBindings();
        boolean first = false;
        for (int i = v.size() - 1; i >= 0; --i) {
            SnmpVarBind varBind = v.elementAt(i);
            SnmpVar var = varBind.getVariable();
            if (var.type != 130) break;
            if (!first) {
                first = true;
                continue;
            }
            v.removeElementAt(i + 1);
        }
        return resp;
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }
}

