/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNException;
import com.tridium.snmp.snmptypes.SnmpConst;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class ASNInput
extends ByteArrayInputStream
implements SnmpConst {
    public ASNInput(byte[] encodedData) {
        super(encodedData);
    }

    public int getPosition() {
        return this.pos;
    }

    public void setBuffer(byte[] buffer) {
        this.buf = buffer;
        this.mark = 0;
        this.pos = 0;
        this.count = this.buf.length;
    }

    public int peekTag() throws ASNException {
        if (this.available() == 0) {
            return -1;
        }
        int savedPos = this.pos;
        int peekTag = this.read();
        this.pos = savedPos;
        return peekTag;
    }

    public int getSequenceLength() throws ASNException {
        this.verifyTag(48);
        return this.readLength();
    }

    public int getInt() throws ASNException {
        this.verifyTag(2);
        return this.readInt();
    }

    public String getString() throws ASNException {
        return new String(this.getOctetString());
    }

    public byte[] getOctetString() throws ASNException {
        this.verifyTag(4);
        return this.readBytes();
    }

    public long getTimetick() throws ASNException {
        this.verifyTag(67);
        return this.readUnsignedInt();
    }

    public void getNull() throws ASNException {
        this.verifyTag(5);
        this.readLength();
    }

    public long[] getObjectID() throws ASNException {
        this.verifyTag(6);
        Vector<Long> v = new Vector<Long>(16);
        int len = this.readLength();
        int maxPos = this.pos + len;
        long num12 = this.getTagLong();
        long num1 = num12 / 40L;
        long num2 = num12 % 40L;
        v.addElement(num1);
        v.addElement(num2);
        while (this.pos < maxPos) {
            v.addElement(this.getTagLong());
        }
        long[] a = new long[v.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Long)v.elementAt(i);
        }
        return a;
    }

    public byte[] getIpAddress() throws ASNException {
        this.verifyTag(64);
        return this.readBytes();
    }

    public long getCounter() throws ASNException {
        this.verifyTag(65);
        return this.readUnsignedInt();
    }

    public long getCounter64() throws ASNException {
        this.verifyTag(70);
        return this.readUnsignedInt();
    }

    public long getGauge() throws ASNException {
        this.verifyTag(66);
        return this.readUnsignedInt();
    }

    public byte[] getOpaque() throws ASNException {
        this.verifyTag(68);
        return this.readBytes();
    }

    public long getTagLong() throws ASNException {
        int b;
        long val = 0L;
        do {
            if ((b = this.read()) < 0) {
                throw new ASNException();
            }
            val = (val << 7) + (long)(b & 0x7F);
        } while ((b & 0x80) != 0);
        return val;
    }

    public int getCommand() throws ASNException {
        int b = this.read() & 0xFF;
        if ((b >> 4 & 0xF) != 10) {
            throw new ASNException();
        }
        return b;
    }

    public byte[] readBytes() throws ASNException {
        int len = this.readLength();
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = (byte)this.read();
        }
        return a;
    }

    public int readInt() throws ASNException {
        return this.readInt(this.readLength());
    }

    public int readInt(int length) throws ASNException {
        if (length <= 0) {
            return 0;
        }
        int val = this.read();
        if (length < 4 && (val & 0x80) != 0) {
            val |= 0xFFFFFF00;
        }
        --length;
        while (length > 0) {
            val <<= 8;
            val |= this.read();
            --length;
        }
        return val;
    }

    public long readUnsignedInt() throws ASNException {
        return this.readUnsignedInt(this.readLength());
    }

    public long readUnsignedInt(int length) throws ASNException {
        long val = 0L;
        while (length > 0) {
            val <<= 8;
            val |= (long)this.read();
            --length;
        }
        return val;
    }

    public int readLength() throws ASNException {
        int b = this.read();
        if (b < 128) {
            return b;
        }
        int lenBytes = b & 0x7F;
        return (int)this.readUnsignedInt(lenBytes);
    }

    private void verifyTag(int type) throws ASNException {
        int tag = this.read();
        if (tag != (byte)type) {
            System.out.println("invalid tag=" + tag + " expected=" + type + " at pos=" + (this.getPosition() - 1));
            throw new ASNException();
        }
    }

    @Override
    public int read(byte[] array) {
        return this.read(array, 0, array.length);
    }
}

