/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.util.SnmpUtil;

public class SnmpOID
extends SnmpVar {
    protected long[] aVal;
    private boolean valid = true;

    public SnmpOID(long[] aVal) {
        this.aVal = aVal;
        this.valid = true;
        this.type = 6;
    }

    public SnmpOID(String val) {
        try {
            this.aVal = SnmpUtil.getLongArray(val);
        }
        catch (RuntimeException e) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValue(long[] aVal) {
        this.aVal = aVal;
    }

    public long[] toValue() {
        return this.aVal;
    }

    public long[] toLongArray() {
        return this.aVal;
    }

    public long[] toLongArrayCopy() {
        long[] la = new long[this.aVal.length];
        System.arraycopy(this.aVal, 0, la, 0, this.aVal.length);
        return la;
    }

    @Override
    public void encode(ASNOutput out) {
        out.addObjectId(this.aVal);
    }

    public String toString() {
        return SnmpUtil.longArrayToString(this.aVal);
    }

    @Override
    public String toStringValue() {
        return SnmpUtil.longArrayToString(this.aVal);
    }

    @Override
    public String toTagString() {
        return "OBJECT ID: " + this.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnmpOID)) {
            return false;
        }
        SnmpOID comp = (SnmpOID)obj;
        if (comp.aVal.length != this.aVal.length) {
            return false;
        }
        for (int i = 0; i < this.aVal.length; ++i) {
            if (comp.aVal[i] == this.aVal[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.aVal.length; ++i) {
            h = (int)((long)h ^ this.aVal[i]);
            h = (int)((long)h ^ this.aVal[i] >> 32);
        }
        return h;
    }
}

