/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpVar;
import java.util.concurrent.TimeUnit;
import javax.baja.sys.BAbsTime;

public class SnmpTimeticks
extends SnmpVar {
    private long value;

    public SnmpTimeticks(long value) {
        this.type = 67;
        this.value = value;
    }

    @Override
    public void encode(ASNOutput out) {
        out.addTimeticks(this.value);
    }

    public long longValue() {
        return this.value;
    }

    @Override
    public String toTagString() {
        return "TIMETICKS: " + this.value + "(" + BAbsTime.make((long)(this.value * 10L)) + ")";
    }

    @Override
    public String toStringValue() {
        return this.timetiksTohhmmss(this.value);
    }

    private String timetiksTohhmmss(long value2) {
        long seconds = this.value / 100L;
        long hours = TimeUnit.SECONDS.toHours(seconds);
        long minute = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        String timeTicks = hours + " hours " + minute + " minutes " + second + " seconds ( " + this.value + " )";
        return timeTicks;
    }
}

