/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.datatypes.BNetworkManagerConfiguration;
import com.tridium.snmp.services.BSnmpRecipient;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import java.net.InetAddress;
import javax.baja.sys.Sys;

public class SnmpTrap
extends SnmpPDU {
    protected BSnmpNetwork snmp;
    private int port = 162;
    private InetAddress managerIp;
    private int snmpVersion;
    private int genericType;
    private int specificType;
    private String community;
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int LINK_UP = 3;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;

    public SnmpTrap(BSnmpNetwork snmp, int genericType, int specificType) {
        this.genericType = genericType;
        this.specificType = specificType;
        this.snmp = snmp;
        this.managerIp = snmp.getManagerIp();
        this.port = snmp.getDefaultNetworkManagerTrapsPort();
        this.snmpVersion = snmp.getDefaultNetworkManagerSnmpVersion();
        this.community = snmp.getDefaultNetworkManagerTrapsCommunity();
        this.init();
    }

    public SnmpTrap(BSnmpRecipient recipient, int genericType, int specificType) {
        this.genericType = genericType;
        this.specificType = specificType;
        this.snmp = recipient.snmp();
        BNetworkManagerConfiguration cnfig = recipient.getNetworkManagerConfig();
        this.managerIp = cnfig.getManagerIp();
        this.port = cnfig.getNetworkManagerTrapsPort();
        this.snmpVersion = cnfig.getNetworkManagerSnmpVersion();
        this.community = cnfig.getNetworkManagerTrapsCommunity();
        this.init();
    }

    private void init() {
        block4: {
            if (this.snmpVersion == 2) {
                this.setVersion(1);
                this.setCommand(167);
            } else {
                this.setVersion(0);
                this.setCommand(164);
            }
            this.setCommunity(this.community);
            try {
                this.setEnterprise(new SnmpOID(this.genericType >= 0 && this.genericType <= 5 ? "1.3.6.1.2.1.11" : "1.3.6.1.4.1.4131.1"));
                this.setSourceIp(Sys.getLocalHost((InetAddress)this.managerIp));
                this.setDestinationIp(this.managerIp);
                this.setTrapType(this.genericType);
                this.setSpecificType(this.specificType);
            }
            catch (Exception e) {
                if (this.snmp == null) break block4;
                this.snmp.log().severe("Unable to create SnmpTrap - " + e.toString());
            }
        }
    }

    public synchronized void send() {
        block2: {
            try {
                this.setRemotePort(this.port);
                this.setUpTime(this.snmp.getTimeTick());
                ComUtil.send(this.snmp, this);
            }
            catch (Exception e) {
                if (this.snmp == null) break block2;
                this.snmp.log().severe("Unable to send SnmpTrap - " + e.toString());
            }
        }
    }

    public void addStringVariable(String sOid, String value) {
        SnmpOID oid = new SnmpOID(sOid);
        SnmpString var = new SnmpString(value);
        this.addVariableBinding(new SnmpVarBind(oid, var));
    }

    public void addIntegerVariable(String sOid, int value) {
        SnmpOID oid = new SnmpOID(sOid);
        SnmpInt var = new SnmpInt(value);
        this.addVariableBinding(new SnmpVarBind(oid, var));
    }
}

