/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNException;
import com.tridium.snmp.snmptypes.ASNInput;
import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpCounter;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpGauge;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpIpAddress;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpOpaque;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpTimeticks;

public abstract class SnmpVar
implements SnmpConst {
    public int type;

    public static SnmpVar getSnmpVar(ASNInput in) throws ASNException {
        int type = in.peekTag();
        switch (type) {
            case 2: {
                SnmpInt snmpVar = new SnmpInt(in.getInt());
                snmpVar.type = type;
                return snmpVar;
            }
            case 4: {
                byte[] value = in.getOctetString();
                SnmpString snmpVar = new SnmpString(value);
                snmpVar.type = type;
                return snmpVar;
            }
            case 5: {
                in.getNull();
                SnmpNull snmpVar = new SnmpNull();
                snmpVar.type = type;
                return snmpVar;
            }
            case 6: {
                SnmpOID snmpVar = new SnmpOID(in.getObjectID());
                snmpVar.type = type;
                return snmpVar;
            }
            case 64: {
                SnmpIpAddress snmpVar = new SnmpIpAddress(in.getIpAddress());
                snmpVar.type = type;
                return snmpVar;
            }
            case 67: {
                SnmpTimeticks snmpVar = new SnmpTimeticks(in.getTimetick());
                snmpVar.type = type;
                return snmpVar;
            }
            case 65: {
                SnmpCounter snmpVar = new SnmpCounter(in.getCounter());
                snmpVar.type = type;
                return snmpVar;
            }
            case 70: {
                SnmpCounter snmpVar = new SnmpCounter(in.getCounter64());
                snmpVar.type = type;
                return snmpVar;
            }
            case 66: {
                SnmpGauge snmpVar = new SnmpGauge(in.getGauge());
                snmpVar.type = type;
                return snmpVar;
            }
            case 68: {
                SnmpOpaque snmpVar = new SnmpOpaque(in.getOpaque());
                return snmpVar;
            }
            case 128: 
            case 129: 
            case 130: {
                in.read();
                in.readBytes();
                SnmpExceptionVar snmpVar = new SnmpExceptionVar();
                snmpVar.type = type;
                return snmpVar;
            }
        }
        throw new ASNException();
    }

    public String toTagString() {
        return "SNMP VAR";
    }

    public String toStringValue() {
        return "";
    }

    public abstract void encode(ASNOutput var1);
}

