/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.lonworks.enums.BServicePinState;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonServicePinJob;
import com.tridium.ui.BOptionDialog;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public class ServicePinMonitor
implements BWbComponentView.Attachable {
    BWbComponentView manager;
    BLonServicePinJob job;
    BOptionDialog popup = null;
    private static final Lexicon lexicon = Lexicon.make(ServicePinMonitor.class);
    private static final BIcon svcPinIcon = BIcon.make((String)lexicon.getText("servicePinDialog.icon"));
    private static final BImage svcPinImage = BImage.make((BIcon)svcPinIcon).transform(BTransform.makeScale((double)1.5, (double)1.5));

    public ServicePinMonitor(BWbComponentView manager, BLonServicePinJob job) {
        this.manager = manager;
        this.job = job;
    }

    public void attached(BWbComponentView editor) {
        if (this.job.getServicePinState().equals((Object)BServicePinState.waiting)) {
            this.createPopup();
        }
    }

    public void detached(BWbComponentView editor) {
    }

    public void handleComponentEvent(BComponentEvent evnt) {
        if (evnt.getSourceComponent() == this.job && evnt.getId() == 0 && evnt.getSlot() == BLonCommissionJob.servicePinState) {
            BServicePinState servicePinState = (BServicePinState)evnt.getValue();
            if (servicePinState.equals((Object)BServicePinState.waiting) && this.popup == null) {
                this.createPopup();
            }
            if ((servicePinState.equals((Object)BServicePinState.received) || servicePinState.equals((Object)BServicePinState.canceled)) && this.popup != null) {
                this.popup.close();
                this.manager.unattach((BWbComponentView.Attachable)this);
            }
        }
    }

    synchronized void createPopup() {
        if (this.popup != null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ServicePinMonitor.this.doCreatePopup();
            }
        };
        Thread t = new Thread(r, "lon.SrvcPinMon");
        t.start();
    }

    void doCreatePopup() {
        this.popup = new BOptionDialog((BWidget)this.manager, lexicon.getText("servicePinDialog.title"), (BWidget)new BLabel(lexicon.getText("servicePinDialog.text")), 2, svcPinImage, null);
        this.popup.setBoundsCenteredOnOwner();
        this.popup.open();
        int res = this.popup.getResult();
        if (res == 2) {
            this.job.cancel();
            this.manager.unattach((BWbComponentView.Attachable)this);
        }
    }
}

