/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.point;

import com.tridium.lonworks.discover.BLonCreationEntry;
import com.tridium.lonworks.discover.LonLearnUtil;
import com.tridium.lonworks.ui.point.BLonPointManager;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class PointLearn
extends MgrLearn {
    BLonDevice dev;
    static Lexicon lex = BLonPointManager.lexicon;

    public PointLearn(BAbstractManager manager) {
        super(manager);
    }

    public void load(BComponent target) {
        super.load(target);
        this.dev = (BLonDevice)CompUtil.closestAncestor((BComplex)target, BLonDevice.class).orElseThrow(NullPointerException::new);
        this.dev.getComponentSpace().update((BComponent)this.dev, Integer.MAX_VALUE);
        this.updateDiscoveryRows();
    }

    void updateDiscoveryRows() {
        ArrayList list = new ArrayList();
        LonLearnUtil.doUpdateDiscoveryRows(list, (BComponent)this.dev, (Context)this.getManager().getCurrentContext());
        Object[] rows = list.toArray(new BLonCreationEntry[0]);
        this.updateRoots(rows);
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(lex.getText("learn.columnTitle.targetName"), BLonCreationEntry.targetName, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.elementName"), BLonCreationEntry.elementName, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.units"), BLonCreationEntry.units, 1)};
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean hasChildren(Object discovery) {
        return this.getChildren(discovery).length > 0;
    }

    public Object[] getChildren(Object discovery) {
        Object[] a = ((BLonCreationEntry)discovery).getChildren(BLonCreationEntry.class);
        if (a == null) {
            return new Object[0];
        }
        return a;
    }

    public BImage getIcon(Object discovery) {
        return BImage.make((BIcon)((BLonCreationEntry)discovery).getIcon());
    }

    public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
        BLonCreationEntry creatEntry = (BLonCreationEntry)discovery;
        ArrayList list = new ArrayList();
        boolean writable = creatEntry.getIsTargetComponentWritable();
        Type type = creatEntry.getTarget().getType();
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            PointModel.addNumericPointTypes(list, (boolean)writable);
            PointModel.addBooleanPointTypes(list, (boolean)writable);
            PointModel.addStringPointTypes(list, (boolean)writable);
            PointModel.addEnumPointTypes(list, (boolean)writable);
        } else if (type == BLonBoolean.TYPE) {
            PointModel.addBooleanPointTypes(list, (boolean)writable);
            PointModel.addNumericPointTypes(list, (boolean)writable);
            PointModel.addStringPointTypes(list, (boolean)writable);
        } else if (type == BLonEnum.TYPE) {
            PointModel.addEnumPointTypes(list, (boolean)writable);
            PointModel.addStringPointTypes(list, (boolean)writable);
            PointModel.addNumericPointTypes(list, (boolean)writable);
            PointModel.addBooleanPointTypes(list, (boolean)writable);
        } else {
            PointModel.addStringPointTypes(list, (boolean)writable);
        }
        return list.toArray(new MgrTypeInfo[0]);
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BLonCreationEntry creatEntry = (BLonCreationEntry)discovery;
        BLonPointManager pm = (BLonPointManager)row.getManager();
        row.setDefaultName(creatEntry.getDefaultProxyName());
        row.setCell(pm.colTarget, (BValue)BString.make((String)creatEntry.getTargetPathName()));
        row.setCell(pm.colElement, (BValue)BString.make((String)creatEntry.getElementName()));
        row.setCell(pm.colFacets, (BValue)creatEntry.getFacets());
    }

    public boolean isExisting(Object discovery, BComponent component) {
        if (!(component instanceof BControlPoint)) {
            return false;
        }
        BLonCreationEntry creatEntry = (BLonCreationEntry)discovery;
        BControlPoint cp = (BControlPoint)component;
        BLonProxyExt ext = (BLonProxyExt)cp.getProxyExt();
        String targetName = ext.getTargetComp();
        return targetName.equals(creatEntry.getTargetName()) && ext.getTargetName().equals(creatEntry.getElementName());
    }
}

