/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.ui;

import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.point.BNPointDeviceExt;
import com.tridium.ndriver.ui.NMgrUtil;
import com.tridium.ndriver.ui.device.BINDeviceMgrAgent;
import com.tridium.ndriver.ui.device.BNDeviceManager;
import com.tridium.ndriver.ui.point.BINPointMgrAgent;
import com.tridium.ndriver.ui.point.BNPointManager;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;

public final class NMgrControllerUtil {
    private NMgrControllerUtil() {
    }

    public static CommandArtifact doDiscover(BAbstractManager mgr, Context cx) throws Exception {
        BNDiscoveryPreferences prefs;
        BINDiscoveryHost host = NMgrUtil.findDiscoveryHost(mgr);
        mgr.getController().learnMode.setSelected(true);
        BNDiscoveryPreferences discoveryJobPrefs = prefs = (BNDiscoveryPreferences)host.getDiscoveryPreferences().newCopy();
        if (!prefs.getDoNotAskAgain()) {
            discoveryJobPrefs = (BNDiscoveryPreferences)BWbFieldEditor.dialog((BWidget)mgr, (String)NMgrUtil.LEX.get("discoveryParameters"), (BObject)prefs);
        }
        if (discoveryJobPrefs != null) {
            mgr.getLearn().setJob(host.submitDiscoveryJob(discoveryJobPrefs));
        }
        return null;
    }

    public static MgrController.IMgrCommand[] makeCommands(MgrController.IMgrCommand[] superCommands, BNDeviceManager mgr) {
        Array deviceMgrCmdAgents = new Array(MgrController.IMgrCommand.class);
        BNNetwork network = NMgrUtil.findNNetwork((BAbstractManager)mgr);
        AgentList agents = network.getAgents().filter(AgentFilter.is((Type)BINDeviceMgrAgent.TYPE));
        AgentInfo[] infoA = agents.list();
        for (int i = 0; i < infoA.length; ++i) {
            BINDeviceMgrAgent mgrAgent = (BINDeviceMgrAgent)infoA[i].getInstance();
            deviceMgrCmdAgents.add((Object)NDeviceMgrAgentCommand.make((BAbstractManager)mgr, mgrAgent));
        }
        return MgrController.append((MgrController.IMgrCommand[])superCommands, (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])deviceMgrCmdAgents.trim()));
    }

    public static MgrController.IMgrCommand[] makeCommands(MgrController.IMgrCommand[] superCommands, BNPointManager mgr) {
        Array pointMgrCmdAgents = new Array(MgrController.IMgrCommand.class);
        BDevice device = NMgrUtil.findNDevice((BAbstractManager)mgr);
        AgentList devAgents = device.getAgents().filter(AgentFilter.is((Type)BINPointMgrAgent.TYPE));
        AgentInfo[] agentInfoA = devAgents.list();
        for (int i = 0; i < agentInfoA.length; ++i) {
            BINPointMgrAgent pointMgrAgent = (BINPointMgrAgent)agentInfoA[i].getInstance();
            pointMgrCmdAgents.add((Object)NPointMgrAgentCommand.make((BAbstractManager)mgr, pointMgrAgent));
        }
        BNPointDeviceExt ptDevExt = NMgrUtil.findNPointDeviceExt((BAbstractManager)mgr);
        if (ptDevExt != null) {
            AgentList devExtAgents = ptDevExt.getAgents().filter(AgentFilter.is((Type)BINPointMgrAgent.TYPE));
            AgentInfo[] agentsOnPtDevExt = devExtAgents.list();
            for (int i = 0; i < agentsOnPtDevExt.length; ++i) {
                BINPointMgrAgent pointMgrAgent = (BINPointMgrAgent)agentsOnPtDevExt[i].getInstance();
                pointMgrCmdAgents.add((Object)NPointMgrAgentCommand.make((BAbstractManager)mgr, pointMgrAgent));
            }
        }
        return MgrController.append((MgrController.IMgrCommand[])superCommands, (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])pointMgrCmdAgents.trim()));
    }

    public static void updateCommands(BAbstractManager mgr) {
        MgrController.IMgrCommand[] mgrCommands = mgr.getController().getCommands();
        for (int i = 0; i < mgrCommands.length; ++i) {
            if (mgrCommands[i] instanceof NDeviceMgrAgentCommand) {
                NDeviceMgrAgentCommand deviceMgrCommand = (NDeviceMgrAgentCommand)mgrCommands[i];
                deviceMgrCommand.agent.update((BNDeviceManager)mgr, deviceMgrCommand);
                continue;
            }
            if (!(mgrCommands[i] instanceof NPointMgrAgentCommand)) continue;
            NPointMgrAgentCommand pointMgrCommand = (NPointMgrAgentCommand)mgrCommands[i];
            pointMgrCommand.agent.update((BNPointManager)mgr, pointMgrCommand);
        }
    }

    public static class NPointMgrAgentCommand
    extends MgrController.MgrCommand {
        BINPointMgrAgent agent;

        public static NPointMgrAgentCommand make(BAbstractManager manager, BINPointMgrAgent agent) {
            String uiName = agent.getUiName();
            if (uiName == null) {
                return new NPointMgrAgentCommand(manager, agent, "??");
            }
            Lexicon lex = Sys.loadModule((String)agent.getType().getTypeSpec().getModuleName()).getLexicon();
            if (lex == null) {
                return new NPointMgrAgentCommand(manager, agent, uiName);
            }
            String lexLabel = lex.get(uiName + ".label");
            if (lexLabel == null) {
                return new NPointMgrAgentCommand(manager, agent, lex.getText(uiName));
            }
            return new NPointMgrAgentCommand(manager, lex, agent);
        }

        NPointMgrAgentCommand(BAbstractManager manager, BINPointMgrAgent agent, String label) {
            super((BWidget)manager, label);
            this.agent = agent;
            this.setFlags(agent.getFlags());
        }

        NPointMgrAgentCommand(BAbstractManager manager, Lexicon lex, BINPointMgrAgent agent) {
            super((BWidget)manager, lex, agent.getUiName());
            this.agent = agent;
            this.setFlags(agent.getFlags());
        }

        public CommandArtifact doInvoke() throws Exception {
            BNPointManager pointMgr = (BNPointManager)this.getOwner();
            CommandArtifact retVal = this.agent.doInvoke(pointMgr, NMgrUtil.findNNetwork((BAbstractManager)pointMgr), NMgrUtil.findNDevice((BAbstractManager)pointMgr), NMgrUtil.findNPointDeviceExt((BAbstractManager)pointMgr));
            pointMgr.getController().updateCommands();
            return retVal;
        }
    }

    public static class NDeviceMgrAgentCommand
    extends MgrController.MgrCommand {
        BINDeviceMgrAgent agent;

        public static NDeviceMgrAgentCommand make(BAbstractManager manager, BINDeviceMgrAgent devMgrAgent) {
            String uiName = devMgrAgent.getUiName();
            if (uiName == null) {
                return new NDeviceMgrAgentCommand(manager, devMgrAgent, "??");
            }
            Lexicon lex = Sys.loadModule((String)devMgrAgent.getType().getTypeSpec().getModuleName()).getLexicon();
            if (lex == null) {
                return new NDeviceMgrAgentCommand(manager, devMgrAgent, uiName);
            }
            String lexLabel = lex.get(uiName + ".label");
            if (lexLabel == null) {
                return new NDeviceMgrAgentCommand(manager, devMgrAgent, lex.getText(uiName));
            }
            return new NDeviceMgrAgentCommand(manager, lex, devMgrAgent);
        }

        NDeviceMgrAgentCommand(BAbstractManager manager, BINDeviceMgrAgent mgrAgent, String label) {
            super((BWidget)manager, label);
            this.agent = mgrAgent;
            this.setFlags(mgrAgent.getFlags());
        }

        NDeviceMgrAgentCommand(BAbstractManager manager, Lexicon lex, BINDeviceMgrAgent mgrAgent) {
            super((BWidget)manager, lex, mgrAgent.getUiName());
            this.agent = mgrAgent;
            this.setFlags(this.agent.getFlags());
        }

        public CommandArtifact doInvoke() throws Exception {
            BNDeviceManager devMgr = (BNDeviceManager)this.getOwner();
            CommandArtifact retVal = this.agent.doInvoke(devMgr, NMgrUtil.findNNetwork((BAbstractManager)devMgr));
            devMgr.getController().updateCommands();
            return retVal;
        }

        public BINDeviceMgrAgent getAgent() {
            return this.agent;
        }
    }
}

