/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.ui;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.point.BNPointDeviceExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;

public final class NMgrUtil {
    public static final Lexicon LEX = Lexicon.make(NMgrUtil.class);

    private NMgrUtil() {
    }

    public static Type getDiscoveryLeafType(BAbstractManager mgr) {
        BNDiscoveryPreferences prefs;
        BINDiscoveryHost discoveryHost = NMgrUtil.findDiscoveryHost(mgr);
        if (discoveryHost != null && (prefs = discoveryHost.getDiscoveryPreferences()) != null) {
            return prefs.getDiscoveryLeafType();
        }
        return null;
    }

    public static BINDiscoveryLeaf getDiscoveryLeafInstance(BAbstractManager mgr) {
        Type discoveryLeafType = NMgrUtil.getDiscoveryLeafType(mgr);
        if (discoveryLeafType != null && discoveryLeafType.is(BINDiscoveryLeaf.TYPE)) {
            return (BINDiscoveryLeaf)discoveryLeafType.getInstance();
        }
        return null;
    }

    static Type getDatabaseType(BAbstractManager mgr) {
        BObject val = mgr.getCurrentValue();
        if (val instanceof BIPointFolder) {
            return ((BIPointFolder)val).getProxyExtType();
        }
        if (val instanceof BIDeviceFolder) {
            return ((BIDeviceFolder)val).getDeviceType();
        }
        throw new BajaRuntimeException("Not Implemented");
    }

    public static BComponent getDatabaseInstanceDefault(BAbstractManager mgr) {
        Type typ = NMgrUtil.getDatabaseType(mgr);
        if (typ.isAbstract()) {
            throw new BajaRuntimeException("Must specify non abstract class: " + typ.getTypeClass().getName() + " is abstract.");
        }
        return (BComponent)typ.getInstance();
    }

    public static BNNetwork findNNetwork(BAbstractManager mgr) {
        return (BNNetwork)NMgrUtil.findType(mgr, BNNetwork.TYPE);
    }

    public static BDevice findNDevice(BAbstractManager mgr) {
        return (BDevice)NMgrUtil.findType(mgr, BDevice.TYPE);
    }

    public static BINDiscoveryHost findDiscoveryHost(BAbstractManager mgr) {
        BComplex obj = (BComplex)mgr.getCurrentValue();
        if (obj instanceof BINDiscoveryHost) {
            return (BINDiscoveryHost)obj;
        }
        return null;
    }

    public static BNPointDeviceExt findNPointDeviceExt(BAbstractManager mgr) {
        return (BNPointDeviceExt)NMgrUtil.findType(mgr, BNPointDeviceExt.TYPE);
    }

    private static BComplex findType(BAbstractManager mgr, Type t) {
        BComplex obj = (BComplex)mgr.getCurrentValue();
        if (obj.getType().is(t)) {
            return obj;
        }
        return DrUtil.getParent((BComplex)obj, (Type)t);
    }
}

