/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.timesync;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.bajax.timesync.BTimeSyncService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serverName", type="String", defaultValue="localhost", flags=8), @NiagaraProperty(name="serverPort", type="int", defaultValue="37"), @NiagaraProperty(name="retries", type="int", defaultValue="5"), @NiagaraProperty(name="timeout", type="int", defaultValue="250", facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=11), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=11), @NiagaraProperty(name="pollDelta", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=11), @NiagaraProperty(name="pollLocalTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="pollServerTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="pollRoundtrip", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=11)})
public class BTimeSyncClient
extends BComponent
implements BIStatus {
    @Generated
    public static final Property serverName = BTimeSyncClient.newProperty((int)8, (String)"localhost", null);
    @Generated
    public static final Property serverPort = BTimeSyncClient.newProperty((int)0, (int)37, null);
    @Generated
    public static final Property retries = BTimeSyncClient.newProperty((int)0, (int)5, null);
    @Generated
    public static final Property timeout = BTimeSyncClient.newProperty((int)0, (int)250, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property status = BTimeSyncClient.newProperty((int)11, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BTimeSyncClient.newProperty((int)11, (String)"", null);
    @Generated
    public static final Property pollDelta = BTimeSyncClient.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    @Generated
    public static final Property pollLocalTime = BTimeSyncClient.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property pollServerTime = BTimeSyncClient.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property pollRoundtrip = BTimeSyncClient.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeSyncClient.class);
    private static final BIcon icon = BIcon.std((String)"connection.png");
    private static Logger log = BTimeSyncService.log;

    @Generated
    public String getServerName() {
        return this.getString(serverName);
    }

    @Generated
    public void setServerName(String v) {
        this.setString(serverName, v, null);
    }

    @Generated
    public int getServerPort() {
        return this.getInt(serverPort);
    }

    @Generated
    public void setServerPort(int v) {
        this.setInt(serverPort, v, null);
    }

    @Generated
    public int getRetries() {
        return this.getInt(retries);
    }

    @Generated
    public void setRetries(int v) {
        this.setInt(retries, v, null);
    }

    @Generated
    public int getTimeout() {
        return this.getInt(timeout);
    }

    @Generated
    public void setTimeout(int v) {
        this.setInt(timeout, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BRelTime getPollDelta() {
        return (BRelTime)this.get(pollDelta);
    }

    @Generated
    public void setPollDelta(BRelTime v) {
        this.set(pollDelta, (BValue)v, null);
    }

    @Generated
    public BAbsTime getPollLocalTime() {
        return (BAbsTime)this.get(pollLocalTime);
    }

    @Generated
    public void setPollLocalTime(BAbsTime v) {
        this.set(pollLocalTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getPollServerTime() {
        return (BAbsTime)this.get(pollServerTime);
    }

    @Generated
    public void setPollServerTime(BAbsTime v) {
        this.set(pollServerTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getPollRoundtrip() {
        return (BRelTime)this.get(pollRoundtrip);
    }

    @Generated
    public void setPollRoundtrip(BRelTime v) {
        this.set(pollRoundtrip, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BTimeSyncService;
    }

    public Report poll() throws IOException {
        BStatus s = this.getStatus();
        try {
            byte[] data = new byte[]{0};
            InetAddress addr = InetAddress.getByName(this.getServerName());
            DatagramPacket req = new DatagramPacket(data, data.length, addr, this.getServerPort());
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(this.getTimeout());
            int num = this.getRetries();
            for (int i = 0; i < num; ++i) {
                try {
                    byte[] buf = new byte[4];
                    DatagramPacket resp = new DatagramPacket(buf, buf.length);
                    long t1 = System.currentTimeMillis();
                    socket.send(req);
                    socket.receive(resp);
                    long t2 = System.currentTimeMillis();
                    int b0 = 0xFF & buf[0];
                    int b1 = 0xFF & buf[1];
                    int b2 = 0xFF & buf[2];
                    int b3 = 0xFF & buf[3];
                    long x = 0xFFFFFFFFL & (long)((b0 << 24) + (b1 << 16) + (b2 << 8) + b3);
                    x = (x - 2208988800L) * 1000L;
                    Report report = new Report();
                    report.roundTrip = t2 - t1;
                    this.setPollRoundtrip(BRelTime.make((long)report.roundTrip));
                    report.oneWayTrip = report.roundTrip / 2L;
                    report.serverTime = x + report.oneWayTrip;
                    BAbsTime t = BAbsTime.make((long)report.serverTime);
                    this.setPollServerTime(t);
                    report.myTime = t2;
                    this.setPollLocalTime(BAbsTime.make((long)t2));
                    report.delta = report.serverTime - report.myTime;
                    this.setPollDelta(BRelTime.make((long)report.delta));
                    this.setStatus(BStatus.makeFault((BStatus)s, (boolean)false));
                    this.setFaultCause("");
                    return report;
                }
                catch (InterruptedIOException x) {
                    log.log(Level.INFO, this.toPathString(), x);
                    continue;
                }
            }
            this.setStatus(BStatus.makeFault((BStatus)s, (boolean)true));
            this.setFaultCause("No response from server.");
            socket.close();
            return null;
        }
        catch (IOException x) {
            log.log(Level.SEVERE, this.toPathString(), x);
            this.setStatus(BStatus.makeFault((BStatus)s, (boolean)true));
            this.setFaultCause(x.toString());
            throw x;
        }
    }

    protected void serviceDisabled(boolean b) {
        BStatus s = this.getStatus();
        if (s.isDisabled() == b) {
            return;
        }
        this.setStatus(BStatus.makeDisabled((BStatus)s, (boolean)b));
    }

    public static class Report {
        public long roundTrip;
        public long oneWayTrip;
        public long myTime;
        public long serverTime;
        public long delta;

        public void dump() {
            System.out.println("TimeReport");
            System.out.println("  roundTrip:  " + this.roundTrip + "ms");
            System.out.println("  oneWayTrip: " + this.oneWayTrip + "ms");
            System.out.println("  myTime:     " + new Date(this.myTime));
            System.out.println("  serverTime: " + new Date(this.serverTime));
            System.out.println("  delta:      " + this.delta + "ms");
        }
    }
}

