/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.virtual;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.report.grid.GridCompUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.baja.agent.AgentList;
import javax.baja.bql.BqlQuery;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.report.grid.BIGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

@NiagaraType(agent={@AgentOn(types={"report:BqlGrid"})})
public class BNiagaraVirtualBqlGrid
extends BNiagaraVirtualComponent
implements BIGrid {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualBqlGrid.class);
    public static final String ORD_COL_NAME = "slotPath";
    public static final int ORD_COL_PREFIX_LENGTH = "slot:".length();
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    public static final String COLUMNS = "columns";
    public static final String ROWS = "rows";
    public static final String QUERY = "query";
    private static final Logger LOG = Logger.getLogger("niagaraVirtualBqlGrid");

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public GridModel resolve(BObject base, Context cx) {
        Map<Object, Object> model = Collections.emptyMap();
        try {
            model = Sys.isStation() ? this.resolveQuery(null) : this.getSysChannel().niagaraRpc(this.getNavOrd(), "resolveQuery", new Object[0]).orElse(Collections.emptyMap());
        }
        catch (Exception err) {
            LOG.log(Level.WARNING, "Could not resolve virtual query", err);
        }
        return new Model(model, base, cx);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)}, permissions="r")
    public Map<String, Collection<?>> resolveQuery(Context cx) throws Exception {
        BVirtualGateway gateway = this.getVirtualGateway();
        if (gateway == null) {
            throw new IllegalStateException("Cannot find gateway");
        }
        BUser user = cx != null ? cx.getUser() : null;
        BCategoryService categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        return this.resolveQuery(this.getComms(), gateway.getNavOrd().relativizeToSession(), user == null ? ord -> true : ord -> BNiagaraVirtualBqlGrid.canReadOrd(ord, categoryService, (BICategorizable)gateway, user), cx);
    }

    private Map<String, Collection<?>> resolveQuery(INiagaraVirtualCommsAdapter comms, BOrd baseOrd, Predicate<BOrd> permissionChecker, Context cx) throws Exception {
        this.loadSlots();
        this.lease();
        BOrd queryOrd = this.getQueryOrd();
        BObject result = comms.resolveBqlQuery(queryOrd, "" + this.getOrdInSession());
        if (!(result instanceof BIDataTable)) {
            throw new IllegalStateException("virtual BQL query must resolve to a table: " + queryOrd);
        }
        ArrayList columns = new ArrayList();
        ArrayList<String> rows = new ArrayList<String>();
        BIDataTable table = (BIDataTable)result;
        ColumnList columnList = table.getColumns();
        if (columnList != null) {
            Column pathColumn = null;
            for (Column col : columnList.list()) {
                if (pathColumn == null) {
                    pathColumn = col;
                    continue;
                }
                HashMap<String, String> colMap = new HashMap<String, String>(2);
                colMap.put(NAME, col.getName());
                colMap.put(DISPLAY_NAME, col.getDisplayName(cx));
                columns.add(colMap);
            }
            try (TableCursor cursor = table.cursor();){
                while (cursor.next()) {
                    Row row = cursor.row();
                    BOrd rowOrd = BNiagaraVirtualBqlGrid.makeVirtualOrd(row.cell(pathColumn).toString(), baseOrd);
                    if (!permissionChecker.test(rowOrd)) continue;
                    rows.add("" + rowOrd);
                }
            }
        }
        HashMap queryInfo = new HashMap();
        queryInfo.put(COLUMNS, columns);
        queryInfo.put(ROWS, rows);
        return queryInfo;
    }

    private BOrd getQueryOrd() {
        BOrd queryOrd = (BOrd)this.get(QUERY);
        if (queryOrd == null || queryOrd.isNull()) {
            throw new IllegalStateException("Could not find query ORD to resolve");
        }
        boolean foundBqlQuery = false;
        OrdQuery[] queries = queryOrd.parse();
        for (int i = 0; i < queries.length; ++i) {
            if (!(queries[i] instanceof BqlQuery)) continue;
            String body = queries[i].getBody();
            if (body.startsWith("select *")) {
                throw new IllegalStateException("You must explicitly specify columns for your query (do not use '*').");
            }
            body = "select slotPath, " + body.substring("select ".length());
            queries[i] = BqlQuery.make((String)body);
            foundBqlQuery = true;
            break;
        }
        if (!foundBqlQuery) {
            throw new IllegalStateException("Could not find BQL query");
        }
        return BOrd.make((BOrd)this.getNiagaraVirtualCompInfo().getSlotOrd(), (BOrd)BOrd.make((OrdQuery[])queries)).normalize().relativizeToSession();
    }

    private static BOrd makeVirtualOrd(String path, BOrd gatewayOrd) {
        SlotPath slotPath = new SlotPath(path.substring(ORD_COL_PREFIX_LENGTH));
        VirtualPath vPath = VirtualPath.convertFromSlotPath((SlotPath)slotPath);
        return BOrd.make((BOrd)gatewayOrd, (OrdQuery)vPath);
    }

    private static boolean canReadOrd(BOrd ord, BCategoryService categoryService, BICategorizable fallbackCategorizable, BUser user) {
        BCategoryMask mask = categoryService.getOrdMap().getAppliedCategoryMask(ord.relativizeToSession());
        if (mask == null) {
            mask = fallbackCategorizable.getAppliedCategoryMask();
        }
        BPermissions permissions = user.getPermissions().getCategoryPermissions(mask);
        return permissions.hasOperatorRead();
    }

    protected BSysChannel getSysChannel() {
        BFoxSession foxSession = (BFoxSession)this.getSession();
        return (BSysChannel)foxSession.getConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    public AgentList getAgents(Context cx) {
        return GridCompUtil.reorderAgents(super.getAgents(cx));
    }

    private static final class Model
    extends GridModel {
        private List<Map<String, String>> columns;
        private List<BFormat> formats;
        private List<OrdTarget> targets;

        private Model(Map<String, Collection<?>> model, BObject base, Context cx) {
            this.columns = model.getOrDefault(BNiagaraVirtualBqlGrid.COLUMNS, Collections.emptyList());
            this.formats = this.columns.stream().map(col -> BFormat.make((String)("%" + (String)col.get(BNiagaraVirtualBqlGrid.NAME) + "%"))).collect(Collectors.toList());
            List<BOrd> ords = model.getOrDefault(BNiagaraVirtualBqlGrid.ROWS, Collections.emptyList()).stream().map(BOrd::make).collect(Collectors.toList());
            BatchResolve resolve = new BatchResolve(ords.toArray(new BOrd[0])).resolve(base, cx);
            this.targets = IntStream.range(0, ords.size()).mapToObj(i -> resolve.isResolved(i) ? resolve.getTarget(i) : null).collect(Collectors.toList());
        }

        @Override
        public int getRowCount() {
            return this.targets.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        @Override
        public String getColumnName(int col) {
            return "" + this.columns.get(col).get(BNiagaraVirtualBqlGrid.NAME);
        }

        @Override
        public BFormat getColumnFormat(int col) {
            return this.formats.get(col);
        }

        @Override
        public OrdTarget getTargetAt(int row, int col) {
            return this.targets.get(row);
        }

        @Override
        public BObject getObjectAt(int row, int col) {
            OrdTarget target = this.getTargetAt(row, col);
            return target == null ? null : target.get();
        }
    }
}

