/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import com.tridium.batchJob.history.BIBatchHistoryRecord;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BITable;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.timezone.BTimeZone;

public class TZFixedHistoryCollectionsCursor<T extends BIBatchHistoryRecord & BIObject>
extends AbstractCursor<T> {
    protected Entry[] entries;
    protected Context cx;
    protected Cursor<? extends BIObject> innerHistoryRecordCursor;
    protected BTimeZone innerTz;
    protected int ix;

    public TZFixedHistoryCollectionsCursor(Entry[] entries) {
        this(entries, null);
    }

    public TZFixedHistoryCollectionsCursor(Entry[] entries, Context cx) {
        this.cx = cx;
        this.entries = entries;
        this.ix = -1;
    }

    public Context getContext() {
        return this.cx;
    }

    protected boolean advanceCursor() {
        while (true) {
            if (this.innerHistoryRecordCursor == null) {
                if (this.ix >= this.entries.length - 1) {
                    return false;
                }
                ++this.ix;
                this.innerHistoryRecordCursor = this.entries[this.ix].historyRecordCollection.cursor();
                this.innerTz = this.entries[this.ix].tz;
                continue;
            }
            if (this.innerHistoryRecordCursor.next()) {
                return true;
            }
            this.innerHistoryRecordCursor = null;
        }
    }

    protected T doGet() {
        BIBatchHistoryRecord rec = (BIBatchHistoryRecord)((BIBatchHistoryRecord)this.innerHistoryRecordCursor.get()).asObject().asComplex().newCopy();
        rec.setLocalTimeZone(this.innerTz);
        return (T)rec;
    }

    public static final class Entry {
        protected BTimeZone tz;
        protected BITable<?> historyRecordCollection;

        public Entry(BTimeZone tz, BITable<?> collection) {
            this.tz = tz;
            this.historyRecordCollection = collection;
        }
    }
}

