/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.driver.history;

import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.history.BJobStepHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BIDeviceStepSummary;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"batchJob:DeviceJobStep"})})
@NiagaraProperties(value={@NiagaraProperty(name="deviceId", type="BSimple", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="deviceType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1)})
public class BDeviceStepHistoryRecord
extends BJobStepHistoryRecord
implements BIAgent,
BIDeviceStepSummary {
    @Generated
    public static final Property deviceId = BDeviceStepHistoryRecord.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property deviceType = BDeviceStepHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceStepHistoryRecord.class);

    @Override
    @Generated
    public BSimple getDeviceId() {
        return (BSimple)this.get(deviceId);
    }

    @Generated
    public void setDeviceId(BSimple v) {
        this.set(deviceId, (BValue)v, null);
    }

    @Override
    @Generated
    public BTypeSpec getDeviceType() {
        return (BTypeSpec)this.get(deviceType);
    }

    @Generated
    public void setDeviceType(BTypeSpec v) {
        this.set(deviceType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceStepHistoryRecord() {
    }

    public BDeviceStepHistoryRecord(BDeviceStepDetails stepDetails, BAbsTime jobStartTime) {
        super(stepDetails, jobStartTime);
        this.update(stepDetails);
    }

    @Override
    public BJobStepDetails getStepDetails(BObject base) throws Exception {
        if (this.stepDetails == null) {
            try {
                BBatchJobStepLogFile file = BBatchJobStepLogFile.find(this.getStepType(), this.getLocalStartTime(), base);
                this.stepDetails = file.getDetails();
                this.stepDetails.setStartTimeLocalZone(this.localTz);
                this.stepDetails.setDisplayTimeZone(this.getTimestamp().getTimeZone());
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }
        return this.stepDetails;
    }

    @Override
    public void update(BJobStepDetails stepDetails) {
        super.update(stepDetails);
        this.setDeviceId(((BDeviceStepDetails)stepDetails).getDeviceId());
        this.setDeviceType(((BDeviceStepDetails)stepDetails).getDeviceType());
    }

    @Override
    protected void doRead(DataInput in) throws IOException {
        super.doRead(in);
        BTypeSpec deviceIdType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(in.readUTF());
        this.setDeviceId((BSimple)((BSimple)deviceIdType.getInstance()).decodeFromString(in.readUTF()));
        this.setDeviceType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(in.readUTF()));
    }

    @Override
    protected void doWrite(DataOutput out) throws IOException {
        super.doWrite(out);
        out.writeUTF(this.getDeviceId().getType().getTypeSpec().encodeToString());
        out.writeUTF(this.getDeviceId().encodeToString());
        out.writeUTF(this.getDeviceType().encodeToString());
    }
}

