/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.history;

import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BIBatchHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.history.BHistoryRecord;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="jobType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="jobState", type="BJobState", defaultValue="BJobState.unknown", flags=1), @NiagaraProperty(name="prototypeOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="endTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="submitUser", type="String", defaultValue="unknown", flags=1), @NiagaraProperty(name="disposed", type="boolean", defaultValue="false", flags=1)})
public abstract class BBatchJobHistoryRecord
extends BHistoryRecord
implements BIBatchJobSummary,
BIBatchHistoryRecord {
    @Generated
    public static final Property jobType = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property jobState = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BJobState.unknown, null);
    @Generated
    public static final Property prototypeOrd = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property endTime = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property submitUser = BBatchJobHistoryRecord.newProperty((int)1, (String)"unknown", null);
    @Generated
    public static final Property disposed = BBatchJobHistoryRecord.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchJobHistoryRecord.class);
    private BBatchJob job;
    private BTimeZone localTz = BTimeZone.NULL;

    @Override
    @Generated
    public BTypeSpec getJobType() {
        return (BTypeSpec)this.get(jobType);
    }

    @Generated
    public void setJobType(BTypeSpec v) {
        this.set(jobType, (BValue)v, null);
    }

    @Override
    @Generated
    public BJobState getJobState() {
        return (BJobState)this.get(jobState);
    }

    @Generated
    public void setJobState(BJobState v) {
        this.set(jobState, (BValue)v, null);
    }

    @Override
    @Generated
    public BOrd getPrototypeOrd() {
        return (BOrd)this.get(prototypeOrd);
    }

    @Generated
    public void setPrototypeOrd(BOrd v) {
        this.set(prototypeOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    @Generated
    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    @Override
    @Generated
    public String getSubmitUser() {
        return this.getString(submitUser);
    }

    @Generated
    public void setSubmitUser(String v) {
        this.setString(submitUser, v, null);
    }

    @Override
    @Generated
    public boolean getDisposed() {
        return this.getBoolean(disposed);
    }

    @Generated
    public void setDisposed(boolean v) {
        this.setBoolean(disposed, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBatchJobHistoryRecord() {
    }

    protected BBatchJobHistoryRecord(BBatchJob job) throws UnresolvedException {
        this.updateJob(job);
    }

    @Override
    public void updateJob(BBatchJob job) {
        this.job = job;
        this.setSubmitUser(job.getSubmitUser());
        this.setJobType(job.getType().getTypeSpec());
        this.setJobState(job.getJobState());
        this.setStartTime(job.getStartTime());
        this.setEndTime(job.getEndTime());
        this.setPrototypeOrd(job.getPrototypeOrd());
    }

    @Override
    public BBatchJob getJob(BObject base) throws Exception {
        if (this.job == null) {
            this.job = BBatchJob.find(BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.getStartTime().getTimeZone()), base);
            if (this.job != null) {
                this.job.setStartTimeLocalZone(this.localTz);
                if (!this.job.isMounted()) {
                    this.job.setDisplayTimeZone(this.getStartTime().getTimeZone());
                }
            }
        }
        return this.job;
    }

    public void setStartTime(BAbsTime value) {
        this.setTimestamp(value);
    }

    @Override
    public BAbsTime getStartTime() {
        return this.getTimestamp();
    }

    @Override
    public void setLocalTimeZone(BTimeZone zone) {
        if (!this.localTz.equals((Object)zone)) {
            this.localTz = zone;
        }
    }

    @Override
    public BAbsTime getLocalStartTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.localTz);
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.localTz = BTimeZone.NULL;
        this.setJobType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(in.readUTF()));
        this.setJobState((BJobState)BJobState.unknown.decodeFromString(in.readUTF()));
        this.setPrototypeOrd((BOrd)BOrd.DEFAULT.decodeFromString(in.readUTF()));
        this.setEndTime((BAbsTime)BAbsTime.DEFAULT.decodeFromString(in.readUTF()));
        this.setSubmitUser(in.readUTF());
        this.setDisposed(in.readBoolean());
    }

    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getJobType().encodeToString());
        out.writeUTF(this.getJobState().encodeToString());
        out.writeUTF(this.getPrototypeOrd().encodeToString());
        out.writeUTF(this.getEndTime().encodeToString());
        out.writeUTF(this.getSubmitUser());
        out.writeBoolean(this.getDisposed());
    }
}

