/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.util.EscUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.collection.AbstractCursor;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BValueList
extends BSimple {
    public static final BValueList DEFAULT = new BValueList(BValue.TYPE.getTypeSpec(), new BValue[0], "");
    public static final Type TYPE = Sys.loadType(BValueList.class);
    public static final BValueList NULL = DEFAULT;
    private static final EscUtil ESCAPER = new EscUtil(){

        public boolean isStart(int c) {
            return this.isPart(c);
        }

        public boolean isPart(int c) {
            switch (c) {
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 45: 
                case 46: 
                case 64: 
                case 91: 
                case 93: 
                case 96: {
                    return true;
                }
            }
            return EscUtil.slot.isPart(c);
        }
    };
    private int hashCode = -1;
    private BValue[] values;
    private String string;
    private BTypeSpec itemType;

    public Type getType() {
        return TYPE;
    }

    public static BValueList make(BValue value) {
        return new BValueList(value.getType().getTypeSpec(), new BValue[]{value}, null);
    }

    public static BValueList make(BValue[] values) {
        if (values == null || values.length == 0) {
            return NULL;
        }
        return new BValueList(values[0].getType().getTypeSpec(), (BValue[])values.clone(), null);
    }

    public static BValueList add(BValueList orig, BValue value) {
        BValue[] values = new BValue[orig.values.length + 1];
        System.arraycopy(orig.values, 0, values, 0, orig.values.length);
        values[values.length - 1] = value;
        return new BValueList(value.getType().getTypeSpec(), values, null);
    }

    public static BValueList remove(BValueList orig, int index) {
        BValue[] values = new BValue[orig.values.length - 1];
        System.arraycopy(orig.values, 0, values, 0, index);
        if (index < orig.values.length) {
            System.arraycopy(orig.values, index + 1, values, index, orig.values.length - index - 1);
        }
        return new BValueList(orig.getItemType(), values, null);
    }

    public static BValueList make(String string) throws IOException {
        return (BValueList)DEFAULT.decodeFromString(string);
    }

    public BValue getValue(int index) {
        return this.values[index];
    }

    public BTypeSpec getItemType() {
        return this.itemType;
    }

    public int size() {
        return this.values.length;
    }

    public boolean isNull() {
        return this.values.length == 0;
    }

    public BValue[] toArray() {
        BValue[] result = (BValue[])Array.newInstance(this.itemType.getResolvedType().getTypeClass(), this.values.length);
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        return result;
    }

    public static String encodeValue(BValue value) throws IOException {
        return ESCAPER.escape(((BIEncodable)value).encodeToString());
    }

    public static BValue decodeValue(BIEncodable itemProto, String encoded) throws IOException {
        return (BValue)itemProto.decodeFromString(ESCAPER.unescape(encoded));
    }

    public static BValue decodeValue(BTypeSpec itemType, String encoded) throws IOException {
        return BValueList.decodeValue((BIEncodable)itemType.getInstance(), encoded);
    }

    public boolean contains(BValue value) {
        for (BValue value1 : this.values) {
            if (!value1.equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public BObject[] list() {
        return this.toArray();
    }

    public BObject[] list(BObject[] in) {
        if (!in.getClass().getComponentType().isAssignableFrom(this.getItemType().getResolvedType().getTypeClass())) {
            throw new ClassCastException(in.getClass().getComponentType().getName() + " != " + this.getItemType().getResolvedType().getTypeClass().getName());
        }
        BObject[] result = in.length > this.size() ? (BObject[])Array.newInstance(in.getClass().getComponentType(), this.size()) : in;
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public BObject get(int index) {
        return this.getValue(index);
    }

    private BValueList(BTypeSpec itemType, BValue[] values, String string) {
        this.itemType = itemType;
        this.values = values;
        this.string = string;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int x = 11;
            x ^= this.itemType.hashCode();
            for (BValue value : this.values) {
                x ^= value.hashCode();
            }
            this.hashCode = x;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BValueList) {
            BValueList l = (BValueList)((Object)obj);
            if (!this.getItemType().equals((Object)l.getItemType())) {
                return false;
            }
            BValue[] a = this.values;
            BValue[] b = l.values;
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals((Object)b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.values.length == 0) {
                this.string = "";
            } else {
                StringBuilder s = new StringBuilder();
                s.append(this.getItemType().encodeToString());
                for (BValue value : this.values) {
                    s.append('\n');
                    s.append(BValueList.encodeValue(value));
                }
                this.string = s.toString();
            }
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.length() == 0) {
            return DEFAULT;
        }
        int nl = s.indexOf(10);
        if (nl < 0) {
            return new BValueList((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(s), new BValue[0], s);
        }
        ArrayList<BValue> list = new ArrayList<BValue>();
        BTypeSpec resultType = null;
        BIEncodable resultProto = null;
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            if (resultType == null) {
                resultType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(st.nextToken());
                resultProto = (BIEncodable)resultType.getInstance();
                continue;
            }
            list.add(BValueList.decodeValue(resultProto, st.nextToken()));
        }
        return new BValueList(resultType, list.toArray(new BValue[0]), s);
    }

    public String toString(Context cx) {
        if (this.values.length == 1) {
            return this.values[0].toString(cx);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(this.values[i].toString(cx));
        }
        return buf.toString();
    }

    private class ArrayCursor
    extends AbstractCursor<BValue> {
        private int index = -1;

        private ArrayCursor() {
        }

        protected boolean advanceCursor() {
            if (this.index < BValueList.this.size() - 1) {
                ++this.index;
                return true;
            }
            return false;
        }

        protected BValue doGet() {
            return BValueList.this.getValue(this.index);
        }
    }
}

