/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import java.io.IOException;
import java.util.ArrayList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="devicesToProcess", type="BValueList", defaultValue="BValueList.DEFAULT", flags=1)})
public class BDeviceNetworkJob
extends BBatchJob {
    @Generated
    public static final Property networkOrd = BDeviceNetworkJob.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property devicesToProcess = BDeviceNetworkJob.newProperty((int)1, (BValue)BValueList.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceNetworkJob.class);
    public static final String EXCLUDE_FROM_PROGRESS = "ExcludeFromProgress";

    @Generated
    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    @Generated
    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    @Generated
    public BValueList getDevicesToProcess() {
        return (BValueList)this.get(devicesToProcess);
    }

    @Generated
    public void setDevicesToProcess(BValueList v) {
        this.set(devicesToProcess, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceNetworkJob() {
    }

    public BDeviceNetworkJob(BOrd networkOrd) {
        this.setNetworkOrd(networkOrd);
    }

    public BDeviceNetworkJob(BOrd networkOrd, BSimple deviceId) throws IOException {
        this(networkOrd);
        this.setDevicesToProcess(BValueList.make((BValue)deviceId));
    }

    public BDeviceNetworkJob(BOrd networkOrd, BSimple[] deviceIds) throws IOException {
        this(networkOrd);
        this.setDevicesToProcess(BValueList.make((BValue[])deviceIds));
    }

    @Override
    public BatchJobOp makeOp(Context cx) {
        return new DeviceNetworkJobOp(cx);
    }

    public BDeviceNetwork getNetwork() {
        return (BDeviceNetwork)this.getNetworkOrd().get((BObject)this);
    }

    public BDevice[] getDevices() {
        BDeviceNetwork nw = this.getNetwork();
        BNetworkBatchAgent batchAgent = BNetworkBatchAgent.get(nw, null);
        ArrayList<BDevice> result = new ArrayList<BDevice>();
        for (BValue deviceId : this.getDevicesToProcess().toArray()) {
            try {
                BDevice device = batchAgent.getBatchDevice(nw, (BSimple)deviceId);
                if (device == null) {
                    this.log().message("batchJob", "DeviceNetworkJob.deviceNotFound", deviceId.toString(null));
                    continue;
                }
                result.add(device);
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }
        return result.toArray(new BDevice[0]);
    }
}

