/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceId", type="BSimple", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="deviceType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="deviceDisplayName", type="String", defaultValue="", flags=1)})
public class BDeviceStepDetails
extends BJobStepDetails
implements ICancelHint {
    @Generated
    public static final Property deviceId = BDeviceStepDetails.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property deviceType = BDeviceStepDetails.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property deviceDisplayName = BDeviceStepDetails.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceStepDetails.class);
    private BBatchJobStepLogFile logFile = null;
    private static final Logger LOGGER = Logger.getLogger("batchJob");

    @Generated
    public BSimple getDeviceId() {
        return (BSimple)this.get(deviceId);
    }

    @Generated
    public void setDeviceId(BSimple v) {
        this.set(deviceId, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getDeviceType() {
        return (BTypeSpec)this.get(deviceType);
    }

    @Generated
    public void setDeviceType(BTypeSpec v) {
        this.set(deviceType, (BValue)v, null);
    }

    @Generated
    public String getDeviceDisplayName() {
        return this.getString(deviceDisplayName);
    }

    @Generated
    public void setDeviceDisplayName(String v) {
        this.setString(deviceDisplayName, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceStepDetails() {
    }

    public BDeviceStepDetails(BDevice device, BDeviceJobStep jobStep) {
        super(jobStep);
        this.setDevice(device);
        this.setStepType(jobStep.getType().getTypeSpec());
        this.setStartTime(BAbsTime.now());
        this.setStepDescription(jobStep.toString(null));
        this.setStageName(jobStep.getStage().getStageName());
        this.setDeviceDisplayName(device.getDisplayName(null));
        this.step = jobStep;
        this.log = new JobLog();
    }

    public void setDevice(BDevice device) {
        this.setDeviceId(BNetworkBatchAgent.get(device.getNetwork(), null).getBatchDeviceId(device));
        this.setDeviceType(device.getType().getTypeSpec());
    }

    public BDevice getDevice() {
        if (this.getStage() == null) {
            return null;
        }
        return BNetworkBatchAgent.get(this.getForEachDeviceStage().getNetwork(), null).getBatchDevice(this.getForEachDeviceStage().getNetwork(), this.getDeviceId());
    }

    public BForEachDeviceStage getForEachDeviceStage() {
        return (BForEachDeviceStage)this.getStage();
    }

    public BForEachDeviceStage getForEachDeviceStage(BDeviceNetworkJob job) {
        return (BForEachDeviceStage)this.getStage(job);
    }

    @Override
    public void doCancel() {
        BJobState deviceState = this.getState();
        if (deviceState.isRunning()) {
            this.setState(BJobState.canceling);
            this.getForEachDeviceStage().cancelDevice(this.getDeviceId());
        } else if (deviceState != BJobState.success && deviceState != BJobState.failed) {
            this.setState(BJobState.canceled);
            this.getForEachDeviceStage().cancelDevice(this.getDeviceId());
        }
    }

    @Override
    public void doDispose() throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of supervisor vm");
        }
        super.doDispose();
        try {
            BBatchJobStepLogFile logFile = BBatchJobStepLogFile.find(this, null);
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Deleting log file " + logFile.getFilePath().getBody());
                }
                AccessController.doPrivileged(() -> {
                    logFile.delete();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error deleting log file " + logFile.getFilePath().getBody(), e);
            }
        }
        catch (UnresolvedException ue) {
            LOGGER.log(Level.FINE, "Log file not found", ue);
        }
    }

    @Override
    public void success() {
        this.success("batchJob", "DeviceStepDetails.stepCompleted", new String[]{this.getDeviceId().toString()});
        this.complete(BJobState.success);
    }

    @Override
    public void failed(Throwable cause) {
        this.failed("batchJob", "DeviceStepDetails.stepFailed", new String[]{this.getStepDescription(), this.getDeviceId().toString()}, cause);
        this.complete(BJobState.failed);
    }

    @Override
    public void setLogFile(BIFile value) {
        this.logFile = (BBatchJobStepLogFile)value;
    }

    @Override
    public BIFile getLogFile() {
        if (this.logFile == null) {
            this.logFile = BBatchJobStepLogFile.find(this, null);
        }
        return this.logFile;
    }

    @Override
    public BIFile findLogFile(BObject base) throws Exception {
        return BBatchJobStepLogFile.find(this.getStepType(), this.getLocalStartTime(), base);
    }

    @Override
    public BString doReadLog() {
        if (this.log == null) {
            BBatchJobStepLogFile logFile = this.logFile;
            if (logFile == null) {
                logFile = (BBatchJobStepLogFile)this.getLogFile();
            }
            if (logFile == null) {
                return BString.DEFAULT;
            }
            try {
                return logFile.getLogContents();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException();
            }
        }
        return BString.make((String)this.log.encode());
    }

    public boolean isCanceled() {
        return this.getForEachDeviceStage().isCanceled(this.getDeviceId());
    }
}

