/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.BNetworkJobStage;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="networkOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="devicesToProcess", type="BValueList", defaultValue="BValueList.DEFAULT", flags=1)})
public class BNetworkStepDetails
extends BJobStepDetails {
    @Generated
    public static final Property networkType = BNetworkStepDetails.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property networkOrd = BNetworkStepDetails.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property devicesToProcess = BNetworkStepDetails.newProperty((int)1, (BValue)BValueList.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNetworkStepDetails.class);
    private BBatchJobStepLogFile logFile = null;
    private static final Logger LOGGER = Logger.getLogger("batchJob");

    @Generated
    public BTypeSpec getNetworkType() {
        return (BTypeSpec)this.get(networkType);
    }

    @Generated
    public void setNetworkType(BTypeSpec v) {
        this.set(networkType, (BValue)v, null);
    }

    @Generated
    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    @Generated
    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    @Generated
    public BValueList getDevicesToProcess() {
        return (BValueList)this.get(devicesToProcess);
    }

    @Generated
    public void setDevicesToProcess(BValueList v) {
        this.set(devicesToProcess, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNetworkStepDetails() {
    }

    public BNetworkStepDetails(BNetworkJobStep jobStep, BDevice[] devicesToProcess) {
        super(jobStep);
        this.setNetwork(((BDeviceNetworkJob)jobStep.getJob()).getNetwork());
        if (devicesToProcess.length > 0) {
            BNetworkBatchAgent batchAgent = BNetworkBatchAgent.get(devicesToProcess[0]);
            BSimple[] deviceIds = new BSimple[devicesToProcess.length];
            for (int i = 0; i < deviceIds.length; ++i) {
                deviceIds[i] = batchAgent.getBatchDeviceId(devicesToProcess[i]);
            }
            this.setDevicesToProcess(BValueList.make((BValue[])deviceIds));
        }
    }

    public void setNetwork(BDeviceNetwork network) {
        this.setNetworkType(network.getType().getTypeSpec());
        this.setNetworkOrd(network.getOrdInSpace());
    }

    public BDeviceNetwork getNetwork() {
        return this.step == null ? (BDeviceNetwork)this.getNetworkOrd().get() : ((BDeviceNetworkJob)this.step.getJob()).getNetwork();
    }

    public BNetworkJobStage getNetworkJobStage() {
        return (BNetworkJobStage)this.getStage();
    }

    public BNetworkJobStage getNetworkJobStage(BDeviceNetworkJob job) {
        return (BNetworkJobStage)this.getStage(job);
    }

    @Override
    public void doCancel() {
        BJobState stepState = this.getState();
        if (stepState.isRunning()) {
            this.setState(BJobState.canceling);
        } else if (stepState != BJobState.success && stepState != BJobState.failed) {
            this.setState(BJobState.canceled);
        }
    }

    @Override
    public void doDispose() throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        super.doDispose();
        try {
            BBatchJobStepLogFile logFile = BBatchJobStepLogFile.find(this, null);
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Deleting log file " + logFile.getFilePath().getBody());
                }
                AccessController.doPrivileged(() -> {
                    logFile.delete();
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error deleting log file " + logFile.getFilePath().getBody(), e);
            }
        }
        catch (UnresolvedException ue) {
            LOGGER.log(Level.FINE, "Log file not found", ue);
        }
    }

    @Override
    public void setLogFile(BIFile value) {
        this.logFile = (BBatchJobStepLogFile)value;
    }

    @Override
    public BIFile getLogFile() {
        if (this.logFile == null) {
            this.logFile = BBatchJobStepLogFile.find(this, null);
        }
        return this.logFile;
    }

    @Override
    public BIFile findLogFile(BObject base) throws Exception {
        return BBatchJobStepLogFile.find(this.getStepType(), this.getLocalStartTime(), base);
    }

    @Override
    public BString doReadLog() {
        if (this.log == null) {
            BBatchJobStepLogFile logFile = this.logFile;
            if (logFile == null) {
                logFile = (BBatchJobStepLogFile)this.getLogFile();
            }
            if (logFile == null) {
                return BString.DEFAULT;
            }
            try {
                return logFile.getLogContents();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException();
            }
        }
        return BString.make((String)this.log.encode());
    }
}

