/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.retention;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.retention.BIDomainRetentionPolicy;
import javax.baja.retention.BIRetainable;
import javax.baja.retention.BIRetentionPolicyDomain;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BObject;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BKeepNExecutionsRetentionPolicy
extends BRetentionPolicy
implements BIDomainRetentionPolicy {
    public static final BKeepNExecutionsRetentionPolicy DEFAULT = new BKeepNExecutionsRetentionPolicy(10, true);
    public static final Type TYPE = Sys.loadType(BKeepNExecutionsRetentionPolicy.class);
    private int numberToRetain = 10;
    private boolean countOnlySuccessful = true;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BKeepNExecutionsRetentionPolicy(int numberToRetain, boolean countOnlySuccessful) {
        this.numberToRetain = numberToRetain;
        this.countOnlySuccessful = countOnlySuccessful;
    }

    public int getNumberToRetain() {
        return this.numberToRetain;
    }

    public boolean getCountOnlySuccessful() {
        return this.countOnlySuccessful;
    }

    @Override
    public Type[] getApplicableDomainTypes() {
        return new Type[]{BBatchJobPrototype.TYPE};
    }

    @Override
    public void executePolicy(BIRetentionPolicyDomain domain) {
        TreeSet<BBatchJob> setToCull = new TreeSet<BBatchJob>(new ExecutionDateComparator());
        IterableCursor<? extends BIRetainable> c = domain.getRetainables();
        while (c.next()) {
            BBatchJob j = (BBatchJob)c.get();
            j.lease();
            if (!j.getJobState().isComplete()) continue;
            setToCull.add(j);
        }
        if (setToCull.size() > this.getNumberToRetain()) {
            Iterator iter = setToCull.iterator();
            int jobCount = 0;
            while (iter.hasNext()) {
                BBatchJob j = (BBatchJob)iter.next();
                if (!this.getCountOnlySuccessful()) {
                    ++jobCount;
                } else if (j.getJobState() == BJobState.success || jobCount >= this.getNumberToRetain()) {
                    ++jobCount;
                }
                if (jobCount <= this.getNumberToRetain()) continue;
                j.dispose();
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof BKeepNExecutionsRetentionPolicy && ((BKeepNExecutionsRetentionPolicy)obj).getNumberToRetain() == this.getNumberToRetain() && ((BKeepNExecutionsRetentionPolicy)obj).getCountOnlySuccessful() == this.getCountOnlySuccessful();
    }

    public int hashCode() {
        return this.numberToRetain * 2 + (this.countOnlySuccessful ? 1 : 0);
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    public String encodeToString() throws IOException {
        return String.valueOf(this.getNumberToRetain()) + ',' + String.valueOf(this.getCountOnlySuccessful());
    }

    public BObject decodeFromString(String s) throws IOException {
        StringTokenizer tokens = new StringTokenizer(s, ",");
        return new BKeepNExecutionsRetentionPolicy(Integer.parseInt(tokens.nextToken()), Boolean.valueOf(tokens.nextToken()));
    }

    private class ExecutionDateComparator
    implements Comparator<BBatchJob> {
        private ExecutionDateComparator() {
        }

        @Override
        public int compare(BBatchJob j1, BBatchJob j2) {
            if (j1.getEndTime().isNull() || j2.getEndTime().isNull()) {
                return -1 * j1.getStartTime().compareTo((Object)j2.getStartTime());
            }
            return -1 * j1.getEndTime().compareTo((Object)j2.getEndTime());
        }
    }
}

