/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.menu;

import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionRecord;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPointPage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BIntrusionArmingPage
extends BIntrusionPage {
    @Generated
    public static final Type TYPE = Sys.loadType(BIntrusionArmingPage.class);
    public static Lexicon lex = Lexicon.make(BIntrusionService.class);
    public static String NORMAL_ARM = lex.getText("armNormallyWithTimeDelay");
    public static String ARMING_TEST = lex.getText("armingTest");
    public static String FORCE_ARM = lex.getText("forceArm");
    public static String FORCE_ARM_TD = lex.getText("forceArmWithTimeDelay");
    public static String TEST_SUCCESS = lex.getText("armingTestSuccess");
    public static String DISARM = lex.getText("disarm");
    public boolean executed = false;
    private BIntrusionZone[] zones;
    private String armingType;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIntrusionArmingPage() {
    }

    public BIntrusionArmingPage(String armingType) {
        this.armingType = armingType;
    }

    public BIntrusionArmingPage(BIntrusionZone zone, String armingType) {
        this(new BIntrusionZone[]{zone}, armingType);
    }

    public BIntrusionArmingPage(BIntrusionZone[] zones, String armingType) {
        this.zones = zones;
        this.armingType = armingType;
    }

    @Override
    public void doExecute() {
        if (!this.executed) {
            int i;
            this.data.clear();
            this.executed = true;
            String pinAuthorization = this.getDisplay().getAuthorization();
            String keypadAuthorization = IntrusionUtil.text((String)"intrusionKeypadAuthorization", (Object[])new Object[]{this.getDisplay().getDisplayName(null)});
            BIntrusionRecord record = new BIntrusionRecord();
            record.setLocation(keypadAuthorization);
            record.setAuthority(pinAuthorization);
            boolean successfulArm = true;
            for (i = 0; i < this.zones.length; ++i) {
                BIntrusionRecord forcedRecord;
                if (this.armingType.equals(NORMAL_ARM) || this.armingType.equals(ARMING_TEST)) {
                    String activePoints = this.zones[i].doArmingTest(null).toString();
                    if (activePoints.length() <= 0) continue;
                    successfulArm = false;
                    if (this.armingType.equals(NORMAL_ARM)) {
                        this.zones[i].toggle((BIntrusionRecord)record.newCopy());
                        continue;
                    }
                    this.data.add((Object)this.zones[i].getDisplayName(null));
                    this.data.add((Object)"Test Failed");
                    this.data.add((Object)BIntrusionArmingPage.getPointToDisplay(activePoints, this.getDisplay().getPointDisplay()));
                    this.setCursorLine(2);
                    continue;
                }
                if (this.armingType.equals(FORCE_ARM)) {
                    forcedRecord = (BIntrusionRecord)record.newCopy();
                    this.zones[i].doForceArmZone((Context)forcedRecord);
                    continue;
                }
                if (this.armingType.equals(FORCE_ARM_TD)) {
                    forcedRecord = (BIntrusionRecord)record.newCopy();
                    this.zones[i].doForceArmZoneWithTimeDelay((Context)forcedRecord);
                    continue;
                }
                if (!this.armingType.equals(DISARM) || this.zones[i].getZoneStatus() == BIntrusionStatusEnum.disarmed || this.zones[i].getZoneStatus() == BIntrusionStatusEnum.unableToArm) continue;
                this.zones[i].toggle((BIntrusionRecord)record.newCopy());
            }
            if (successfulArm && this.armingType.equals(NORMAL_ARM)) {
                for (i = 0; i < this.zones.length; ++i) {
                    if (this.zones[i].getZoneStatus() != BIntrusionStatusEnum.unableToArm && this.zones[i].getZoneStatus() != BIntrusionStatusEnum.disarmed) continue;
                    this.zones[i].toggle((BIntrusionRecord)record.newCopy());
                }
            } else if (successfulArm && this.armingType.equals(ARMING_TEST)) {
                this.data.add((Object)TEST_SUCCESS);
            }
        }
        if (!this.armingType.equals(ARMING_TEST) && this.getDisplay() != null) {
            this.getDisplay().goBack();
        }
    }

    @Override
    public void doUp() {
        super.doUp();
        super.doUp();
        super.doUp();
        super.doUp();
        super.doUp();
        super.doDown();
        super.doDown();
    }

    @Override
    public void doDown() {
        super.doDown();
        super.doDown();
        super.doDown();
    }

    @Override
    public boolean hasUp() {
        return this.getDataPosition() > 2;
    }

    @Override
    public boolean hasDown() {
        return this.getDataPosition() + 1 < this.data.size() - 1;
    }

    @Override
    public BIntrusionPage doIn() {
        if (this.armingType.equals(ARMING_TEST) && ((String)this.data.get(this.getDataPosition())).toString().length() > 0) {
            return new BIntrusionPointPage(((String)this.data.get(this.getDataPosition())).toString());
        }
        return null;
    }

    public void setZones(BIntrusionZone[] zones) {
        this.zones = zones;
    }
}

