/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.factory;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.isom.BISOMConfig;
import com.tridiumx.isom.InvalidInputDataException;
import com.tridiumx.isom.validation.validators.GroupValidator;
import com.tridiumx.isom.validation.validators.Validator;
import com.tridiumx.isom.validation.validators.ValidatorsManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class DataObjectFactory {
    public static BQuery createQueryObject(List<String> uriItems, BISOMConfig isomConfig) throws InvalidInputDataException {
        String entityName = uriItems.get(2).toString();
        String lastItemInURI = uriItems.get(uriItems.size() - 1).toString();
        if (lastItemInURI.equals("config")) {
            String parameter = uriItems.get(3).toString();
            if (!parameter.equals("config")) {
                return DataObjectFactory.createQueryObject(entityName, parameter, isomConfig);
            }
            OrionType orionType = isomConfig.getOrionType(entityName);
            return BSqlQuery.make((OrionType)orionType);
        }
        return null;
    }

    private static BQuery createQueryObject(String entityName, String parameter, BISOMConfig isomConfig) throws InvalidInputDataException {
        Property identifier = isomConfig.getIdentifierProperty(entityName);
        OrionType orionType = isomConfig.getOrionType(entityName);
        return BSqlQuery.make((OrionType)orionType).where(Predicates.eq((Property)identifier, (BSimple)DataObjectFactory.getParameter(parameter, identifier.getType())));
    }

    public static BQuery createQueryObject(List<String> uriItems, Map<String, String[]> queryStringMap, BISOMConfig isomConfig) throws InvalidInputDataException {
        if (queryStringMap == null || queryStringMap.size() == 0) {
            return DataObjectFactory.createQueryObject(uriItems, isomConfig);
        }
        String entityName = uriItems.get(2).toString();
        OrionType orionType = isomConfig.getOrionType(entityName);
        String[] values = null;
        String key = null;
        BExpression exp = null;
        BExpression mainExp = null;
        Property identifier = null;
        BSqlQuery orionObjectGetQuery = BSqlQuery.make((OrionType)orionType);
        Iterator<String> keys = queryStringMap.keySet().iterator();
        boolean hasJoinQuery = false;
        while (keys.hasNext()) {
            key = keys.next();
            identifier = isomConfig.getObjectProperty(entityName, key);
            if (identifier == null) continue;
            values = queryStringMap.get(key);
            if (values.length > 1) {
                throw new InvalidInputDataException(key);
            }
            if (values[0] == null || values[0].trim().length() == 0) {
                throw new InvalidInputDataException(key);
            }
            BSimple value = DataObjectFactory.getParameter(values[0], identifier.getType());
            BSqlJoin join = isomConfig.getJoinQuery(identifier, value);
            if (join != null) {
                hasJoinQuery = true;
                orionObjectGetQuery.join(join);
                continue;
            }
            exp = isomConfig.isLikeSearch(orionType, identifier) ? Predicates.like((BExpression)new BSqlField(orionType, identifier), (BString)BString.make((String)("%" + values[0]))) : Predicates.eq((BExpression)new BSqlField(orionType, identifier), (BSimple)value);
            if (mainExp == null) {
                mainExp = exp;
                continue;
            }
            mainExp = Predicates.and((BExpression)mainExp, (BExpression)exp);
        }
        if (mainExp != null) {
            return orionObjectGetQuery.where(mainExp);
        }
        if (hasJoinQuery) {
            return orionObjectGetQuery;
        }
        return DataObjectFactory.createQueryObject(uriItems, isomConfig);
    }

    private static BSimple getParameter(String parameter, Type identifierType) throws InvalidInputDataException {
        if (parameter == null || parameter.trim().length() == 0) {
            throw new InvalidInputDataException(parameter);
        }
        if (identifierType.is(BUuid.TYPE)) {
            if (DataObjectFactory.isUuid(parameter)) {
                return BUuid.make((String)parameter);
            }
            throw new InvalidInputDataException(parameter);
        }
        return BString.make((String)parameter);
    }

    public static boolean isUuid(String parameter) {
        return Pattern.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$", parameter);
    }

    public static String createResponseJSONString(BISOMConfig isomConfig, BOrionObject[] orionObjects) throws Exception {
        if (orionObjects.length == 1) {
            return DataObjectFactory.createResponseJSONString(isomConfig, orionObjects[0]);
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < orionObjects.length; ++i) {
            jsonArray.put((Object)isomConfig.jsonFromOrionObject(orionObjects[i]));
        }
        return jsonArray.toString();
    }

    private static String createResponseJSONString(BISOMConfig isomConfig, BOrionObject orionObject) throws Exception {
        JSONObject jsonObject = isomConfig.jsonFromOrionObject(orionObject);
        return jsonObject.toString();
    }

    public static String createResourceNotFoundJSONString() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("StatusCode", (Object)"ResourceInstanceNotPresent");
        return jsonObject.toString();
    }

    public static String createResponseJSONString(String responseContant, String id) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(id, (Object)responseContant);
        jsonObject.put("StatusCode", (Object)"ResponseOk");
        return jsonObject.toString();
    }

    public static String createFailureModeJSONString(String statusCode, String statusMsg) {
        if (statusMsg == null) {
            statusMsg = "UnknownErrorOccurred";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(statusCode, (Object)statusMsg);
        return jsonObject.toString();
    }

    public static void validateInputJSONObject(ValidatorsManager validatorsManager, JSONObject jsonObject) throws InvalidInputDataException {
        DataObjectFactory.validateInputJSONObjectGroupValidation(validatorsManager, jsonObject);
        DataObjectFactory.validateInputJSONObjectFieldValidation(validatorsManager, jsonObject);
    }

    public static void validateInputJSONObjectGroupValidation(ValidatorsManager validatorsManager, JSONObject jsonObject) throws InvalidInputDataException {
        List<GroupValidator> validators = validatorsManager.getGroupValidators();
        for (GroupValidator validatorEntry : validators) {
            if (validatorEntry == null) continue;
            validatorEntry.validate(jsonObject);
        }
    }

    public static void validateInputJSONObjectFieldValidation(ValidatorsManager validatorsManager, JSONObject jsonObject) throws InvalidInputDataException {
        Map<String, Validator> validators = validatorsManager.getValidators();
        for (Map.Entry<String, Validator> validatorEntry : validators.entrySet()) {
            Validator validator = validatorEntry.getValue();
            if (validator == null) continue;
            validator.validate(jsonObject, validatorEntry.getKey());
        }
    }
}

