/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.validation.validators;

import com.tridium.json.JSONObject;
import com.tridiumx.isom.InvalidInputDataException;
import com.tridiumx.isom.validation.validators.GroupValidator;

public class RequiredGroupValidator
implements GroupValidator {
    private String requiredFields;

    public RequiredGroupValidator(String requiredFields) {
        this.requiredFields = requiredFields;
    }

    @Override
    public String getMessage(String info) {
        return lex.getText("validation.required.not.met", new Object[]{info});
    }

    @Override
    public boolean validate(JSONObject jsonObject) throws InvalidInputDataException {
        String delimitter = "\\|";
        StringBuilder missingFields = this.getMissingFields(jsonObject, this.requiredFields, delimitter);
        if (missingFields != null && missingFields.length() > 1) {
            throw new InvalidInputDataException(this.getMessage(missingFields.toString()));
        }
        return true;
    }

    private StringBuilder getMissingFields(JSONObject jsonObject, String requiredFields, String delimitter) {
        String[] dataInValue = requiredFields.split(delimitter);
        StringBuilder missingFields = null;
        for (String data : dataInValue) {
            String[] elementsInData = data.split("\\.");
            if (missingFields == null) {
                missingFields = new StringBuilder();
            }
            if (elementsInData.length == 1) {
                if (data.isEmpty() || !jsonObject.isNull(data)) continue;
                if (missingFields.length() != 0) {
                    missingFields.append(", ");
                }
                missingFields.append(data);
                continue;
            }
            missingFields.append((CharSequence)this.getMissingFields((JSONObject)jsonObject.get(elementsInData[0]), data.substring(data.indexOf(".")), "\\."));
        }
        return missingFields;
    }
}

