/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.comm;

import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.event.BMilestoneEventCameraExt;
import com.tridium.nmilestone.event.BMilestoneEventPointId;
import com.tridium.nmilestone.event.BMilestoneEventProxyExt;
import com.tridium.nmilestone.event.BMilestoneEventTypeEnum;
import com.tridium.nmilestone.messages.MilestoneCentralLoginReq;
import com.tridium.nmilestone.messages.MilestoneCentralReq;
import com.tridium.nmilestone.messages.MilestoneUnsolicitedMessage;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import org.owasp.encoder.Encode;

public class MilestoneTcpListener
implements ICommListener {
    public static final int CHECK_USER_NAME_AND_PASSWORD = 0;
    public static final int REQUEST_STATUS_LIST_CONDENSER_OBJECT = 1;
    public static final int RECEIVE_STATUS_LIST_CONDENSER_OBJECT = 1;
    public static final int REQUEST_STATUS_LIST = 2;
    public static final int RECEIVE_STATUS_LIST = 2;
    public static final int DONE = 3;
    protected int state = 0;
    public String xmlSimpleReplyId;
    protected static final Logger log = Logger.getLogger("milestone.tcpUnsolMgr");
    protected int aliveInterval;
    protected Clock.Ticket aliveIntervalTicket;
    BMilestoneNetwork network;
    BMilestoneDvr dvr;

    public MilestoneTcpListener(BMilestoneDvr dvr) {
        this.dvr = dvr;
        this.network = dvr.getMilestoneNetwork();
    }

    public void receiveMessage(NMessage msg) {
        block17: {
            try {
                byte[] a = new byte[((MilestoneUnsolicitedMessage)msg).in.available()];
                ((MilestoneUnsolicitedMessage)msg).in.read(a);
                ((MilestoneUnsolicitedMessage)msg).in.reset();
            }
            catch (Exception a) {
                // empty catch block
            }
            try {
                XElem surveillanceElem = MilestoneReqUtil.getElem(((MilestoneUnsolicitedMessage)msg).in, "milestoneSurveillance");
                XElem replyElem = surveillanceElem.elem("reply");
                if (replyElem == null) {
                    XElem bubbleElem = surveillanceElem.elem("bubble");
                    if (bubbleElem == null) {
                        XElem aliveElem = surveillanceElem.elem("alive");
                        if (aliveElem != null) {
                            this.processAlive(aliveElem);
                        }
                    } else {
                        this.processBubble(bubbleElem);
                    }
                    break block17;
                }
                try {
                    String token = replyElem.get("token", "");
                    if ("197001".equals(token) || "1337".equals(token) || "197002".equals(token) || "197003".equals(token)) {
                        ((MilestoneUnsolicitedMessage)msg).in.reset();
                        this.processCentralLoginRsp(((MilestoneUnsolicitedMessage)msg).in);
                        byte[] bytes = this.getBytes();
                        if (bytes != null) {
                            MilestoneCentralReq req = new MilestoneCentralReq(bytes);
                            req.setAddress((BAddress)this.dvr.tcpAddress());
                            this.dvr.getTcpCpSession().sendMessage(req);
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    log.severe(e.getMessage());
                }
                try {
                    this.processReply(replyElem);
                }
                catch (Exception dre) {
                    log.severe(dre.getMessage());
                }
            }
            catch (Exception e) {
                if (this.isConnectErrorMsg(((MilestoneUnsolicitedMessage)msg).in)) {
                    log.log(Level.INFO, "You Must connect first. Ping the Camera");
                    BIVideoCamera[] cameras = this.dvr.getCameras().getAllCameras();
                    for (int i = 0; i < cameras.length; ++i) {
                        BMilestoneCamera milestoneCamera = (BMilestoneCamera)cameras[i];
                        milestoneCamera.doPing();
                    }
                }
                if (this.isPtzRsp(((MilestoneUnsolicitedMessage)msg).in)) {
                    // empty if block
                }
            }
        }
    }

    boolean isConnectErrorMsg(InputStream in) {
        try {
            in.reset();
            XElem methodResponseElem = MilestoneReqUtil.getElem(in, "methodresponse");
            String connectedString = MilestoneReqUtil.getText(methodResponseElem, "errorreason");
            if (connectedString.equalsIgnoreCase("You must connect first")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean isPtzRsp(InputStream in) {
        try {
            in.reset();
            XElem methodResponseElem = MilestoneReqUtil.getElem(in, "methodresponse");
            String connectedString = MilestoneReqUtil.getText(methodResponseElem, "methodname");
            if (connectedString.equalsIgnoreCase("ptz")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void processAlive(XElem aliveElem) {
        this.resetAlarmIntervalExpirationTimer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processReply(XElem replyElem) throws Exception {
        String base = MilestoneReqUtil.getText(replyElem, "base");
        if (!"XMLSimpleReply".equals(base)) throw new Exception("Unrecognized 'base' in reply: base=" + (false == base.trim().isEmpty() ? base : "<null>"));
        XElem object = MilestoneReqUtil.getElem(replyElem, "object");
        String classification = MilestoneReqUtil.getText(object, "classification");
        if (!"UserLoginManager".equals(classification)) throw new Exception("Unrecognized 'classification' in reply: classification=" + (false == classification.trim().isEmpty() ? classification : "<null>"));
        String status = MilestoneReqUtil.getText(object, "status");
        if (!"Enabled".equals(status)) {
            this.dvr.setCentralServerFaultCause(Lexicon.make(this.getClass()).get("CentralServerLoginFailure"));
            this.dvr.setCentralServerFaultStatus(true);
            this.dvr.updatePingStatus();
            throw new Exception("Unrecognized 'status' in reply: status=" + (false == status.trim().isEmpty() ? status : "<null>"));
        }
        int userLoginManagerId = Integer.parseInt(MilestoneReqUtil.getText(object, "id"));
        MilestoneCentralLoginReq loginReq = new MilestoneCentralLoginReq(this, userLoginManagerId, this.dvr.getMilestoneCentralCredentials().getUsername(), this.dvr.getUpdatedCentralServerKey());
        loginReq.setAddress((BAddress)this.dvr.tcpAddress());
        this.dvr.getTcpCpSession().sendMessage(loginReq);
    }

    public void aliveIntervalReceived(int aliveInterval) {
        this.aliveInterval = aliveInterval;
        this.resetAlarmIntervalExpirationTimer();
    }

    protected void resetAlarmIntervalExpirationTimer() {
        if (this.aliveIntervalTicket != null) {
            this.aliveIntervalTicket.cancel();
        }
        if (this.aliveInterval > 0) {
            // empty if block
        }
    }

    protected void processExternalEvent(XElem bubbleElem, String id, String name, String status) throws Exception {
        BAbsTime spawnTime = MilestoneReqUtil.getTime(bubbleElem, "spawnTime");
        BIVideoCamera[] cameras = this.dvr.getCameras().getAllCameras();
        for (int i = 0; i < cameras.length; ++i) {
            BMilestoneCamera milestoneCamera = (BMilestoneCamera)cameras[i];
            BMilestoneEventCameraExt eventExt = (BMilestoneEventCameraExt)milestoneCamera.getEvents();
            BControlPoint[] eventPoints = eventExt.getPoints();
            for (int cameraPointIndex = 0; cameraPointIndex < eventPoints.length; ++cameraPointIndex) {
                BMilestoneEventProxyExt eventProxy = (BMilestoneEventProxyExt)eventPoints[cameraPointIndex].getProxyExt();
                BMilestoneEventPointId eventPointId = eventProxy.getPointId();
                if (eventPointId.getMilestoneEventType() != BMilestoneEventTypeEnum.external || !eventPointId.getMilestoneEventName().equals(name) || !eventPointId.getMilestoneEventId().equals(id) || !eventPointId.getMilestoneEventStatus().equals(status)) continue;
                BVideoEvent videoEvent = BVideoEvent.makeOffNormalEvent();
                videoEvent.setEventType(BVideoEventTypesEnum.customEvent);
                videoEvent.setDescription(id + ':' + name + ':' + status);
                videoEvent.setTimestamp(spawnTime);
                eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
            }
        }
    }

    protected void updateMotionDetectedPointInCamera(XElem bubbleElem, String cameraGuid) throws Exception {
        if (cameraGuid != null && cameraGuid.length() > 0) {
            BAbsTime spawnTime = MilestoneReqUtil.getTime(bubbleElem, "spawnTime");
            BIVideoCamera[] cameras = this.dvr.getCameras().getAllCameras();
            for (int i = 0; i < cameras.length; ++i) {
                String cameraGuidInDatabase;
                BMilestoneCamera milestoneCamera = (BMilestoneCamera)cameras[i];
                if (!milestoneCamera.getStatus().isValid()) continue;
                if (!milestoneCamera.getHasPingedAtLeastOnce()) {
                    milestoneCamera.ping();
                }
                if (!cameraGuid.equals(cameraGuidInDatabase = ((BMilestoneCameraDeviceId)milestoneCamera.getVideoDeviceId()).getCameraGuid())) continue;
                BMilestoneEventCameraExt eventExt = (BMilestoneEventCameraExt)milestoneCamera.getEvents();
                BControlPoint[] eventPoints = eventExt.getPoints();
                for (int cameraPointIndex = 0; cameraPointIndex < eventPoints.length; ++cameraPointIndex) {
                    BMilestoneEventProxyExt eventProxy = (BMilestoneEventProxyExt)eventPoints[cameraPointIndex].getProxyExt();
                    BMilestoneEventPointId eventPointId = eventProxy.getPointId();
                    if (eventPointId.getMilestoneEventType() != BMilestoneEventTypeEnum.motionDetected) continue;
                    BVideoEvent videoEvent = BVideoEvent.makeMotionStarted();
                    videoEvent.setTimestamp(spawnTime);
                    eventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
                }
            }
        }
    }

    protected void processBubble(XElem bubbleElem) throws Exception {
        XElem source = MilestoneReqUtil.getElem(bubbleElem, "source");
        XElem object = MilestoneReqUtil.getElem(source, "object");
        String classification = MilestoneReqUtil.getText(object, "classification");
        if ("EngineElement".equals(classification)) {
            classification = MilestoneReqUtil.getText(object = MilestoneReqUtil.getElem(object, "object"), "classification");
            if ("CameraElement".equals(classification)) {
                String cameraGuid = MilestoneReqUtil.getText(object, "guid");
                this.updateMotionDetectedPointInCamera(bubbleElem, cameraGuid);
            } else {
                String id = MilestoneReqUtil.getText(object, "id");
                String name = MilestoneReqUtil.getText(object, "name");
                String status = MilestoneReqUtil.getText(object, "status");
                this.processExternalEvent(bubbleElem, id, name, status);
            }
        }
    }

    public void processCentralLoginRsp(InputStream in) throws Exception {
        try {
            if (this.state == 0) {
                this.checkUserNameAndPassword(in);
            } else if (this.state == 1) {
                this.receiveStatusListObject(in);
            } else if (this.state == 2) {
                this.receiveStatusList(in);
            }
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            throw new Exception(e);
        }
    }

    public void checkUserNameAndPassword(InputStream in) throws Exception {
        boolean userEnabled = true;
        try {
            XElem milestoneSurveillance = MilestoneReqUtil.getElem(in, "milestoneSurveillance");
            XElem reply = MilestoneReqUtil.getElem(milestoneSurveillance, "reply");
            String token = reply.get("token", "");
            if ("197001".equals(token) || "1337".equals(token)) {
                String base = MilestoneReqUtil.getText(reply, "base");
                if ("XMLSimpleReply".equals(base)) {
                    XElem object = MilestoneReqUtil.getElem(reply, "object");
                    String classification = MilestoneReqUtil.getText(object, "classification");
                    if ("User".equals(classification)) {
                        String status = MilestoneReqUtil.getText(object, "status");
                        if ("Enabled".equals(status)) {
                            this.xmlSimpleReplyId = MilestoneReqUtil.getText(object, "id");
                            this.state = 1;
                            return;
                        }
                        userEnabled = false;
                    }
                } else if ("Error".equals(base)) {
                    userEnabled = false;
                }
            }
        }
        catch (Exception dre) {
            log.severe(dre.getMessage());
        }
        if (!userEnabled) {
            this.state = 3;
            if (this.dvr != null) {
                this.dvr.setCentralServerFaultCause(Lexicon.make(this.getClass()).get("MilestoneCentralServerCredentialsIssue"));
                this.dvr.setCentralServerFaultStatus(true);
                this.dvr.updatePingStatus();
            }
            throw new Exception(Lexicon.make(this.getClass()).get("MilestoneCentralServerCredentialsIssue"));
        }
    }

    public void receiveStatusListObject(InputStream in) throws Exception {
        boolean statusListObjectEnabled = true;
        try {
            XElem object;
            String classification;
            String base;
            XElem milestoneSurveillance = MilestoneReqUtil.getElem(in, "milestoneSurveillance");
            XElem reply = MilestoneReqUtil.getElem(milestoneSurveillance, "reply");
            String token = reply.get("token", "");
            if ("197002".equals(token) && "XMLSimpleReply".equals(base = MilestoneReqUtil.getText(reply, "base")) && "StatusList".equals(classification = MilestoneReqUtil.getText(object = MilestoneReqUtil.getElem(reply, "object"), "classification"))) {
                String status = MilestoneReqUtil.getText(object, "status");
                if ("Enabled".equals(status)) {
                    statusListObjectEnabled = true;
                    this.xmlSimpleReplyId = MilestoneReqUtil.getText(object, "id");
                    this.state = 2;
                    return;
                }
                statusListObjectEnabled = false;
            }
        }
        catch (Exception dre) {
            log.severe(dre.getMessage());
        }
        if (!statusListObjectEnabled) {
            this.dvr.setCentralServerFaultCause(Lexicon.make(this.getClass()).get("MilestoneCentralServerStatusListObjectIssue"));
            this.dvr.setCentralServerFaultStatus(true);
            this.dvr.updatePingStatus();
            throw new Exception(Lexicon.make(this.getClass()).get("MilestoneCentralServerStatusListObjectIssue"));
        }
    }

    public void receiveStatusList(InputStream in) throws Exception {
        boolean statusListObjectEnabled = true;
        boolean statusListIdMatch = true;
        try {
            XElem object;
            String classification;
            String base;
            XElem milestoneSurveillance = MilestoneReqUtil.getElem(in, "milestoneSurveillance");
            XElem reply = MilestoneReqUtil.getElem(milestoneSurveillance, "reply");
            String token = reply.get("token", "");
            if ("197003".equals(token) && "XMLStatus".equals(base = MilestoneReqUtil.getText(reply, "base")) && "StatusList".equals(classification = MilestoneReqUtil.getText(object = MilestoneReqUtil.getElem(reply, "object"), "classification"))) {
                String status = MilestoneReqUtil.getText(object, "status");
                if ("Enabled".equals(status)) {
                    statusListObjectEnabled = true;
                    String statusListId = MilestoneReqUtil.getText(object, "id");
                    if (this.xmlSimpleReplyId.equals(statusListId)) {
                        XElem statusList = MilestoneReqUtil.getElem(object, "statuslist");
                        classification = MilestoneReqUtil.getText(object = MilestoneReqUtil.getElem(statusList, "object"), "classification");
                        if ("EngineElement".equals(classification)) {
                            String aliveInterval = MilestoneReqUtil.getText(object, "aliveinterval");
                            this.state = 3;
                            this.aliveIntervalReceived(Integer.parseInt(aliveInterval));
                        }
                    } else {
                        statusListIdMatch = false;
                    }
                } else {
                    statusListObjectEnabled = false;
                }
            }
        }
        catch (Exception dre) {
            log.severe(dre.getMessage());
        }
        if (!statusListObjectEnabled) {
            this.dvr.setCentralServerFaultCause(Lexicon.make(this.getClass()).get("MilestoneCentralServerStatusListIssue1"));
            this.dvr.setCentralServerFaultStatus(true);
            this.dvr.updatePingStatus();
            throw new Exception(Lexicon.make(this.getClass()).get("MilestoneCentralServerStatusListIssue1"));
        }
        if (!statusListIdMatch) {
            this.dvr.setCentralServerFaultCause(Lexicon.make(this.getClass()).get("MilestoneCentralServerStatusListIssue2"));
            this.dvr.setCentralServerFaultStatus(true);
            this.dvr.updatePingStatus();
            throw new Exception(Lexicon.make(this.getClass()).get("MilestoneCentralServerStatusListIssue2"));
        }
        this.dvr.setCentralServerFaultCause("");
        this.dvr.setCentralServerFaultStatus(false);
        this.dvr.updatePingStatus();
    }

    public byte[] getBytesToRequestStatusListCondenserObject() {
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><milestoneSurveillance protocolVersion=\"2.0\"><command token=\"197002\"><base>XMLSimpleCommand</base><action><commandName>Request Status Condenser</commandName><destinations><object><classification>User</classification><id>" + Encode.forXmlContent((String)this.xmlSimpleReplyId) + "</id></object></destinations></action></command></milestoneSurveillance>\r\n\r\n").getBytes();
    }

    public byte[] getBytesToRequestStatusList() {
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><milestoneSurveillance protocolVersion=\"2.0\"><command token=\"197003\"><base>XMLSimpleCommand</base><action><commandName>Request Status</commandName><destinations><object><classification>StatusList</classification><id>" + Encode.forXmlAttribute((String)this.xmlSimpleReplyId) + "</id></object></destinations></action></command></milestoneSurveillance>\r\n\r\n").getBytes();
    }

    public byte[] getBytes() {
        if (this.state == 1) {
            return this.getBytesToRequestStatusListCondenserObject();
        }
        if (this.state == 2) {
            return this.getBytesToRequestStatusList();
        }
        if (this.state == 3) {
            return null;
        }
        return null;
    }

    public boolean isComplete() {
        return this.state == 3;
    }
}

