/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.messages.MilestoneCameraConnectReq;
import com.tridium.nmilestone.messages.MilestoneRsp;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.baja.xml.XElem;

public class MilestoneCameraConnectRsp
extends MilestoneRsp {
    BMilestoneCamera camera;
    public InputStream in;

    public MilestoneCameraConnectRsp(InputStream ins) {
        this.in = ins;
    }

    public void setMilestoneCamera(BMilestoneCamera camera) {
        this.camera = camera;
    }

    @Override
    public synchronized void fromInputStream(InputStream in) throws Exception {
        in.reset();
        byte[] a = new byte[in.available()];
        ByteArrayInputStream bais = null;
        try {
            in.read(a);
            bais = new ByteArrayInputStream(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        in.reset();
        try {
            XElem methodResponseElem = MilestoneReqUtil.getElem(bais, "methodresponse");
            String connectedString = MilestoneReqUtil.getText(methodResponseElem, "connected");
            String alwaysJpeg = MilestoneReqUtil.getText(methodResponseElem, "alwaysstdjpeg");
            if (connectedString.equals("yes")) {
                this.camera.setMilestonePtzConnectionEstablished(true);
                if (alwaysJpeg.equals("no")) {
                    // empty if block
                }
                return;
            }
            this.camera.setMilestonePtzConnectionEstablished(false);
            throw new Exception("Milestone Camera Connection Was Denied: \"" + connectedString + "\"");
        }
        catch (Exception e) {
            this.camera.setMilestonePtzConnectionEstablished(false);
            throw new Exception("Error Parsing Milestone Camera Connection Response", e);
        }
    }

    @Override
    public Object getTag() {
        return MilestoneCameraConnectReq.CAMERA_CONNECT_OBJ;
    }
}

