/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.nmilestone.messages.MilestoneCameraConnectRsp;
import com.tridium.nmilestone.messages.MilestoneEventRefreshAroundRsp;
import com.tridium.nmilestone.messages.MilestoneTcpLinkMessage;
import com.tridium.nmilestone.messages.MilestoneUnsolicitedMessage;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import java.io.InputStream;
import javax.baja.xml.XElem;

public class MilestoneMessageFactory
implements IMessageFactory {
    public Object syncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMessage makeMessage(LinkMessage lm) throws Exception {
        Object object = this.syncObj;
        synchronized (object) {
            MilestoneTcpLinkMessage lkmsg = (MilestoneTcpLinkMessage)lm;
            if (this.isCameraConnectRsp(lkmsg.getInputStream())) {
                lkmsg.getInputStream().reset();
                MilestoneCameraConnectRsp msg = new MilestoneCameraConnectRsp(lkmsg.getInputStream());
                msg.setAddress((BAddress)lkmsg.address);
                return msg;
            }
            lkmsg.getInputStream().reset();
            if (this.isEventRefreshAroundResp(lkmsg.getInputStream())) {
                MilestoneEventRefreshAroundRsp msg = new MilestoneEventRefreshAroundRsp(lkmsg.getInputStream());
                msg.setAddress((BAddress)lkmsg.address);
                return msg;
            }
            lkmsg.getInputStream().reset();
            MilestoneUnsolicitedMessage msg = new MilestoneUnsolicitedMessage(lkmsg.getInputStream());
            msg.setAddress((BAddress)lkmsg.address);
            return msg;
        }
    }

    boolean isCameraConnectRsp(InputStream in) {
        try {
            XElem methodResponseElem = MilestoneReqUtil.getElem(in, "methodresponse");
            String connectedString = MilestoneReqUtil.getText(methodResponseElem, "methodname");
            return connectedString.equalsIgnoreCase("connect");
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isEventRefreshAroundResp(InputStream in) {
        try {
            XElem methodResponse = MilestoneReqUtil.getMilestoneMethodResponseElem(in);
            String methodName = MilestoneReqUtil.getText(methodResponse, "methodname");
            return "alarms".equals(methodName);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

