/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.util;

import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.nmilestone.BMilestoneCameraDiscoveryLeaf;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

public class MilestoneHttpUtil {
    public static void getDvrStatus(HttpComm hcom, BIpAddress addr, BUsernameAndPassword credentials) throws Exception {
        String uri = "/systeminfo.xml";
        NHttpResponse resp = MilestoneHttpUtil.get(hcom, addr, uri, credentials);
        byte[] dat = resp.getData();
        ByteBuffer b = new ByteBuffer(dat, dat.length);
        try {
            boolean cameraExists = false;
            XElem methodResponseElem = MilestoneReqUtil.getMilestoneMethodResponseElem(b.getInputStream());
            XElem enginesElem = MilestoneReqUtil.getElem(methodResponseElem, "engines");
            XElem[] engineElemArray = enginesElem.elems("engine");
            for (int i = 0; i < engineElemArray.length; ++i) {
                XElem engineElem = engineElemArray[i];
                XElem camerasElem = engineElem.elem("cameras");
                if (camerasElem == null) continue;
                cameraExists = true;
                break;
            }
            if (!cameraExists) {
                throw new Exception("DVR is not reachable.");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void getCamStatus(BMilestoneCamera camera, HttpComm hcom, BIpAddress addr, BUsernameAndPassword credentials) throws Exception {
        String uri = "/systeminfo.xml";
        NHttpResponse resp = MilestoneHttpUtil.get(hcom, addr, uri, credentials);
        String stationCameraGuid = ((BMilestoneCameraDeviceId)camera.getVideoDeviceId()).getCameraGuid();
        byte[] dat = resp.getData();
        ByteBuffer b = new ByteBuffer(dat, dat.length);
        try {
            boolean cameraExists = false;
            XElem methodResponseElem = MilestoneReqUtil.getMilestoneMethodResponseElem(b.getInputStream());
            XElem enginesElem = MilestoneReqUtil.getElem(methodResponseElem, "engines");
            XElem[] engineElemArray = enginesElem.elems("engine");
            block2: for (int i = 0; i < engineElemArray.length; ++i) {
                XElem engineElem = engineElemArray[i];
                XElem camerasElem = engineElem.elem("cameras");
                if (camerasElem == null) continue;
                XElem[] cameraElemArray = camerasElem.elems("camera");
                for (int j = 0; j < cameraElemArray.length; ++j) {
                    String cameraIdStr;
                    String milestoneDatabaseId = cameraIdStr = cameraElemArray[j].get("cameraid");
                    String milestoneGuid = MilestoneReqUtil.getText(cameraElemArray[j], "guid");
                    if (milestoneGuid == null || milestoneGuid.length() <= 0 || !milestoneGuid.equalsIgnoreCase(stationCameraGuid)) continue;
                    cameraExists = true;
                    camera.setMilestoneDatabaseId(milestoneDatabaseId);
                    camera.setMilestoneGuid(milestoneGuid);
                    if (!camera.getAutoSetPtzSupport()) break block2;
                    MilestoneHttpUtil.configureCameraControls(camera, cameraElemArray[j]);
                    break block2;
                }
            }
            if (!cameraExists) {
                throw new Exception("Camera Guid does not exist in Milestone ImageServer: " + stationCameraGuid);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void configureCameraControls(BMilestoneCamera camera, XElem cameraElem) {
        XElem[] presetElems;
        BVideoCameraInfo videoCameraInfo = camera.getCameraInfo();
        videoCameraInfo.setSupportsFocus(false);
        videoCameraInfo.setSupportsIris(false);
        videoCameraInfo.setSupportsStorePreset(false);
        XElem ptzElem = cameraElem.elem("ptz");
        XElem userRightsElem = cameraElem.elem("userrights");
        XElem presetsElem = cameraElem.elem("presets");
        if (presetsElem != null && (presetElems = presetsElem.elems("preset")) != null && presetElems.length > 0) {
            String[] presetText = new String[presetElems.length];
            for (int i = 0; i < presetElems.length; ++i) {
                presetText[i] = EscUtil.slot.escape(MilestoneReqUtil.getText(presetElems[i]));
            }
            camera.setPresetText(BEnumRange.make((String[])presetText));
        }
        if (ptzElem != null && userRightsElem != null) {
            String userPtzAllowed = MilestoneReqUtil.getText(userRightsElem, "ptz");
            String panStr = MilestoneReqUtil.getText(ptzElem, "pan");
            String tiltStr = MilestoneReqUtil.getText(ptzElem, "tilt");
            String zoomStr = MilestoneReqUtil.getText(ptzElem, "zoom");
            if ("yes".equals(userPtzAllowed)) {
                videoCameraInfo.setSupportsPanTilt(!"none".equals(panStr) && !"none".equals(tiltStr));
                videoCameraInfo.setSupportsZoom(!"none".equals(zoomStr));
            } else {
                videoCameraInfo.setSupportsPanTilt(false);
                videoCameraInfo.setSupportsZoom(false);
            }
        }
    }

    public static BMilestoneCameraDiscoveryLeaf[] discoverCameras(HttpComm hcom, BIpAddress addr, BUsernameAndPassword credentails) throws Exception {
        String uri = "/systeminfo.xml";
        NHttpResponse resp = MilestoneHttpUtil.get(hcom, addr, uri, credentails);
        byte[] dat = resp.getData();
        ByteBuffer b = new ByteBuffer(dat, dat.length);
        Array discoveredCamerasArray = new Array(BMilestoneCameraDiscoveryLeaf.class);
        XElem methodResponse = MilestoneReqUtil.getMilestoneMethodResponseElem(b.getInputStream());
        String userOkText = MilestoneReqUtil.getText(methodResponse, "userok");
        if ("yes".equals(userOkText)) {
            XElem enginesElem = MilestoneReqUtil.getElem(methodResponse, "engines");
            XElem[] engineElemArray = enginesElem.elems("engine");
            for (int i = 0; i < engineElemArray.length; ++i) {
                XElem engineElem = engineElemArray[i];
                XElem camerasElem = engineElem.elem("cameras");
                if (camerasElem == null) continue;
                XElem[] cameraElemArray = camerasElem.elems("camera");
                for (int j = 0; j < cameraElemArray.length; ++j) {
                    String cameraIdStr = cameraElemArray[j].get("cameraid");
                    String milestoneGuid = MilestoneReqUtil.getText(cameraElemArray[j], "guid");
                    String milestoneDatabaseId = cameraIdStr;
                    BMilestoneCameraDiscoveryLeaf discoveredCamera = new BMilestoneCameraDiscoveryLeaf();
                    discoveredCamera.getId().setDescription(milestoneDatabaseId);
                    discoveredCamera.getId().setCameraGuid(milestoneGuid);
                    discoveredCamera.getId().setCameraId(j);
                    discoveredCamerasArray.add((Object)discoveredCamera);
                }
            }
        } else {
            throw new Exception("Milestone ImageServer denied the Username and/or Password.");
        }
        BMilestoneCameraDiscoveryLeaf[] leaves = (BMilestoneCameraDiscoveryLeaf[])discoveredCamerasArray.trim();
        return leaves;
    }

    public static long getControlTimeStampUtc(BPlaybackParams playbackParams) {
        BAbsTime frameTimeIndex = null;
        long timeIndexSecondsSinceMidnight01Jan1970 = -1L;
        if (!playbackParams.getTimeIndex().isNull()) {
            frameTimeIndex = playbackParams.getTimeIndex();
            timeIndexSecondsSinceMidnight01Jan1970 = frameTimeIndex.getMillis() / 1000L;
        }
        return timeIndexSecondsSinceMidnight01Jan1970;
    }

    public static NHttpResponse get(HttpComm hcom, BIpAddress addr, String uri, BUsernameAndPassword credentials) throws Exception {
        String meth = "GET";
        NHttpRequest rqst = new NHttpRequest(addr, meth, uri);
        BUsernameAndPassword usernameAndPassword = new BUsernameAndPassword();
        usernameAndPassword.setUsername(credentials.getUsername());
        usernameAndPassword.setPassword(BPassword.make((String)credentials.getPassword().getValue()));
        rqst.setUsernamePassword(usernameAndPassword);
        rqst.addBasicAuthorization(credentials.getUsername(), credentials.getPassword().getValue());
        rqst.setAddress((BAddress)addr);
        return hcom.sendRequest(rqst);
    }

    public static boolean receiveMilestoneConnectReply(XElem methodResponseElem) throws IOException {
        String methodResponseElemName = methodResponseElem.name();
        if (methodResponseElemName.equals("methodresponse")) {
            XElem connectedElem = methodResponseElem.elem("connected");
            if (connectedElem != null) {
                XText connectedText = connectedElem.text();
                if (connectedText != null) {
                    String connectedStr = connectedText.string();
                    if (connectedStr.equals("yes")) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        XWriter w = new XWriter((OutputStream)bos);
                        methodResponseElem.write(w, 2);
                        w.flush();
                        return true;
                    }
                    if (connectedStr.equals("no")) {
                        throw new BajaRuntimeException("ImageServer connection was denied.");
                    }
                    throw new IllegalStateException("Unrecognized ImageServer connection string in reply: " + connectedStr);
                }
                throw new IllegalStateException("No text inside <connected>...</connected> elem!");
            }
            throw new IllegalStateException("No <connected>...</connected> elem under <methodresposne>...</methodresponse>!");
        }
        throw new IllegalStateException("Expected <methodresponse> reply from ImageServer but received <" + methodResponseElemName + "> instead!");
    }
}

