/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.util;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.messages.MilestoneCameraGetTimeRequest;
import com.tridium.nmilestone.messages.MilestoneVideoStreamReq;
import com.tridium.nmilestone.util.MilestoneHttpUtil;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import org.baja.ffmpeg.enums.BCodecIdEnum;

public class MilestoneVideoStreamUtil {
    public static void sendStreamRequest(NMessage ddfRequest, BMilestoneCamera camera, BMilestoneDvr dvr) {
        if (!camera.getEnabled()) {
            return;
        }
        if (ddfRequest instanceof MilestoneVideoStreamReq) {
            try {
                MilestoneVideoStreamUtil.establishVideoFeed((MilestoneVideoStreamReq)ddfRequest, dvr, camera);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ddfRequest instanceof MilestoneCameraGetTimeRequest) {
            try {
                MilestoneVideoStreamUtil.determineCameraTime((MilestoneCameraGetTimeRequest)ddfRequest, dvr, camera);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void establishVideoFeed(MilestoneVideoStreamReq videoStreamReq, BMilestoneDvr dvr, BMilestoneCamera camera) throws Exception {
        try {
            if (dvr != null) {
                EstablishVideoConnection establishVideoConnection = new EstablishVideoConnection(videoStreamReq, camera);
                establishVideoConnection.start();
                establishVideoConnection.join(30000L);
                if (establishVideoConnection.isAlive()) {
                    establishVideoConnection.interrupt();
                }
                if (establishVideoConnection.success) {
                    videoStreamReq.setVideoSocket(establishVideoConnection.liveVideoSocket);
                } else {
                    videoStreamReq.getVideoDestination().videoStreamTimeout();
                    if (establishVideoConnection.liveVideoSocket != null) {
                        establishVideoConnection.liveVideoSocket.close();
                    }
                }
            }
        }
        finally {
            MilestoneVideoStreamReq milestoneVideoStreamReq = videoStreamReq;
            synchronized (milestoneVideoStreamReq) {
                ((Object)((Object)videoStreamReq)).notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void determineCameraTime(MilestoneCameraGetTimeRequest cameraTimeReq, BMilestoneDvr dvr, BMilestoneCamera camera) throws Exception {
        try {
            if (dvr != null) {
                cameraTimeReq.setVideoSource((BIVideoSource)camera);
                cameraTimeReq.setPlaybackParams(new BPlaybackParams());
                GetCameraTimeHack establishCameraTime = new GetCameraTimeHack(cameraTimeReq, camera);
                establishCameraTime.start();
                establishCameraTime.join(30000L);
                if (establishCameraTime.isAlive()) {
                    establishCameraTime.interrupt();
                }
                establishCameraTime.liveVideoSocket.close();
            }
        }
        finally {
            MilestoneCameraGetTimeRequest milestoneCameraGetTimeRequest = cameraTimeReq;
            synchronized (milestoneCameraGetTimeRequest) {
                ((Object)((Object)cameraTimeReq)).notifyAll();
            }
        }
    }

    public static class GetCameraTimeHack
    extends EstablishVideoConnection {
        MilestoneCameraGetTimeRequest getMilestoneCameraTimeReq;

        public GetCameraTimeHack(MilestoneCameraGetTimeRequest getMilestoneCameraTimeReq, BMilestoneCamera milestoneCamera) {
            super(getMilestoneCameraTimeReq, milestoneCamera);
            this.getMilestoneCameraTimeReq = getMilestoneCameraTimeReq;
        }

        @Override
        protected void establishTcpConnection() throws IOException {
            super.establishTcpConnection();
        }

        @Override
        protected boolean receiveMilestoneVideoRsp() throws IOException {
            String line = this.readLineFromSocket();
            try {
                ByteBuffer b = new ByteBuffer(line.getBytes(), line.getBytes().length);
                XElem livePackage = MilestoneReqUtil.getElem(b.getInputStream(), "livepackage");
                XElem status = MilestoneReqUtil.getElem(livePackage, "status");
                String statusTime = MilestoneReqUtil.getText(status, "statustime");
                this.getMilestoneCameraTimeReq.setCameraTime(statusTime);
                this.liveVideoSocket.close();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class EstablishVideoConnection
    extends Thread {
        MilestoneVideoStreamReq videoStreamReq;
        public BMilestoneDvr dvr;
        public BMilestoneCamera milestoneCamera;
        Socket liveVideoSocket;
        OutputStream tcpOut;
        InputStream tcpIn;
        public boolean success;

        public EstablishVideoConnection(MilestoneVideoStreamReq videoStreamReq, BMilestoneCamera milestoneCamera) {
            super("LiveVideo.Camera" + videoStreamReq.getMilestoneCameraId());
            this.videoStreamReq = videoStreamReq;
            this.dvr = milestoneCamera.getMilestoneDvr();
            this.milestoneCamera = milestoneCamera;
        }

        protected void establishTcpConnection() throws IOException {
            this.dvr.lease(2);
            this.liveVideoSocket = new Socket(this.dvr.getMilestoneEngineIpAddress(), this.dvr.getMilestoneImageServerPort());
            this.tcpOut = this.liveVideoSocket.getOutputStream();
            this.tcpIn = this.liveVideoSocket.getInputStream();
        }

        protected void sendMilestoneConnectReq() throws IOException {
            boolean alwaysStdJpeg = this.videoStreamReq.getPlaybackParams().getCompression() != BVideoCompressionEnum.high && this.videoStreamReq.getPlaybackParams().getPlaybackType() != BPlaybackTypeEnum.live || this.milestoneCamera.getHighCompressionCodec() == BCodecIdEnum.ffmpeg_CODEC_ID_NONE;
            String liveConnectXml = this.videoStreamReq.getLiveConnectXml(this.dvr.getCredentials().getUsername(), this.dvr.getUpdatedImageServerKey(), alwaysStdJpeg);
            this.tcpOut.write(liveConnectXml.getBytes());
            this.tcpOut.flush();
        }

        protected boolean receiveMilestoneConnectReply() throws Exception {
            XParser p = XParser.make((InputStream)this.tcpIn);
            XElem methodResponseElem = p.parse(false);
            if (methodResponseElem != null) {
                return MilestoneHttpUtil.receiveMilestoneConnectReply(methodResponseElem);
            }
            throw new IllegalStateException("No reply from ImageServer!");
        }

        protected void sendMilestoneVideoReq() throws IOException {
            byte[] videoReqBytes = this.videoStreamReq.toByteArray();
            this.tcpOut.write(videoReqBytes);
            this.tcpOut.flush();
        }

        protected String readLineFromSocket() throws IOException {
            StringBuilder sb = new StringBuilder();
            boolean endl = false;
            int lastByte = -1;
            while (!endl) {
                int bite = this.tcpIn.read();
                if (bite == -1) {
                    endl = true;
                    continue;
                }
                sb.append((char)bite);
                endl = bite == 10 && lastByte == 13;
                lastByte = bite;
            }
            String sbStr = sb.toString();
            if (sbStr.length() > 2) {
                sbStr = sbStr.substring(0, sbStr.length() - 2);
            }
            return sbStr;
        }

        protected boolean receiveMilestoneVideoRsp() throws IOException {
            String line = this.readLineFromSocket();
            while (line != null && line.length() > 0 && !"ImageResponse".equals(line)) {
                line = this.readLineFromSocket();
            }
            return true;
        }

        @Override
        public void run() {
            try {
                this.establishTcpConnection();
                this.sendMilestoneConnectReq();
                this.receiveMilestoneConnectReply();
                this.sendMilestoneVideoReq();
                this.success = this.receiveMilestoneVideoRsp();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                this.success = false;
                e.printStackTrace();
            }
        }
    }
}

