/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.foxanalyzer;

import com.tridium.fox.session.FoxConnection;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.foxanalyzer.BFoxAnalyzerMode;
import com.tridium.foxanalyzer.BFoxFrameRecord;
import com.tridium.foxanalyzer.BFoxFrameRecordType;
import com.tridium.foxanalyzer.BIFoxAnalyzer;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.PatternFilter;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="active", type="boolean", defaultValue="false", flags=75), @NiagaraProperty(name="mode", type="BFoxAnalyzerMode", defaultValue="BFoxAnalyzerMode.clientAndServer"), @NiagaraProperty(name="viewLogLimit", type="int", defaultValue="4096", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(5))")}), @NiagaraProperty(name="showDebugFrames", type="boolean", defaultValue="true"), @NiagaraProperty(name="currentStation", type="String", defaultValue="Station name not configured", flags=67), @NiagaraProperty(name="stationName", type="BFormat", defaultValue="BFormat.make(\"%parent.name%\")"), @NiagaraProperty(name="id", type="String", defaultValue=""), @NiagaraProperty(name="channelPattern", type="String", defaultValue="*"), @NiagaraProperty(name="commandPattern", type="String", defaultValue="*"), @NiagaraProperty(name="totalReadFrames", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="lastReadFrameDateTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="totalWriteFrames", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="lastWriteFrameDateTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=67), @NiagaraProperty(name="historyEnabled", type="boolean", defaultValue="false", flags=64), @NiagaraProperty(name="historyId", type="BHistoryId", defaultValue="BHistoryId.make(\"^\", \"fox\")"), @NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig(BHistoryId.DEFAULT, BFoxFrameRecord.TYPE.getTypeSpec())")})
@NiagaraTopic(name="newFrame", eventType="BFoxFrameRecord", flags=264)
public final class BFoxStationAnalyzer
extends BComponent
implements BIFoxAnalyzer,
BIStatus {
    @Generated
    public static final Property status = BFoxStationAnalyzer.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property active = BFoxStationAnalyzer.newProperty((int)75, (boolean)false, null);
    @Generated
    public static final Property mode = BFoxStationAnalyzer.newProperty((int)0, (BValue)BFoxAnalyzerMode.clientAndServer, null);
    @Generated
    public static final Property viewLogLimit = BFoxStationAnalyzer.newProperty((int)0, (int)4096, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)5)));
    @Generated
    public static final Property showDebugFrames = BFoxStationAnalyzer.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property currentStation = BFoxStationAnalyzer.newProperty((int)67, (String)"Station name not configured", null);
    @Generated
    public static final Property stationName = BFoxStationAnalyzer.newProperty((int)0, (BValue)BFormat.make((String)"%parent.name%"), null);
    @Generated
    public static final Property id = BFoxStationAnalyzer.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property channelPattern = BFoxStationAnalyzer.newProperty((int)0, (String)"*", null);
    @Generated
    public static final Property commandPattern = BFoxStationAnalyzer.newProperty((int)0, (String)"*", null);
    @Generated
    public static final Property totalReadFrames = BFoxStationAnalyzer.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property lastReadFrameDateTime = BFoxStationAnalyzer.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property totalWriteFrames = BFoxStationAnalyzer.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property lastWriteFrameDateTime = BFoxStationAnalyzer.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property historyEnabled = BFoxStationAnalyzer.newProperty((int)64, (boolean)false, null);
    @Generated
    public static final Property historyId = BFoxStationAnalyzer.newProperty((int)0, (BValue)BHistoryId.make((String)"^", (String)"fox"), null);
    @Generated
    public static final Property historyConfig = BFoxStationAnalyzer.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.DEFAULT, BFoxFrameRecord.TYPE.getTypeSpec()), null);
    @Generated
    public static final Topic newFrame = BFoxStationAnalyzer.newTopic((int)264, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxStationAnalyzer.class);
    private static final Log log = Log.getLog((String)"foxStationAnalyzer");
    private static final BIcon icon = BIcon.std((String)"magnifyingGlass.png");
    private Listener listener = new Listener();
    private Factory factory = new Factory();
    private volatile PatternFilter channelFilter = new PatternFilter("*");
    private volatile PatternFilter commandFilter = new PatternFilter("*");
    private static Worker worker;
    private static final Queue queue;
    private static int startCount;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getActive() {
        return this.getBoolean(active);
    }

    @Generated
    public void setActive(boolean v) {
        this.setBoolean(active, v, null);
    }

    @Generated
    public BFoxAnalyzerMode getMode() {
        return (BFoxAnalyzerMode)this.get(mode);
    }

    @Generated
    public void setMode(BFoxAnalyzerMode v) {
        this.set(mode, (BValue)v, null);
    }

    @Override
    @Generated
    public int getViewLogLimit() {
        return this.getInt(viewLogLimit);
    }

    @Generated
    public void setViewLogLimit(int v) {
        this.setInt(viewLogLimit, v, null);
    }

    @Generated
    public boolean getShowDebugFrames() {
        return this.getBoolean(showDebugFrames);
    }

    @Generated
    public void setShowDebugFrames(boolean v) {
        this.setBoolean(showDebugFrames, v, null);
    }

    @Generated
    public String getCurrentStation() {
        return this.getString(currentStation);
    }

    @Generated
    public void setCurrentStation(String v) {
        this.setString(currentStation, v, null);
    }

    @Generated
    public BFormat getStationName() {
        return (BFormat)this.get(stationName);
    }

    @Generated
    public void setStationName(BFormat v) {
        this.set(stationName, (BValue)v, null);
    }

    @Generated
    public String getId() {
        return this.getString(id);
    }

    @Generated
    public void setId(String v) {
        this.setString(id, v, null);
    }

    @Generated
    public String getChannelPattern() {
        return this.getString(channelPattern);
    }

    @Generated
    public void setChannelPattern(String v) {
        this.setString(channelPattern, v, null);
    }

    @Generated
    public String getCommandPattern() {
        return this.getString(commandPattern);
    }

    @Generated
    public void setCommandPattern(String v) {
        this.setString(commandPattern, v, null);
    }

    @Generated
    public int getTotalReadFrames() {
        return this.getInt(totalReadFrames);
    }

    @Generated
    public void setTotalReadFrames(int v) {
        this.setInt(totalReadFrames, v, null);
    }

    @Generated
    public BAbsTime getLastReadFrameDateTime() {
        return (BAbsTime)this.get(lastReadFrameDateTime);
    }

    @Generated
    public void setLastReadFrameDateTime(BAbsTime v) {
        this.set(lastReadFrameDateTime, (BValue)v, null);
    }

    @Generated
    public int getTotalWriteFrames() {
        return this.getInt(totalWriteFrames);
    }

    @Generated
    public void setTotalWriteFrames(int v) {
        this.setInt(totalWriteFrames, v, null);
    }

    @Generated
    public BAbsTime getLastWriteFrameDateTime() {
        return (BAbsTime)this.get(lastWriteFrameDateTime);
    }

    @Generated
    public void setLastWriteFrameDateTime(BAbsTime v) {
        this.set(lastWriteFrameDateTime, (BValue)v, null);
    }

    @Generated
    public boolean getHistoryEnabled() {
        return this.getBoolean(historyEnabled);
    }

    @Generated
    public void setHistoryEnabled(boolean v) {
        this.setBoolean(historyEnabled, v, null);
    }

    @Generated
    public BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    @Generated
    public void setHistoryId(BHistoryId v) {
        this.set(historyId, (BValue)v, null);
    }

    @Generated
    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    @Generated
    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    @Generated
    public void fireNewFrame(BFoxFrameRecord event) {
        this.fire(newFrame, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started() throws Exception {
        this.setCurrentStation(this.getStationName().format((Object)this));
        this.setStatus(SlotPath.isValidName((String)this.getCurrentStation()) ? BStatus.ok : BStatus.fault);
        this.channelFilter = new PatternFilter(this.getChannelPattern());
        this.commandFilter = new PatternFilter(this.getCommandPattern());
        Class<BFoxStationAnalyzer> clazz = BFoxStationAnalyzer.class;
        synchronized (BFoxStationAnalyzer.class) {
            ++startCount;
            if (worker == null) {
                worker = new Worker((Worker.ITodo)queue);
                worker.start("foxStationAnalyzer");
                if (log.isTraceOn()) {
                    log.trace("Starting Fox Analyzer Worker Thread");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.requiresRegistering()) {
                FoxSession.registerListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
                this.setActive(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        FoxSession.unregisterListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
        this.setActive(false);
        Class<BFoxStationAnalyzer> clazz = BFoxStationAnalyzer.class;
        synchronized (BFoxStationAnalyzer.class) {
            if (--startCount <= 0 && worker != null) {
                worker.stop();
                worker = null;
                if (log.isTraceOn()) {
                    log.trace("Stopping Fox Analyzer Worker Thread");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == mode) {
            if (this.requiresRegistering()) {
                FoxSession.registerListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
                this.setActive(true);
                this.configChanged("Analyzer Config: Mode changed: " + (Object)((Object)this.getMode()));
            }
        } else if (property == stationName) {
            String oldStationName = this.getCurrentStation();
            this.setCurrentStation(this.getStationName().format((Object)this));
            this.setStatus(SlotPath.isValidName((String)this.getCurrentStation()) ? BStatus.ok : BStatus.fault);
            if (this.requiresRegistering()) {
                FoxSession.registerListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
                this.setActive(true);
                this.configChanged("Analyzer Config: Station name changed: " + oldStationName + " -> " + this.getCurrentStation());
            } else {
                FoxSession.unregisterListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
                this.setActive(false);
            }
        } else if (property == channelPattern) {
            this.channelFilter = new PatternFilter(this.getChannelPattern());
            if (this.requiresRegistering()) {
                this.configChanged("Analyzer Config: Channel filter changed: " + this.getChannelPattern());
            }
        } else if (property == commandPattern) {
            this.commandFilter = new PatternFilter(this.getCommandPattern());
            if (this.requiresRegistering()) {
                this.configChanged("Analyzer Config: Command filter changed: " + this.getCommandPattern());
            }
        } else if (property == id) {
            if (this.requiresRegistering()) {
                this.configChanged("Analyzer Config: Id changed: " + this.getId());
            }
        } else if (property == showDebugFrames) {
            if (this.requiresRegistering()) {
                this.configChanged("Analyzer Config: Show Debug Frames changed: " + this.getShowDebugFrames());
            }
        } else if (property == historyEnabled) {
            if (this.requiresRegistering()) {
                FoxSession.registerListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
                this.setActive(true);
                this.configChanged("Analyzer Config: History Enabled changed: " + this.getHistoryEnabled());
            } else {
                FoxSession.unregisterListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
                this.setActive(false);
            }
        } else if (property == historyId && this.requiresRegistering()) {
            this.configChanged("Analyzer Config: History Id changed: " + this.getHistoryId());
        }
    }

    public void subscribed() {
        if (this.isRunning() && this.requiresRegistering()) {
            FoxSession.registerListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
            this.setActive(true);
        }
    }

    public void unsubscribed() {
        if (this.isRunning() && !this.requiresRegistering()) {
            FoxSession.unregisterListenerFactory((FoxSession.IFoxSessionListenerFactory)this.factory);
            this.setActive(false);
        }
    }

    private boolean requiresRegistering() {
        return (this.isSubscribed() || this.getHistoryEnabled()) && this.getStatus().isOk();
    }

    private void post(Runnable runnable) {
        queue.enqueue((Object)runnable);
    }

    private void recordToHistory(BFoxFrameRecord record) {
        if (!this.getHistoryEnabled()) {
            return;
        }
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                BHistoryConfig config = this.getHistoryConfig();
                config.setTimeZone(BTimeZone.getLocal());
                BHistoryId id = this.getHistoryId();
                id = id.fromShorthand(this.getCurrentStation());
                config.setId(id);
                if (!conn.exists(id)) {
                    conn.createHistory(config);
                } else {
                    conn.reconfigureHistory(config);
                }
                BIHistory history = conn.getHistory(id);
                conn.append(history, (BIHistoryRecordSet)record);
                conn.flush(history);
            }
        }
        catch (Exception e) {
            log.error("Writing Fox Analyzer History", (Throwable)e);
        }
    }

    private void configChanged(String state) {
        this.listener.stateChanged(null, state, null);
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Fox Analyzer");
        out.prop((Object)"Channel Filter", (Object)this.channelFilter.getPattern());
        out.prop((Object)"Command Filter", (Object)this.commandFilter.getPattern());
        out.endProps();
        super.spy(out);
    }

    @Override
    public Topic getNewFrameTopic() {
        return newFrame;
    }

    @Override
    public void register() {
    }

    @Override
    public void unregister() {
    }

    static {
        queue = new Queue();
        startCount = 0;
    }

    private class Listener
    implements FoxSession.IFoxSessionListener {
        private Listener() {
        }

        public void connectionAborted(final String cause, final Throwable throwable) {
            BFoxStationAnalyzer.this.post(new Runnable(){

                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make(BFoxFrameRecordType.connectionAborted, cause, throwable);
                    BFoxStationAnalyzer.this.fireNewFrame(rec);
                    BFoxStationAnalyzer.this.recordToHistory(rec);
                }
            });
        }

        public void stateChanged(final FoxSession session, final String state, final Throwable throwable) {
            if (!this.validateSession(session)) {
                return;
            }
            BFoxStationAnalyzer.this.post(new Runnable(){

                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make(BFoxFrameRecordType.stateChanged, session, state, throwable);
                    BFoxStationAnalyzer.this.fireNewFrame(rec);
                    BFoxStationAnalyzer.this.recordToHistory(rec);
                }
            });
        }

        public void readFrame(final FoxSession session, final FoxFrame frame) {
            if (!this.validateSession(session)) {
                return;
            }
            if (!this.validateFrame(frame)) {
                return;
            }
            BFoxStationAnalyzer.this.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make(BFoxFrameRecordType.readFrame, session, frame, BFoxStationAnalyzer.this.getShowDebugFrames());
                    BFoxStationAnalyzer.this.fireNewFrame(rec);
                    BFoxStationAnalyzer.this.recordToHistory(rec);
                    BFoxStationAnalyzer bFoxStationAnalyzer = BFoxStationAnalyzer.this;
                    synchronized (bFoxStationAnalyzer) {
                        BFoxStationAnalyzer.this.setTotalReadFrames(BFoxStationAnalyzer.this.getTotalReadFrames() + 1);
                    }
                    BFoxStationAnalyzer.this.setLastReadFrameDateTime(BAbsTime.now());
                }
            });
        }

        public void writeFrame(final FoxSession session, final FoxFrame frame) {
            if (!this.validateSession(session)) {
                return;
            }
            if (!this.validateFrame(frame)) {
                return;
            }
            BFoxStationAnalyzer.this.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BFoxFrameRecord rec = BFoxFrameRecord.make(BFoxFrameRecordType.writeFrame, session, frame, BFoxStationAnalyzer.this.getShowDebugFrames());
                    BFoxStationAnalyzer.this.fireNewFrame(rec);
                    BFoxStationAnalyzer.this.recordToHistory(rec);
                    BFoxStationAnalyzer bFoxStationAnalyzer = BFoxStationAnalyzer.this;
                    synchronized (bFoxStationAnalyzer) {
                        BFoxStationAnalyzer.this.setTotalWriteFrames(BFoxStationAnalyzer.this.getTotalWriteFrames() + 1);
                    }
                    BFoxStationAnalyzer.this.setLastWriteFrameDateTime(BAbsTime.now());
                }
            });
        }

        private boolean validateFrame(FoxFrame frame) {
            return BFoxStationAnalyzer.this.channelFilter.accept(frame.channel) && BFoxStationAnalyzer.this.commandFilter.accept(frame.command);
        }

        private boolean validateSession(FoxSession session) {
            return session == null || BFoxStationAnalyzer.this.getId().isEmpty() || !session.getId().equals(BFoxStationAnalyzer.this.getId());
        }
    }

    private class Factory
    implements FoxSession.IFoxSessionListenerFactory {
        private Factory() {
        }

        public FoxSession.IFoxSessionListener make(FoxConnection conn) {
            if (!BFoxStationAnalyzer.this.getStatus().isOk()) {
                return null;
            }
            if (conn == null) {
                return null;
            }
            if (!(conn instanceof BFoxConnection)) {
                return null;
            }
            BFoxAnalyzerMode mode = BFoxStationAnalyzer.this.getMode();
            if (mode == BFoxAnalyzerMode.server && conn instanceof BFoxClientConnection) {
                return null;
            }
            if (mode == BFoxAnalyzerMode.client && !(conn instanceof BFoxClientConnection)) {
                return null;
            }
            BFoxConnection foxConn = (BFoxConnection)conn;
            Optional station = foxConn.getConnectionTarget(NiagaraStation.class);
            if (!station.isPresent()) {
                return null;
            }
            if (BFoxStationAnalyzer.this.getCurrentStation().length() == 0) {
                return null;
            }
            if (!((NiagaraStation)station.get()).getStationName().equals(BFoxStationAnalyzer.this.getCurrentStation())) {
                return null;
            }
            return BFoxStationAnalyzer.this.listener;
        }
    }
}

