/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard;

import com.tridium.fcEasyOnboard.ActivityStatus;
import com.tridium.fcEasyOnboard.utils.OnboardUtils;
import com.tridium.nc.alarms.BCloudAlarmRecipient;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class CloudAlarmsHelper {
    private static final Logger logger = Logger.getLogger("fcEasyOnboard");

    public ActivityStatus addCloudAlarmRecipient(BCloudSentienceDevice device) {
        if (device == null) {
            throw new RuntimeException("A Cloud Device needs to exist");
        }
        logger.fine("Checking for the existence of Cloud Alarm Recipient");
        BCloudAlarmRecipient recipient = OnboardUtils.getCloudAlarmRecipient();
        if (recipient != null) {
            logger.fine("Cloud Alarm Recipient already exists");
            return ActivityStatus.makeSkip("Cloud Alarm Recipient already exists - " + OnboardUtils.toOrd((BComponent)recipient));
        }
        logger.fine("Cloud Alarm Recipient is absent.  Attempting to create it.");
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BCloudAlarmRecipient cloudAlarmRecipient = new BCloudAlarmRecipient();
        alarmService.add("cloudAlarmRecipient", (BValue)cloudAlarmRecipient);
        logger.fine("Cloud Alarm Recipient added to the Alarm Service");
        String strOrd = "station:|" + device.getSlotPath().toString();
        logger.fine("Found Cloud Device for the Cloud Alarm Recipient (" + strOrd + ')');
        cloudAlarmRecipient.setDevice(BOrd.make((String)strOrd));
        BAlarmClass[] alarmClasses = alarmService.getAlarmClasses();
        logger.fine("Attempting to add links with the Cloud Alarm Recipient.");
        for (BAlarmClass alarmClass : alarmClasses) {
            LinkCheck linkCheck = cloudAlarmRecipient.checkLink((BComponent)alarmClass, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, null);
            if (!linkCheck.isValid()) continue;
            BLink link = cloudAlarmRecipient.makeLink((BComponent)alarmClass, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, null);
            cloudAlarmRecipient.add("link?", (BValue)link);
            link.activate();
            logger.fine("New Link Created between " + alarmClass.getName() + " and Cloud Alarm Recipient.");
        }
        logger.fine("Number of Links Created:" + cloudAlarmRecipient.getLinks().length);
        return ActivityStatus.makeSuccess("Adds cloud alarm recipient - " + OnboardUtils.toOrd((BComponent)cloudAlarmRecipient));
    }

    public ActivityStatus removeCloudAlarmRecipient() {
        LinkedList<BCloudAlarmRecipient> list = OnboardUtils.getCloudAlarmRecipients();
        String ordList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BCloudAlarmRecipient comp : list) {
            BComponent parent = (BComponent)comp.getParent();
            parent.remove(comp.getName());
        }
        return ActivityStatus.makeSuccess("Removed Cloud Alarm Recipients - " + ordList);
    }
}

