/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard;

import com.tridium.authn.BAuthenticationService;
import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.BConnectorImpl;
import com.tridium.cloud.client.iotdep.BIotHubMessageClient;
import com.tridium.cloud.client.iothub.BMessageClient;
import com.tridium.cloud.client.sentience.BSentienceConnectorImpl;
import com.tridium.cloud.client.sentience.BSentienceDevTestComponent;
import com.tridium.fcEasyOnboard.ActivityStatus;
import com.tridium.fcEasyOnboard.ICloudConfiguration;
import com.tridium.fcEasyOnboard.utils.OnboardUtils;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import com.tridium.nc.security.BCloudAuthenticationScheme;
import com.tridium.nc.security.BUserMapping;
import com.tridium.util.CompUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.BOrd;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;

public class CloudConnectorHelper {
    private static final String CLOUD_AUTHENTICATION_SCHEME_NAME = "CloudAuthenticationScheme";
    private static final String CLOUD_USERNAME = "cloudUser";
    private final ICloudConfiguration config;

    public CloudConnectorHelper(ICloudConfiguration iCloudConfiguration) {
        this.config = iCloudConfiguration;
    }

    public ActivityStatus addConnector() {
        BServiceContainer serviceContainer = Sys.getStation().getServices();
        BCloudConnector connector = OnboardUtils.getCloudConnector();
        if (connector != null) {
            return this.updateConnectionImplConfig(connector);
        }
        BCloudConnector bCloudConnector = new BCloudConnector();
        BIotHubMessageClient messageClient = new BIotHubMessageClient();
        BSentienceConnectorImpl connectorImpl = new BSentienceConnectorImpl();
        if (this.config.isTestMode()) {
            BSentienceDevTestComponent testComponent = new BSentienceDevTestComponent();
            connectorImpl.add("SentienceDevTestComponent", (BValue)testComponent);
        }
        connectorImpl.setSystemType(this.config.getSystemType());
        connectorImpl.setFlags((Slot)BSentienceConnectorImpl.systemType, 1);
        connectorImpl.setDeviceAuthenticationUrl(this.config.getDeviceAuthenticationURL());
        connectorImpl.setDeviceRegistrationUrl(this.config.getDeviceRegistrationURL());
        connectorImpl.setRegistrationUrl(this.config.getRegistrationURL());
        connectorImpl.setMessageClient((BMessageClient)messageClient);
        if (this.config.isMigratingAKnownDevice()) {
            connectorImpl.setMigrationUrl(this.config.getDeviceRegistrationURL());
        }
        bCloudConnector.setConnectorImpl((BConnectorImpl)connectorImpl);
        serviceContainer.add("CloudConnector", (BValue)bCloudConnector);
        return ActivityStatus.makeSuccess("Added new cloud connector - " + OnboardUtils.toOrd((BComponent)bCloudConnector));
    }

    private ActivityStatus updateConnectionImplConfig(BCloudConnector connector) {
        Boolean isConnectorImplUpdated = false;
        BSentienceConnectorImpl connectorImpl = (BSentienceConnectorImpl)connector.getConnectorImpl();
        if (!connectorImpl.getDeviceAuthenticationUrl().equals(this.config.getDeviceAuthenticationURL())) {
            connectorImpl.setDeviceAuthenticationUrl(this.config.getDeviceAuthenticationURL());
            isConnectorImplUpdated = true;
        }
        if (!connectorImpl.getDeviceRegistrationUrl().equals(this.config.getDeviceRegistrationURL())) {
            connectorImpl.setDeviceRegistrationUrl(this.config.getDeviceRegistrationURL());
            isConnectorImplUpdated = true;
        }
        if (!connectorImpl.getRegistrationUrl().equals(this.config.getRegistrationURL())) {
            connectorImpl.setRegistrationUrl(this.config.getRegistrationURL());
            isConnectorImplUpdated = true;
        }
        if (isConnectorImplUpdated.booleanValue()) {
            this.updateConnectorImplTestComponent(connectorImpl);
            return ActivityStatus.makeSuccess("Connector URLs value updated with environment - " + this.config.getEnvironmentName() + ", " + OnboardUtils.toOrd((BComponent)connector));
        }
        return ActivityStatus.makeSkip("Connector with correct URLs already exists - " + OnboardUtils.toOrd((BComponent)connector));
    }

    private void updateConnectorImplTestComponent(BSentienceConnectorImpl connectorImpl) {
        if (this.config.isTestMode()) {
            if (connectorImpl.getProperty("SentienceDevTestComponent") == null) {
                BSentienceDevTestComponent testComponent = new BSentienceDevTestComponent();
                connectorImpl.add("SentienceDevTestComponent", (BValue)testComponent);
            }
        } else if (connectorImpl.getProperty("SentienceDevTestComponent") != null) {
            connectorImpl.remove("SentienceDevTestComponent");
        }
    }

    public ActivityStatus addCloudNetwork() {
        BDriverContainer[] drivers = (BDriverContainer[])Sys.getStation().getChildren(BDriverContainer.class);
        BNiagaraCloudNetwork network = OnboardUtils.getCloudNetwork();
        if (network != null) {
            return ActivityStatus.makeSkip("Cloud Network already exists - " + OnboardUtils.toOrd((BComponent)network));
        }
        BNiagaraCloudNetwork cloudNetwork = new BNiagaraCloudNetwork();
        CompUtil.setOrAdd((BComponent)cloudNetwork, (String)BNiagaraCloudNetwork.POINT_READ_ALLOWED, (BValue)BBoolean.TRUE, (int)0, null, null);
        CompUtil.setOrAdd((BComponent)cloudNetwork, (String)BNiagaraCloudNetwork.POINT_WRITE_ALLOWED, (BValue)BBoolean.TRUE, (int)0, null, null);
        drivers[0].add("NiagaraCloudNetwork", (BValue)cloudNetwork);
        return ActivityStatus.makeSuccess("Added new Cloud Network - " + OnboardUtils.toOrd((BComponent)cloudNetwork));
    }

    public ActivityStatus addCloudDevice() {
        BNiagaraCloudNetwork network = OnboardUtils.getCloudNetwork();
        BCloudSentienceDevice cloudSentienceDevice = OnboardUtils.getCloudSentienceDevice();
        if (cloudSentienceDevice != null) {
            return ActivityStatus.makeSkip("Cloud device already exists - " + OnboardUtils.toOrd((BComponent)cloudSentienceDevice));
        }
        BCloudSentienceDevice device = new BCloudSentienceDevice();
        BCloudConnector connector = OnboardUtils.getCloudConnector();
        String strOrd = "station:|" + connector.getSlotPath().toString();
        device.setConnector(BOrd.make((String)strOrd));
        device.getCommands().setEnabled(true);
        network.add("CloudSentienceDevice", (BValue)device);
        return ActivityStatus.makeSuccess("Added new Cloud Device - " + OnboardUtils.toOrd((BComponent)device));
    }

    public ActivityStatus addCloudUser() {
        List<BUser> cloudUsers = OnboardUtils.getCloudUsers();
        if (!cloudUsers.isEmpty()) {
            String usersList = cloudUsers.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
            return ActivityStatus.makeSkip("Cloud users already exist - \n" + usersList);
        }
        BUserService userService = BUserService.getService();
        BUser user = new BUser();
        user.setAuthenticationSchemeName(CLOUD_AUTHENTICATION_SCHEME_NAME);
        user.addRole("CloudManager", null);
        user.addRole("CloudOperator", null);
        BPasswordAuthenticator authenticator = new BPasswordAuthenticator();
        authenticator.setPassword(BPassword.make((String)"Hon@123$1"));
        user.setAuthenticator((BAbstractAuthenticator)authenticator);
        user.setFullName(CLOUD_USERNAME);
        userService.add(CLOUD_USERNAME, (BValue)user);
        return ActivityStatus.makeSuccess("Added new Cloud User - " + OnboardUtils.toOrd((BComponent)user));
    }

    public ActivityStatus addCloudAuthenticationScheme() {
        BAuthenticationService authenticationService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        BCloudAuthenticationScheme[] cloudSchems = (BCloudAuthenticationScheme[])authenticationService.getAuthenticationSchemes().getChildren(BCloudAuthenticationScheme.class);
        if (cloudSchems.length > 0) {
            return ActivityStatus.makeSkip("Cloud Authentication Scheme already exists - " + OnboardUtils.toOrd((BComponent)cloudSchems[0]));
        }
        BCloudAuthenticationScheme cloudAuthenticationScheme = new BCloudAuthenticationScheme();
        authenticationService.getAuthenticationSchemes().add(CLOUD_AUTHENTICATION_SCHEME_NAME, (BValue)cloudAuthenticationScheme);
        return ActivityStatus.makeSuccess("Added new Cloud Authentication Scheme - " + OnboardUtils.toOrd((BComponent)cloudAuthenticationScheme));
    }

    public ActivityStatus addUserMappings(Map.Entry<String, String> appIdMapping) {
        BCloudAuthenticationScheme cloudAuthenticationScheme = OnboardUtils.getCloudAuthenticationScheme();
        BUserMapping userMapping = (BUserMapping)cloudAuthenticationScheme.getUserMappings().get(appIdMapping.getKey());
        if (userMapping != null) {
            return this.updateUserMappings(cloudAuthenticationScheme, appIdMapping);
        }
        List<BUser> users = OnboardUtils.getCloudUsers();
        String userName = users.get(0).getName();
        cloudAuthenticationScheme.getUserMappings().setEnabled(true);
        userMapping = new BUserMapping();
        userMapping.setAppId(appIdMapping.getValue());
        userMapping.setUserName(userName);
        cloudAuthenticationScheme.getUserMappings().add(appIdMapping.getKey(), (BValue)userMapping);
        return ActivityStatus.makeSuccess("Added new UserMapping for (" + appIdMapping.getKey() + ", " + userName + ") - " + OnboardUtils.toOrd((BComponent)userMapping));
    }

    private ActivityStatus updateUserMappings(BCloudAuthenticationScheme cloudAuthenticationScheme, Map.Entry<String, String> appIdMapping) {
        BUserMapping userMapping = (BUserMapping)cloudAuthenticationScheme.getUserMappings().get(appIdMapping.getKey());
        if (!userMapping.getAppId().equals(appIdMapping.getValue())) {
            userMapping.setAppId(appIdMapping.getValue());
            return ActivityStatus.makeSuccess("User Mapping updated with environment " + this.config.getEnvironmentName() + " , appId = " + appIdMapping.getKey() + ", userName - " + userMapping.getUserName());
        }
        return ActivityStatus.makeSkip("User Mapping already exists for appId = " + appIdMapping.getKey() + ", userName - " + userMapping.getUserName());
    }

    public ActivityStatus removeCloudNetwork() {
        LinkedList<BNiagaraCloudNetwork> list = OnboardUtils.getCloudNetworks();
        String networkList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BNiagaraCloudNetwork nw : list) {
            BComponent parent = (BComponent)nw.getParent();
            parent.remove(nw.getName());
        }
        return ActivityStatus.makeSuccess("Removed Cloud Networks - " + networkList);
    }

    public ActivityStatus removeCloudAuthenticationScheme() {
        LinkedList<BCloudAuthenticationScheme> list = OnboardUtils.getCloudAuthenticationSchemes();
        String ordList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BCloudAuthenticationScheme comp : list) {
            BComponent parent = (BComponent)comp.getParent();
            parent.remove(comp.getName());
        }
        return ActivityStatus.makeSuccess("Removed Cloud Authentication Schemes - " + ordList);
    }

    public ActivityStatus removeCloudUser() {
        BUserService userService = BUserService.getService();
        List<BUser> list = OnboardUtils.getCloudUsers();
        String ordList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BUser comp : list) {
            userService.remove(comp.getName());
        }
        return ActivityStatus.makeSuccess("Removed Cloud users - " + ordList);
    }
}

