/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard.env;

import com.tridium.fcEasyOnboard.env.EnvironmentSettings;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="cbProduction"), @Range(value="hbtProduction"), @Range(value="qa"), @Range(value="staging"), @Range(value="uaeProduction")}, defaultValue="cbProduction")
public final class BEnvironment
extends BFrozenEnum {
    public static final int CB_PRODUCTION = 0;
    public static final int HBT_PRODUCTION = 1;
    public static final int QA = 2;
    public static final int STAGING = 3;
    public static final int UAE_PRODUCTION = 4;
    public static final BEnvironment cbProduction = new BEnvironment(0);
    public static final BEnvironment hbtProduction = new BEnvironment(1);
    public static final BEnvironment qa = new BEnvironment(2);
    public static final BEnvironment staging = new BEnvironment(3);
    public static final BEnvironment uaeProduction = new BEnvironment(4);
    public static final BEnvironment DEFAULT = cbProduction;
    public static final Type TYPE = Sys.loadType(BEnvironment.class);

    public static BEnvironment make(int ordinal) {
        return (BEnvironment)cbProduction.getRange().get(ordinal, false);
    }

    public static BEnvironment make(String tag) {
        return (BEnvironment)cbProduction.getRange().get(tag);
    }

    private BEnvironment(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public EnvironmentSettings getSettings() {
        if (this == qa) {
            return EnvironmentSettings.QA;
        }
        if (this == staging) {
            return EnvironmentSettings.STAGING;
        }
        if (this == hbtProduction) {
            return EnvironmentSettings.HBT_PRODUCTION;
        }
        if (this == uaeProduction) {
            return EnvironmentSettings.UAE_PRODUCTION;
        }
        return EnvironmentSettings.CB_PRODUCTION;
    }
}

