/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard.jobs;

import com.tridium.fcEasyOnboard.ActivityLogger;
import com.tridium.fcEasyOnboard.ActivityStatus;
import com.tridium.fcEasyOnboard.CloudAlarmsHelper;
import com.tridium.fcEasyOnboard.CloudAlertsHelper;
import com.tridium.fcEasyOnboard.CloudConnectorHelper;
import com.tridium.fcEasyOnboard.CloudEventsHelper;
import com.tridium.fcEasyOnboard.ICloudConfiguration;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCleanCloudConfigJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BCleanCloudConfigJob.class);
    private ICloudConfiguration config;

    public Type getType() {
        return TYPE;
    }

    public BCleanCloudConfigJob() {
    }

    public BCleanCloudConfigJob(ICloudConfiguration bEasyOnboard) {
        this.config = bEasyOnboard;
    }

    public void run(Context context) throws Exception {
        ActivityLogger logger = new ActivityLogger(this.log());
        this.log().start("Starting Cloud Config Cleaning activities..");
        CloudConnectorHelper cloudConnectorHelper = new CloudConnectorHelper(this.config);
        logger.logActivity("Remove Cloud Connector", ActivityStatus.makeSkip("Intentionally Skipping, perform manually"));
        ActivityStatus status = cloudConnectorHelper.removeCloudNetwork();
        logger.logActivity("Remove Cloud Networks and Devices", status);
        status = cloudConnectorHelper.removeCloudUser();
        logger.logActivity("Remove Cloud User", status);
        status = cloudConnectorHelper.removeCloudAuthenticationScheme();
        logger.logActivity("Remove Cloud Authentication Scheme and User Mappings", status);
        CloudAlarmsHelper cloudAlarmsHelper = new CloudAlarmsHelper();
        status = cloudAlarmsHelper.removeCloudAlarmRecipient();
        logger.logActivity("Remove Cloud Alarm Recipient", status);
        CloudEventsHelper cloudEventsHelper = new CloudEventsHelper();
        status = cloudEventsHelper.removeCloudEventRecipient();
        logger.logActivity("Remove Cloud Event Recipient", status);
        CloudAlertsHelper cloudAlertsHelper = new CloudAlertsHelper();
        status = cloudAlertsHelper.removeForgeTagDictionary();
        logger.logActivity("Remove FC Tag Dictionary", status);
        status = cloudAlertsHelper.removeModelSyncService();
        logger.logActivity("Remove Model Sync Service", status);
        this.log().message("Completed on board activities");
    }
}

