/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.enums.BReplaceExistingEnum;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="learnOptimumDevicePollConfig", parameterType="BReplaceExistingEnum", defaultValue="BReplaceExistingEnum.replaceExistingEntries"), @NiagaraAction(name="clear", flags=128)})
public class BDevicePollConfigTable
extends BComponent {
    @Generated
    public static final Action learnOptimumDevicePollConfig = BDevicePollConfigTable.newAction((int)0, (BValue)BReplaceExistingEnum.replaceExistingEntries, null);
    @Generated
    public static final Action clear = BDevicePollConfigTable.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDevicePollConfigTable.class);

    @Generated
    public void learnOptimumDevicePollConfig(BReplaceExistingEnum parameter) {
        this.invoke(learnOptimumDevicePollConfig, (BValue)parameter, null);
    }

    @Generated
    public void clear() {
        this.invoke(clear, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public synchronized BDevicePollConfigEntry[] getDevicePollConfigList() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public BDevicePollConfigEntry[] getActiveInputRegisterPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.inputRegister)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public BDevicePollConfigEntry[] getActiveHoldingRegisterPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.holdingRegister)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public BDevicePollConfigEntry[] getActiveBinaryCoilPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.discreteCoil)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public BDevicePollConfigEntry[] getActiveBinaryInputPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.discreteInput)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public synchronized BDevicePollConfigEntry[] getPossibleInputRegisterPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.inputRegister)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public synchronized BDevicePollConfigEntry[] getPossibleHoldingRegisterPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.holdingRegister)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public synchronized BDevicePollConfigEntry[] getPossibleBinaryCoilPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.discreteCoil)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public synchronized BDevicePollConfigEntry[] getPossibleBinaryInputPollEntries() {
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BDevicePollConfigEntry.class)) {
            BValue kid = c.get();
            if (!((BDevicePollConfigEntry)kid).getEnabled() || !((BDevicePollConfigEntry)kid).getDataType().equals((Object)BRegisterTypesEnum.discreteInput)) continue;
            temp[count] = (BDevicePollConfigEntry)kid;
            ++count;
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public BDevicePollConfigEntry isRegisterDevicePolled(BRegisterTypesEnum registerType, BFlexAddress registerAddress, int numAddresses) {
        try {
            BDevicePollConfigEntry entry = null;
            if (registerType == BRegisterTypesEnum.holdingRegister ? (entry = BDevicePollConfigTable.findPollConfigEntry(this.getPossibleHoldingRegisterPollEntries(), registerAddress.getDataAddress(), numAddresses)) != null : (registerType == BRegisterTypesEnum.inputRegister ? (entry = BDevicePollConfigTable.findPollConfigEntry(this.getPossibleInputRegisterPollEntries(), registerAddress.getDataAddress(), numAddresses)) != null : (registerType == BRegisterTypesEnum.discreteCoil ? (entry = BDevicePollConfigTable.findPollConfigEntry(this.getPossibleBinaryCoilPollEntries(), registerAddress.getDataAddress(), numAddresses)) != null : registerType == BRegisterTypesEnum.discreteInput && (entry = BDevicePollConfigTable.findPollConfigEntry(this.getPossibleBinaryInputPollEntries(), registerAddress.getDataAddress(), numAddresses)) != null))) {
                return entry;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BDevicePollConfigEntry findPollConfigEntry(BDevicePollConfigEntry[] entries, int registerAddress, int numAddresses) {
        if (entries == null) {
            return null;
        }
        int lastRegisterAddress = registerAddress + numAddresses - 1;
        for (int i = 0; i < entries.length; ++i) {
            try {
                int startAddress = 0;
                int endAddress = 0;
                boolean isItPolled = false;
                if (entries[i] != null) {
                    startAddress = entries[i].getStartAddress().getDataAddress();
                    endAddress = startAddress + entries[i].getConsecutivePointsToPoll() - 1;
                }
                boolean bl = isItPolled = registerAddress >= startAddress && registerAddress <= endAddress && lastRegisterAddress >= startAddress && lastRegisterAddress <= endAddress;
                if (!isItPolled) continue;
                return entries[i];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void addEntry(BDevicePollConfigEntry entry) {
        this.add(null, (BValue)entry);
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public void setDevicePollConfigList(BDevicePollConfigEntry[] dataList) {
        this.clearEntries();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
        if (dataList != null) {
            for (int i = 0; i < dataList.length; ++i) {
                this.addEntry(dataList[i]);
            }
        }
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.getType() == BDevicePollConfigEntry.TYPE && this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (property.getType() == BDevicePollConfigEntry.TYPE && this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (property.getType() == BDevicePollConfigEntry.TYPE && this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
        }
    }

    public void doLearnOptimumDevicePollConfig(BReplaceExistingEnum replaceExistingEntries) {
        BModbusClientDevice device = this.getDevice();
        if (device != null) {
            BDevicePollConfigEntry[] entries = device.getOptimumDevicePollConfigEntryList();
            if (replaceExistingEntries.equals((Object)BReplaceExistingEnum.replaceExistingEntries)) {
                this.clearEntries();
            }
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    this.addEntry(entries[i]);
                }
            }
            if (this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
                ((BComponent)this.getParent()).changed(this.getPropertyInParent(), null);
            }
        }
    }

    public void doClear() {
        this.clearEntries();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
        if (this.getParent() != null && this.getPropertyInParent() != null && this.getParent() instanceof BComponent) {
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), null);
        }
    }

    private BModbusClientDevice getDevice() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BModbusClientDevice)) continue;
            return (BModbusClientDevice)parent;
        }
        return null;
    }
}

