/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BBasicPollGroup;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModbusClientPollGroup
extends BBasicPollGroup {
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientPollGroup.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void poll() {
        Object obj = this.getCode();
        if (obj instanceof BDevicePollConfigEntry) {
            BDevicePollConfigEntry entry = (BDevicePollConfigEntry)obj;
            if (!entry.getEnabled()) {
                return;
            }
            BModbusClientDevice device = entry.getDevice();
            if (device == null) {
                BBasicProxyExt[] proxies = this.getSubscribedProxyExts();
                if (proxies == null) return;
                for (int i = 0; i < proxies.length; ++i) {
                    try {
                        this.readUnsubscribed(proxies[i]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            int startAddress = entry.getStartAddress().getDataAddress();
            int numRegisters = entry.getConsecutivePointsToPoll();
            int minReadSize = entry.getReadGroupSize();
            try {
                if (entry.getDataType().equals((Object)BRegisterTypesEnum.inputRegister)) {
                    entry.setByteArray(device.readRegisters(4, startAddress, numRegisters, minReadSize, entry));
                } else if (entry.getDataType().equals((Object)BRegisterTypesEnum.holdingRegister)) {
                    entry.setByteArray(device.readRegisters(3, startAddress, numRegisters, minReadSize, entry));
                } else if (entry.getDataType().equals((Object)BRegisterTypesEnum.discreteCoil)) {
                    entry.setByteArray(device.readStatusRegisters(1, startAddress, numRegisters, entry));
                } else if (entry.getDataType().equals((Object)BRegisterTypesEnum.discreteInput)) {
                    entry.setByteArray(device.readStatusRegisters(2, startAddress, numRegisters, entry));
                }
                BBasicProxyExt[] proxies = this.getSubscribedProxyExts();
                if (proxies == null) return;
                for (int i = 0; i < proxies.length; ++i) {
                    ((BModbusClientProxyExt)proxies[i]).devicePoll(entry);
                }
                return;
            }
            catch (NotRunningException e) {
                throw e;
            }
            catch (Exception e) {
                device.getLogger().info("poll device timeout");
                return;
            }
        } else {
            if (!(obj instanceof BModbusClientProxyExt)) return;
            ((BModbusClientProxyExt)obj).poll();
        }
    }

    public String toString(Context context) {
        Object obj = this.getCode();
        if (obj instanceof BModbusClientProxyExt) {
            return ((BModbusClientProxyExt)obj).getParentPoint().getDisplayName(context) + " (" + ((BModbusClientProxyExt)obj).getAbsoluteAddress().toString(context) + ")";
        }
        if (obj instanceof BObject) {
            return ((BObject)obj).toString(context) + " (MCPG)";
        }
        return super.toString(context);
    }
}

