/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusBooleanProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="statusType", type="BStatusTypeEnum", defaultValue="BStatusTypeEnum.coil")
public class BModbusServerBooleanProxyExt
extends BModbusServerProxyExt
implements BIModbusBooleanProxyExt {
    @Generated
    public static final Property statusType = BModbusServerBooleanProxyExt.newProperty((int)0, (BValue)BStatusTypeEnum.coil, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusServerBooleanProxyExt.class);

    @Override
    @Generated
    public BStatusTypeEnum getStatusType() {
        return (BStatusTypeEnum)this.get(statusType);
    }

    @Override
    @Generated
    public void setStatusType(BStatusTypeEnum v) {
        this.set(statusType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
        int numRegisters = 1;
        ModbusResponse rsp = new ModbusResponse(this.modbusNet().getModbusMode(), device);
        int pointAddress = this.getDataAddress().getDataAddress();
        try {
            rsp.data = this.isCoilStatusType() ? device.getCoilStatusValues(pointAddress, numRegisters) : device.getInputStatusValues(pointAddress, numRegisters);
            rsp.exceptionCode = 0;
            rsp.byteCount = (byte)rsp.data.length;
            rsp.numberPoints = numRegisters;
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerBooleanProxyExt.read() caught exception: ", (Throwable)e);
            }
            this.readFail("Exception during read (" + e + ")");
            return;
        }
        this.setOutValues(rsp);
    }

    private void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            this.setBinaryOutValues(rec);
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setBinaryOutValues(ModbusResponse rec) {
        boolean binaryValue;
        try {
            binaryValue = rec.getBinary(0);
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing boolean value (" + e + ")");
            return;
        }
        BStatusBoolean val = new BStatusBoolean(binaryValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        if (this.getStatusType().equals((Object)BStatusTypeEnum.coil)) {
            return BRegisterTypesEnum.discreteCoil;
        }
        return BRegisterTypesEnum.discreteInput;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(statusType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusCoilAddress()) {
                    if (!this.isCoilStatusType()) {
                        this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
                    }
                } else if (this.isCoilStatusType()) {
                    this.set(statusType, (BValue)BStatusTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    @Override
    protected boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = 1;
            if (this.isCoilStatusType()) {
                return device.isCoilAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isStatusAddressValid(addr.getDataAddress(), numRegs);
        }
        if (addr.isModbusDigitalAddress()) {
            BStatusTypeEnum sType = BStatusTypeEnum.coil;
            if (addr.isModbusCoilAddress()) {
                this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
            } else {
                this.set(statusType, (BValue)BStatusTypeEnum.input, noAddressCheck);
                sType = BStatusTypeEnum.input;
            }
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = 1;
            if (sType.equals((Object)BStatusTypeEnum.coil)) {
                return device.isCoilAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isStatusAddressValid(addr.getDataAddress(), numRegs);
        }
        return false;
    }

    private boolean isCoilStatusType() {
        return this.getStatusType().equals((Object)BStatusTypeEnum.coil);
    }

    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (out == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(out);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer boolean point is not writable, disregarding write request.");
        }
        super.doWrite(out);
    }

    private boolean updateOutput(BStatusValue out) {
        boolean bVal = ((BStatusBoolean)out).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            boolean bValue = bVal;
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            BModbusServerNetwork network = (BModbusServerNetwork)this.modbusNet();
            boolean count = true;
            int address = device.getDeviceAddress();
            int pointAddress = this.getDataAddress().getDataAddress();
            if (this.isCoilStatusType()) {
                device.setCoilStatusValue(pointAddress, bValue);
            } else {
                device.setInputStatusValue(pointAddress, bValue);
            }
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().error(this.getParent().getName() + ": BModbusServerBooleanWritableProxyExt.updateOutput() caught exception: ", (Throwable)e);
            }
            this.writeFail("Error when writing (" + e + ")");
            return false;
        }
        this.writeOk(out);
        return true;
    }
}

