/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcTagDict.tag;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Tag;
import javax.baja.tagdictionary.BTagInfo;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="separator", type="String", defaultValue="/"), @NiagaraProperty(name="startFromType", type="BTypeSpec", defaultValue="BStation.TYPE.getTypeSpec()", facets={@Facet(name="\"showAbstract\"", value="BBoolean.TRUE"), @Facet(name="\"showInterface\"", value="BBoolean.TRUE")})})
public class BPathLabelTag
extends BTagInfo {
    public static final Property separator = BPathLabelTag.newProperty((int)0, (String)"/", null);
    public static final Property startFromType = BPathLabelTag.newProperty((int)0, (BValue)BStation.TYPE.getTypeSpec(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showAbstract", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"showInterface", (BIDataValue)BBoolean.TRUE)));
    public static final Type TYPE = Sys.loadType(BPathLabelTag.class);

    public String getSeparator() {
        return this.getString(separator);
    }

    public void setSeparator(String v) {
        this.setString(separator, v, null);
    }

    public BTypeSpec getStartFromType() {
        return (BTypeSpec)this.get(startFromType);
    }

    public void setStartFromType(BTypeSpec v) {
        this.set(startFromType, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDataValue getDefaultValue() {
        return BString.DEFAULT;
    }

    public Tag getTag(Entity entity) {
        String pathLabel = null;
        try {
            if (entity instanceof BComponent) {
                BComponent node = (BComponent)entity;
                List<BComponent> fullHierarchyList = BPathLabelTag.getFullHierarchyList((BComplex)node);
                List<BComponent> newHierarchyList = this.getSubHierarchy(fullHierarchyList);
                pathLabel = newHierarchyList.stream().map(comp -> comp.getDisplayName(null)).collect(Collectors.joining(this.getSeparator()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pathLabel == null || pathLabel.isEmpty() ? null : new Tag(this.getTagId(), (BIDataValue)BString.make((String)pathLabel));
    }

    private List<BComponent> getSubHierarchy(List<BComponent> fullHierarchyList) {
        Type startFromType = this.getStartFromType().getResolvedType();
        int subListStartIndex = 0;
        for (int index = 0; index < fullHierarchyList.size(); ++index) {
            BComponent component = fullHierarchyList.get(index);
            if (!component.getType().is(startFromType)) continue;
            subListStartIndex = index;
            break;
        }
        return fullHierarchyList.subList(subListStartIndex, fullHierarchyList.size());
    }

    private static List<BComponent> getFullHierarchyList(BComplex node) {
        LinkedList<BComponent> componentHierarchyList = new LinkedList<BComponent>();
        while (node instanceof BComponent) {
            componentHierarchyList.addFirst((BComponent)node);
            node = node.getParent();
        }
        return componentHierarchyList;
    }
}

