/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.user.BIUserAlarmRecipient;
import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="lastFaultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="priority", type="int", defaultValue="1", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1))")}), @NiagaraProperty(name="rotationMarker", type="int", defaultValue="-1", flags=69), @NiagaraProperty(name="user", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:OrdSelectFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:OrdSelectEditor\"), \"queryOrd\", BString.make(\"service:baja:UserService|bql:select icon.encodeToString, displayName, handleOrd, status.encodeToString from baja:User stop\"))"), @Facet(value="BFacets.make(\"enablePopOut\", BBoolean.make(false))")}), @NiagaraProperty(name="userAlarmRecipient", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:OrdSelectFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:OrdSelectEditor\"), \"queryOrd\", BString.make(\"station:|slot:|bql:select icon.encodeToString, displayName, handleOrd from alarm:IUserAlarmRecipient stop\"))"), @Facet(value="BFacets.make(\"enablePopOut\", BBoolean.make(false))")})})
public final class BOnCallContact
extends BComponent
implements BIStatus,
BOnCallService.UserListener {
    @Generated
    public static final Property status = BOnCallContact.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property lastFaultCause = BOnCallContact.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property enabled = BOnCallContact.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property priority = BOnCallContact.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property rotationMarker = BOnCallContact.newProperty((int)69, (int)-1, null);
    @Generated
    public static final Property user = BOnCallContact.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"wbutil:OrdSelectFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:OrdSelectEditor"), (String)"queryOrd", (BIDataValue)BString.make((String)"service:baja:UserService|bql:select icon.encodeToString, displayName, handleOrd, status.encodeToString from baja:User stop")), (BFacets)BFacets.make((String)"enablePopOut", (BIDataValue)BBoolean.make((boolean)false))));
    @Generated
    public static final Property userAlarmRecipient = BOnCallContact.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"wbutil:OrdSelectFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:OrdSelectEditor"), (String)"queryOrd", (BIDataValue)BString.make((String)"station:|slot:|bql:select icon.encodeToString, displayName, handleOrd from alarm:IUserAlarmRecipient stop")), (BFacets)BFacets.make((String)"enablePopOut", (BIDataValue)BBoolean.make((boolean)false))));
    @Generated
    public static final Type TYPE = Sys.loadType(BOnCallContact.class);
    private static final BIcon icon = BIcon.make((String)"module://onCall/res/onCallContact.png");
    private static final String NULL_TEXT = "null";
    private BUser currentUser = null;
    private String currentUserName = "null";
    private BIUserAlarmRecipient currentRec = null;
    static final Context ROTATE_CONTEXT = new BasicContext();

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    @Generated
    public void setLastFaultCause(String v) {
        this.setString(lastFaultCause, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public int getPriority() {
        return this.getInt(priority);
    }

    @Generated
    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    @Generated
    public int getRotationMarker() {
        return this.getInt(rotationMarker);
    }

    @Generated
    public void setRotationMarker(int v) {
        this.setInt(rotationMarker, v, null);
    }

    @Generated
    public BOrd getUser() {
        return (BOrd)this.get(user);
    }

    @Generated
    public void setUser(BOrd v) {
        this.set(user, (BValue)v, null);
    }

    @Generated
    public BOrd getUserAlarmRecipient() {
        return (BOrd)this.get(userAlarmRecipient);
    }

    @Generated
    public void setUserAlarmRecipient(BOrd v) {
        this.set(userAlarmRecipient, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOnCallContact() {
    }

    public BOnCallContact(int priority) {
        this.setPriority(priority);
    }

    public void started() throws Exception {
        BOnCallService.getInstance().addUserListener(this);
        this.updateName();
    }

    public void stopped() throws Exception {
        BOnCallService.getInstance().removeUserListener(this);
    }

    public void changed(Property prop, Context cx) {
        if (this.isRunning()) {
            if (prop == user || prop == userAlarmRecipient) {
                this.updateName();
            } else if (prop == priority && cx != ROTATE_CONTEXT) {
                this.updateRotationMarker(true);
                ((BOnCallList)this.getParent()).startReorderTimer();
            } else if (prop == enabled) {
                this.updateDisabledStatus();
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BOnCallList;
    }

    public BIcon getIcon() {
        return icon;
    }

    private void updateName() {
        this.currentUser = null;
        this.currentUserName = NULL_TEXT;
        boolean userOk = false;
        try {
            if (!this.getUser().isNull()) {
                this.currentUser = (BUser)this.getUser().get((BObject)this);
                this.currentUserName = this.currentUser.getName();
                userOk = true;
            } else {
                this.setStatus(BStatus.fault);
                this.setLastFaultCause("User is set to null");
                OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
            }
        }
        catch (UnresolvedException e) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Could not find User");
            OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
        }
        String recName = NULL_TEXT;
        this.currentRec = null;
        try {
            if (!this.getUserAlarmRecipient().isNull()) {
                this.currentRec = (BIUserAlarmRecipient)this.getUserAlarmRecipient().get((BObject)this);
                recName = ((BComponent)this.currentRec).getName();
                if (userOk) {
                    this.setStatus(BStatus.ok);
                }
            } else {
                this.setStatus(BStatus.fault);
                this.setLastFaultCause("Alarm Recipient is set to null");
                OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
            }
        }
        catch (UnresolvedException e) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Could not find Alarm Recipient");
            OnCallToolkit.log.error(this.getName() + ": " + this.getLastFaultCause());
        }
        String newName = SlotPath.escape((String)(this.currentUserName + "_" + recName));
        if (!newName.equals(this.getName())) {
            int count = 0;
            String temp = newName;
            while (true) {
                if (count > 0) {
                    temp = newName + String.valueOf(count);
                }
                if (this.getParent().getSlot(temp) == null) {
                    this.getParent().asComponent().rename(this.getPropertyInParent(), temp);
                    break;
                }
                ++count;
            }
        }
        this.getOnCallList().updateStatus();
    }

    String getCurrentUserName() {
        return this.currentUserName;
    }

    BUser getCurrentUser() {
        return this.currentUser;
    }

    BIUserAlarmRecipient getCurrentUserAlarmRecipient() {
        return this.currentRec;
    }

    private BOnCallList getOnCallList() {
        return (BOnCallList)this.getParent();
    }

    void updateDisabledStatus() {
        boolean userDisabled = false;
        if (this.currentUser != null && this.currentUser.isMounted()) {
            userDisabled = this.currentUser.getStatus().isDisabled();
        }
        this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (this.getOnCallList().getStatus().isDisabled() || !this.getEnabled() || userDisabled ? 1 : 0) != 0));
    }

    @Override
    public void userRemoved(String name) {
        if (this.currentUser == null) {
            return;
        }
        if (name.equals(this.currentUserName)) {
            this.updateName();
        }
    }

    @Override
    public void userEnabledChanged(String userName) {
        if (this.currentUser == null) {
            return;
        }
        if (!this.currentUser.isMounted()) {
            return;
        }
        if (userName.equals(this.currentUserName)) {
            this.updateDisabledStatus();
        }
    }

    void updateRotationMarker(boolean force) {
        if (this.getRotationMarker() == -1 || force) {
            BOnCallList list = this.getOnCallList();
            BOnCallContact[] contacts = (BOnCallContact[])list.getChildren(BOnCallContact.class);
            int r = 0;
            for (int i = 0; i < contacts.length; ++i) {
                if (contacts[i] == this || contacts[i].getPriority() != this.getPriority() || contacts[i].getRotationMarker() <= r) continue;
                r = contacts[i].getRotationMarker();
            }
            if (r <= -1) {
                r = 0;
            }
            this.setRotationMarker(++r);
        }
    }
}

