/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.alarm.user.BIUserAlarmRecipient;
import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.oncall.BOnCallContact;
import com.tridium.oncall.BOnCallRecipient;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import java.util.HashSet;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.AuditEvent;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="active", type="boolean", defaultValue="false", flags=67, facets={@Facet(value="BFacets.make(BFacets.TRUE_TEXT, BString.make(\"%lexicon(onCall:active)%\"), BFacets.FALSE_TEXT, BString.make(\"%lexicon(onCall:inactive)%\"))")}), @NiagaraProperty(name="lastFaultCause", type="String", defaultValue="", flags=67), @NiagaraProperty(name="ordinal", type="int", defaultValue="-1", flags=65)})
@NiagaraActions(value={@NiagaraAction(name="reorderContacts", flags=20), @NiagaraAction(name="rotate", flags=24)})
public final class BOnCallList
extends BComponent
implements BIStatus {
    @Generated
    public static final Property status = BOnCallList.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property active = BOnCallList.newProperty((int)67, (boolean)false, (BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(onCall:active)%"), (String)"falseText", (BIDataValue)BString.make((String)"%lexicon(onCall:inactive)%")));
    @Generated
    public static final Property lastFaultCause = BOnCallList.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property ordinal = BOnCallList.newProperty((int)65, (int)-1, null);
    @Generated
    public static final Action reorderContacts = BOnCallList.newAction((int)20, null);
    @Generated
    public static final Action rotate = BOnCallList.newAction((int)24, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOnCallList.class);
    private static final BIcon icon = BIcon.make((String)"module://onCall/res/onCallList.png");
    static final String ON_CALL_RECIPIENT = "OnCallRecipient";
    static final String ON_CALL_CONTACT = "OnCallContact";
    static final String ON_CALL_USER = "OnCallUser";
    static final String ON_CALL_START_TIME = "OnCallStartTime";
    static final String ON_CALL_LIST = "OnCallList";
    static final String ON_CALL_PRIORITY = "OnCallListPriority";
    private static final Context reorderContext = new BasicContext();
    private Object reorderMon = new Object();
    private Clock.Ticket reorderTicket = null;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getActive() {
        return this.getBoolean(active);
    }

    @Generated
    public void setActive(boolean v) {
        this.setBoolean(active, v, null);
    }

    @Generated
    public String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    @Generated
    public void setLastFaultCause(String v) {
        this.setString(lastFaultCause, v, null);
    }

    @Generated
    public int getOrdinal() {
        return this.getInt(ordinal);
    }

    @Generated
    public void setOrdinal(int v) {
        this.setInt(ordinal, v, null);
    }

    @Generated
    public void reorderContacts() {
        this.invoke(reorderContacts, null, null);
    }

    @Generated
    public void rotate() {
        this.invoke(rotate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BOnCallService service = BOnCallService.getInstance();
        if (service == null) {
            throw new Exception("Could not find OnCallService");
        }
        if (this.getOrdinal() == -1) {
            this.setOrdinal(BOnCallService.getInstance().getNewOrdinalNumber());
        }
        this.updateStatus();
        BOnCallService.getInstance().callListUpdateFacetsOnAllSchedules(service.getCallListEnumRangeFacets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        Object object = this.reorderMon;
        synchronized (object) {
            if (this.reorderTicket != null) {
                this.reorderTicket.cancel();
                this.reorderTicket = null;
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BOnCallService;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void added(Property property, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallContact.TYPE)) {
            this.updateStatus();
            ((BOnCallContact)this.get(property)).updateRotationMarker(false);
            this.startReorderTimer();
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallContact.TYPE)) {
            this.updateStatus();
            this.startReorderTimer();
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        if (this.isRunning() && property.getType().is(BOnCallContact.TYPE)) {
            this.startReorderTimer();
        }
    }

    public void reordered(Context cx) {
        if (this.isRunning() && cx != reorderContext) {
            this.reorderContacts();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == reorderContacts || action == rotate) {
            return BOnCallService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public BStatusEnum getOrdinalStatusEnum() {
        return new BStatusEnum((BEnum)BDynamicEnum.make((int)this.getOrdinal()));
    }

    void routeAlarm(BAlarmRecord record, BOnCallRecipient recipient) {
        this.doRouteAlarm(record, this.findNextContacts(-1), recipient);
    }

    private void doRouteAlarm(BAlarmRecord record, BOnCallContact[] contacts, BOnCallRecipient recipient) {
        if (BOnCallService.getInstance().isFatalFault()) {
            return;
        }
        if (!this.getActive()) {
            return;
        }
        if (contacts.length <= 0) {
            return;
        }
        StringBuilder contactBuff = new StringBuilder();
        try {
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
                int i;
                record = conn.getRecord(record.getUuid());
                if (record == null) {
                    return;
                }
                if (record.isAcknowledged()) {
                    return;
                }
                StringBuilder userBuff = new StringBuilder();
                for (i = 0; i < contacts.length; ++i) {
                    if (i > 0) {
                        userBuff.append(", ");
                    }
                    userBuff.append(contacts[i].getCurrentUserName());
                }
                for (i = 0; i < contacts.length; ++i) {
                    if (i > 0) {
                        contactBuff.append(", ");
                    }
                    contactBuff.append(contacts[i].getName());
                }
                String[] keys = new String[]{ON_CALL_RECIPIENT, ON_CALL_LIST, ON_CALL_START_TIME, ON_CALL_USER, ON_CALL_CONTACT, ON_CALL_PRIORITY};
                BIDataValue[] values = new BIDataValue[]{BString.make((String)recipient.getName()), BString.make((String)this.getName()), BAbsTime.now(), BString.make((String)userBuff.toString()), BString.make((String)contactBuff.toString()), BInteger.make((int)contacts[0].getPriority())};
                BFacets newFacets = BFacets.make((String[])keys, (BIDataValue[])values);
                record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (BFacets)newFacets));
                record.setLastUpdate(BAbsTime.now());
                conn.update(record);
                if (OnCallToolkit.log.isTraceOn()) {
                    StringBuilder buff = new StringBuilder();
                    buff.append("Route alarm: ");
                    buff.append(record.getUuid().encodeToString());
                    buff.append(" ");
                    buff.append(newFacets.toDebugString());
                    OnCallToolkit.log.trace(buff.toString());
                }
            }
            if (BOnCallService.getInstance().getAuditAlarmEscalation()) {
                BAuditHistoryService auditSrv = (BAuditHistoryService)Sys.getService((Type)BAuditHistoryService.TYPE);
                auditSrv.audit(new AuditEvent("Escalated", record.getUuid().encodeToString(), record.getSource().toString(), "", String.valueOf(contacts[0].getPriority()), contactBuff.toString()));
            }
        }
        catch (Exception e) {
            OnCallToolkit.log.error("Routing new alarm", (Throwable)e);
            return;
        }
        BConsoleRecipient[] consoleRecipients = recipient.getLinkedConsoleRecipients();
        for (int j = 0; j < consoleRecipients.length; ++j) {
            consoleRecipients[j].routeAlarm(record);
        }
        BStationRecipient[] stationRecipients = recipient.getLinkedStationRecipients();
        for (int j = 0; j < stationRecipients.length; ++j) {
            stationRecipients[j].routeAlarm(record);
        }
        for (int i = 0; i < contacts.length; ++i) {
            BIUserAlarmRecipient rec = contacts[i].getCurrentUserAlarmRecipient();
            BUser currentUser = contacts[i].getCurrentUser();
            if (rec != null && currentUser != null && currentUser.isMounted()) {
                if (currentUser.getEmail() == null || currentUser.getEmail().equals("")) {
                    OnCallToolkit.log.warning("OnCall user <" + currentUser.getName() + "> does not have an email address configured");
                }
                rec.handleAlarmForUser(currentUser, record);
                continue;
            }
            OnCallToolkit.log.error("Routing alarm to On Call Contact with no valid Alarm Recipient: " + contacts[i].getName());
        }
    }

    void checkEscalation(BOnCallRecipient recipient) {
        if (BOnCallService.getInstance().isFatalFault()) {
            return;
        }
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Checking escalation");
        }
        String alarmPredicate = recipient.buildAlarmClassPredicate();
        String alarmQuery = alarmPredicate + " and not isAcknowledged";
        BITable coll = (BITable)BOrd.make((String)alarmQuery).get((BObject)this);
        TableCursor c = coll.cursor();
        Array recArray = new Array(BAlarmRecord.class);
        while (c.next()) {
            recArray.add((Object)((BAlarmRecord)((BObject)c.get()).asValue().newCopy()));
        }
        BAlarmRecord[] recs = (BAlarmRecord[])recArray.trim();
        for (int i = 0; i < recs.length; ++i) {
            BAbsTime endTime;
            if (!recipient.accept(recs[i])) continue;
            if (!recs[i].getAlarmData().gets(ON_CALL_LIST, "").equals(this.getName())) {
                if (OnCallToolkit.log.isTraceOn()) {
                    try {
                        OnCallToolkit.log.trace("Rerouting alarm: " + recs[i].getUuid().encodeToString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.routeAlarm(recs[i], recipient);
                continue;
            }
            BAbsTime startTime = (BAbsTime)recs[i].getAlarmData().get(ON_CALL_START_TIME);
            if (startTime != null && ((endTime = startTime.add(recipient.getEscalationDelay())).equals((Object)BAbsTime.now()) || endTime.isAfter(BAbsTime.now()))) continue;
            int onCallPriority = recs[i].getAlarmData().geti(ON_CALL_PRIORITY, -1);
            BOnCallContact[] nextContacts = this.findNextContacts(onCallPriority);
            if (OnCallToolkit.log.isTraceOn()) {
                try {
                    OnCallToolkit.log.trace("Escalating alarm : " + recs[i].getUuid().encodeToString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.doRouteAlarm(recs[i], nextContacts, recipient);
        }
    }

    private BOnCallContact[] findNextContacts(int currentPriority) {
        BOnCallContact[] contacts = (BOnCallContact[])this.getChildren(BOnCallContact.class);
        Array foundContacts = new Array(BOnCallContact.class);
        int higherPriority = -1;
        for (int i = 0; i < contacts.length; ++i) {
            if (!contacts[i].getStatus().isOk()) continue;
            if (higherPriority > -1) {
                if (contacts[i].getPriority() == higherPriority) {
                    foundContacts.add((Object)contacts[i]);
                    continue;
                }
                if (contacts[i].getPriority() <= higherPriority) continue;
                break;
            }
            if (contacts[i].getPriority() <= currentPriority) continue;
            higherPriority = contacts[i].getPriority();
            foundContacts.add((Object)contacts[i]);
        }
        return (BOnCallContact[])foundContacts.trim();
    }

    public void doReorderContacts() {
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Reordering Contacts");
        }
        BOnCallContact[] contacts = this.sort((BOnCallContact[])this.getChildren(BOnCallContact.class));
        Property[] dynamicProps = this.getDynamicPropertiesArray();
        Property[] reorderedProps = new Property[dynamicProps.length];
        int contactNum = 0;
        for (int i = 0; i < dynamicProps.length; ++i) {
            if (dynamicProps[i].getType().equals(BOnCallContact.TYPE)) {
                reorderedProps[i] = contacts[contactNum].getPropertyInParent();
                ++contactNum;
                continue;
            }
            reorderedProps[i] = dynamicProps[i];
        }
        this.reorder(reorderedProps, reorderContext);
        BOnCallService.getInstance().callListMatchClearAndEscalate(BString.make((String)this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startReorderTimer() {
        Object object = this.reorderMon;
        synchronized (object) {
            if (this.reorderTicket != null) {
                this.reorderTicket.cancel();
            }
            this.reorderTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)1000L), (Action)reorderContacts, null);
        }
    }

    private BOnCallContact[] sort(BOnCallContact[] contacts) {
        if (contacts.length == 0) {
            return contacts;
        }
        Object[] pComps = PriorityComparable.makeArray(contacts);
        SortUtil.sort((Object[])pComps);
        Array psArray = new Array(Integer.class);
        int lastP = -1;
        for (int i = 0; i < pComps.length; ++i) {
            if (lastP != -1) {
                if (((PriorityComparable)pComps[i]).c.getPriority() != lastP) {
                    psArray.add((Object)((PriorityComparable)pComps[i]).c.getPriority());
                }
            } else {
                psArray.add((Object)((PriorityComparable)pComps[i]).c.getPriority());
            }
            lastP = ((PriorityComparable)pComps[i]).c.getPriority();
        }
        Integer[] ps = (Integer[])psArray.trim();
        Array contactArray = new Array(BOnCallContact.class);
        for (int i = 0; i < pComps.length; ++i) {
            contactArray.add((Object)((PriorityComparable)pComps[i]).c);
        }
        Array newContactArray = new Array(BOnCallContact.class);
        for (int i = 0; i < ps.length; ++i) {
            final int currentPriority = ps[i];
            Array filteredContactArray = contactArray.filter(new IFilter(){

                public boolean accept(Object obj) {
                    BOnCallContact c = (BOnCallContact)obj;
                    return c.getPriority() == currentPriority;
                }
            });
            Object[] rotComps = RotationMarkerComparable.makeArray((BOnCallContact[])filteredContactArray.trim());
            SortUtil.sort((Object[])rotComps);
            for (int j = 0; j < rotComps.length; ++j) {
                newContactArray.add((Object)((RotationMarkerComparable)rotComps[j]).c);
            }
        }
        return (BOnCallContact[])newContactArray.trim();
    }

    void updateStatus() {
        BOnCallContact[] contacts = (BOnCallContact[])this.getChildren(BOnCallContact.class);
        boolean fault = false;
        for (int i = 0; i < contacts.length; ++i) {
            if (!fault && contacts[i].getStatus().isFault()) {
                fault = true;
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setLastFaultCause(contacts[i].getName() + ": " + contacts[i].getLastFaultCause());
            }
            contacts[i].updateDisabledStatus();
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)fault));
    }

    public void doRotate() throws Exception {
        if (this.isRunning()) {
            BOnCallContact[] contacts = (BOnCallContact[])this.getChildren(BOnCallContact.class);
            if (contacts.length == 0) {
                return;
            }
            int p = contacts[0].getPriority();
            int r = contacts[0].getRotationMarker();
            for (int i = contacts.length - 1; i >= 0; --i) {
                int tP = p;
                int tR = r;
                p = contacts[i].getPriority();
                r = contacts[i].getRotationMarker();
                contacts[i].setRotationMarker(tR);
                contacts[i].setInt(BOnCallContact.priority, tP, BOnCallContact.ROTATE_CONTEXT);
            }
            this.reorderContacts();
        }
    }

    public String getPriorityList(BOrd userOrd) {
        BOnCallContact[] contacts = (BOnCallContact[])this.getChildren(BOnCallContact.class);
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < contacts.length; ++i) {
            if (!contacts[i].getUser().equals((Object)userOrd) || contacts[i].getStatus().isDisabled()) continue;
            set.add(contacts[i].getPriority());
        }
        StringBuilder buff = new StringBuilder();
        Object[] objs = set.toArray();
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(objs[i].toString());
        }
        return buff.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            StringBuilder buff = new StringBuilder();
            buff.append("alarm:|bql:select from openAlarms where not isAcknowledged and alarmData.");
            buff.append(ON_CALL_LIST);
            buff.append(" = '");
            buff.append(this.getName());
            buff.append("'");
            BITable coll = (BITable)BOrd.make((String)buff.toString()).get((BObject)this);
            out.startTable(true);
            out.w((Object)"<tr>").th((Object)"On Call Recipient").th((Object)"On Call Contact").th((Object)"On Call Priority").th((Object)"Start Time").th((Object)"End Time").th((Object)"Remaining").th((Object)"Source").th((Object)"State").th((Object)"Uuid").w((Object)"</tr>\n");
            try (TableCursor c = coll.cursor();){
                while (c.next()) {
                    BOnCallRecipient r;
                    BAlarmRecord record = (BAlarmRecord)c.get();
                    String recipientName = record.getAlarmData().gets(ON_CALL_RECIPIENT, "");
                    if (recipientName.length() <= 0) continue;
                    BITable collRec = (BITable)BOrd.make((String)("service:alarm:AlarmService|bql:select from onCall:OnCallRecipient where name = '" + recipientName + "'")).get((BObject)this);
                    TableCursor cur = collRec.cursor();
                    Throwable throwable = null;
                    try {
                        if (!cur.next()) continue;
                        r = (BOnCallRecipient)((Object)cur.get());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cur == null) continue;
                        if (throwable != null) {
                            try {
                                cur.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        cur.close();
                        continue;
                    }
                    BAbsTime startTime = (BAbsTime)record.getAlarmData().get(ON_CALL_START_TIME);
                    BAbsTime endTime = null;
                    if (startTime != null) {
                        endTime = startTime.add(r.getEscalationDelay());
                    }
                    if (endTime != null && (endTime.equals((Object)BAbsTime.now()) || endTime.isAfter(BAbsTime.now()))) {
                        BRelTime remaining = BAbsTime.now().delta(endTime);
                        out.w((Object)"<tr>");
                        out.td((Object)record.getAlarmData().gets(ON_CALL_RECIPIENT, ""));
                        out.td((Object)record.getAlarmData().gets(ON_CALL_CONTACT, ""));
                        out.td((Object)String.valueOf(record.getAlarmData().geti(ON_CALL_PRIORITY, -1)));
                        out.td((Object)startTime.toTimeString(null));
                        out.td((Object)endTime.toTimeString(null));
                        out.td((Object)remaining);
                        out.td((Object)record.getSource());
                        out.td((Object)record.getSourceState());
                        out.td((Object)record.getUuid());
                        out.w((Object)"</tr>\n");
                        continue;
                    }
                    out.w((Object)"<tr>");
                    out.td((Object)record.getAlarmData().gets(ON_CALL_RECIPIENT, ""));
                    out.td((Object)record.getAlarmData().gets(ON_CALL_CONTACT, ""));
                    out.td((Object)String.valueOf(record.getAlarmData().geti(ON_CALL_PRIORITY, -1)));
                    out.td((Object)"Expired");
                    out.td((Object)"Expired");
                    out.td((Object)"Expired");
                    out.td((Object)record.getSource());
                    out.td((Object)record.getSourceState());
                    out.td((Object)record.getUuid());
                    out.w((Object)"</tr>\n");
                }
            }
            out.endTable();
            out.w((Object)"<br />");
        }
        super.spy(out);
    }

    private static class PriorityComparable
    implements Comparable<Object> {
        private BOnCallContact c;

        private PriorityComparable(BOnCallContact c) {
            this.c = c;
        }

        private static PriorityComparable[] makeArray(BOnCallContact[] contacts) {
            PriorityComparable[] cs = new PriorityComparable[contacts.length];
            for (int i = 0; i < cs.length; ++i) {
                cs[i] = new PriorityComparable(contacts[i]);
            }
            return cs;
        }

        @Override
        public int compareTo(Object arg0) {
            if (arg0 == null) {
                return 1;
            }
            if (arg0 instanceof PriorityComparable) {
                BOnCallContact contact = ((PriorityComparable)arg0).c;
                if (contact.getPriority() == this.c.getPriority()) {
                    return 0;
                }
                if (contact.getPriority() < this.c.getPriority()) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }
    }

    private static class RotationMarkerComparable
    implements Comparable<Object> {
        private BOnCallContact c;

        private RotationMarkerComparable(BOnCallContact c) {
            this.c = c;
        }

        private static RotationMarkerComparable[] makeArray(BOnCallContact[] contacts) {
            RotationMarkerComparable[] cs = new RotationMarkerComparable[contacts.length];
            for (int i = 0; i < cs.length; ++i) {
                cs[i] = new RotationMarkerComparable(contacts[i]);
            }
            return cs;
        }

        @Override
        public int compareTo(Object arg0) {
            if (arg0 == null) {
                return 1;
            }
            if (arg0 instanceof RotationMarkerComparable) {
                BOnCallContact contact = ((RotationMarkerComparable)arg0).c;
                if (contact.getRotationMarker() == this.c.getRotationMarker()) {
                    return 0;
                }
                if (contact.getRotationMarker() < this.c.getRotationMarker()) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }
    }
}

