/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleView;
import com.tridium.schedule.ui.BCalendarWidget;
import com.tridium.schedule.ui.BCompositeEd;
import com.tridium.schedule.ui.BDateRangeEd;
import com.tridium.schedule.ui.BDayEd;
import com.tridium.schedule.ui.BStatusValueEd;
import com.tridium.schedule.ui.BSummary;
import com.tridium.schedule.ui.Utils;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"schedule:WeeklySchedule"}, requiredPermissions="r")})
@NiagaraActions(value={@NiagaraAction(name="scheduleModified"), @NiagaraAction(name="cleanupModified"), @NiagaraAction(name="effectivePeriodModified"), @NiagaraAction(name="facetsModified"), @NiagaraAction(name="outModified"), @NiagaraAction(name="tabSelectionModified")})
public class BScheduler
extends BAbstractScheduleView {
    @Generated
    public static final Action scheduleModified = BScheduler.newAction((int)0, null);
    @Generated
    public static final Action cleanupModified = BScheduler.newAction((int)0, null);
    @Generated
    public static final Action effectivePeriodModified = BScheduler.newAction((int)0, null);
    @Generated
    public static final Action facetsModified = BScheduler.newAction((int)0, null);
    @Generated
    public static final Action outModified = BScheduler.newAction((int)0, null);
    @Generated
    public static final Action tabSelectionModified = BScheduler.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduler.class);
    BCalendarWidget calendar;
    BDateRangeEd dateRange;
    BDayEd dayEd;
    BStatusValueEd defOut;
    BCompositeEd specialEvents;
    BSummary summary;
    BWeeklySchedule weekSched;
    BWbFieldEditor wbFacets;
    BWbFieldEditor wbCleanup;
    BTabbedPane tp = new BTabbedPane();
    private static String tabName = "";

    @Generated
    public void scheduleModified() {
        this.invoke(scheduleModified, null, null);
    }

    @Generated
    public void cleanupModified() {
        this.invoke(cleanupModified, null, null);
    }

    @Generated
    public void effectivePeriodModified() {
        this.invoke(effectivePeriodModified, null, null);
    }

    @Generated
    public void facetsModified() {
        this.invoke(facetsModified, null, null);
    }

    @Generated
    public void outModified() {
        this.invoke(outModified, null, null);
    }

    @Generated
    public void tabSelectionModified() {
        this.invoke(tabSelectionModified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BScheduler() {
        this.tp.setTabPlacement(BAlign.bottom);
        this.dayEd = new BDayEd(false);
        this.tp.addPane(new BLabel(Utils.imgSchedule, this.lex("scheduler.weeklySchedule")), (BWidget)new BBorderPane((BWidget)this.dayEd, 10.0, 10.0, 10.0, 10.0));
        this.specialEvents = new BCompositeEd(true);
        this.tp.addPane(new BLabel(Utils.imgCalendar, this.lex("scheduler.specialEvents")), (BWidget)new BBorderPane((BWidget)this.specialEvents, 10.0, 10.0, 10.0, 10.0));
        this.defOut = new BStatusValueEd();
        this.wbFacets = BWbFieldEditor.makeFor((BObject)BFacets.NULL);
        this.wbCleanup = BWbFieldEditor.makeFor((BObject)BBoolean.DEFAULT);
        BGridPane gp = new BGridPane(2);
        gp.setHalign(BHalign.left);
        gp.setValign(BValign.top);
        gp.add(null, (BValue)new BLabel(this.lex("scheduler.defaultOutput")));
        gp.add(null, (BValue)this.defOut);
        gp.add(null, (BValue)new BLabel(this.lex("scheduler.facets")));
        gp.add(null, (BValue)this.wbFacets);
        gp.add(null, (BValue)new BLabel(this.lex("scheduler.cleanupSpecialEvents")));
        gp.add(null, (BValue)this.wbCleanup);
        BEdgePane epContent = new BEdgePane();
        BBorderPane bep = new BBorderPane((BWidget)epContent);
        bep.setLabel((BWidget)new BLabel(this.lex("scheduler.effectivePeriod")));
        bep.setBorder(BBorder.groove);
        this.calendar = new BCalendarWidget(false);
        epContent.setTop((BWidget)this.calendar);
        this.dateRange = new BDateRangeEd(true);
        epContent.setCenter((BWidget)this.dateRange);
        BEdgePane misc = new BEdgePane();
        misc.setTop((BWidget)new BBorderPane((BWidget)bep, 0.0, 0.0, 10.0, 0.0));
        misc.setCenter((BWidget)gp);
        this.tp.addPane(new BLabel(Utils.imgProps, this.lex("scheduler.properties")), (BWidget)new BBorderPane((BWidget)misc, 10.0, 10.0, 10.0, 10.0));
        this.summary = new BSummary();
        this.tp.addPane(new BLabel(Utils.imgClock, this.lex("summary")), (BWidget)new BBorderPane((BWidget)this.summary, 10.0, 10.0, 10.0, 10.0));
        BEdgePane ep = new BEdgePane();
        ep.setCenter((BWidget)new BBorderPane((BWidget)this.tp, 0.0, 0.0, 10.0, 0.0));
        gp = new BGridPane(2);
        gp.setRowAlign(BValign.fill);
        gp.setColumnAlign(BHalign.fill);
        gp.setUniformColumnWidth(true);
        gp.setUniformRowHeight(true);
        gp.add(null, (BValue)this.makeSaveBtn());
        gp.add(null, (BValue)this.makeRefreshBtn());
        ep.setBottom((BWidget)gp);
        this.linkTo((BComponent)this.dayEd, (Slot)BDayEd.modified, (Slot)scheduleModified);
        this.linkTo((BComponent)this.specialEvents, (Slot)BCompositeEd.modified, (Slot)scheduleModified);
        this.linkTo((BComponent)this.defOut, (Slot)BStatusValueEd.modified, (Slot)outModified);
        this.linkTo((BComponent)this.wbFacets, (Slot)BWbFieldEditor.pluginModified, (Slot)facetsModified);
        this.linkTo((BComponent)this.wbCleanup, (Slot)BWbFieldEditor.pluginModified, (Slot)cleanupModified);
        this.linkTo((BComponent)this.dateRange, (Slot)BDateRangeEd.modified, (Slot)effectivePeriodModified);
        this.linkTo((BComponent)this.tp, (Slot)BTabbedPane.selectionModified, (Slot)tabSelectionModified);
        this.setContent((BWidget)ep);
        BLabelPane selectedPane = (BLabelPane)this.tp.get(tabName);
        if (selectedPane != null) {
            this.tp.selectLabelPane(selectedPane);
        }
    }

    public void doCleanupModified() {
        try {
            this.weekSched.set(BControlSchedule.cleanupExpiredEvents, (BValue)this.wbCleanup.saveValue());
            this.scheduleModified();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void doEffectivePeriodModified() {
        this.calendar.setSchedule((BAbstractSchedule)this.weekSched.getEffective());
        this.scheduleModified();
    }

    public void doFacetsModified() {
        try {
            BFacets f = (BFacets)this.wbFacets.saveValue();
            this.weekSched.setFacets(f);
            this.defOut.load(this.weekSched.getDefaultOutput(), this.weekSched.getFacets());
            this.scheduleModified();
            BWidget w = this.getContent();
            this.setContent((BWidget)new BLabel());
            this.setContent(w);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void doOutModified() {
        this.scheduleModified();
    }

    public void doScheduleModified() {
        this.summary.scheduleModified();
        this.setModified();
    }

    public void doTabSelectionModified() {
        if (this.tp != null && this.tp.getSelectedLabelPane() != null) {
            tabName = this.tp.getSelectedLabelPane().getName();
        }
    }

    private boolean getSpecialEventsWritable(Context cx) {
        return !this.readonly() || ((BWeeklySchedule)this.getCurrentValue()).getSpecialEvents().getPermissions(cx).hasOperatorWrite();
    }

    @Override
    public void doEnableSave() {
        if ((!this.readonly() || this.getSpecialEventsWritable(this.context)) && this.btnSave != null) {
            this.btnSave.setEnabled(true);
        }
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        super.doLoadValue(value, cx);
        if (this.readonly()) {
            ((BComponent)this.getCurrentValue()).lease(2);
        }
        this.weekSched = (BWeeklySchedule)this.schedule;
        boolean ro = this.readonly();
        this.dayEd.setWeekSchedule(this.schedule, this.weekSched.getWeek());
        this.dayEd.setReadonly(ro);
        this.specialEvents.absSched = this.schedule;
        this.specialEvents.schedule = this.weekSched.getSpecialEvents();
        this.specialEvents.setReadonly(!this.getSpecialEventsWritable(cx));
        this.specialEvents.selected();
        this.defOut.load(this.weekSched.getDefaultOutput(), this.weekSched.getFacets());
        this.wbFacets.loadValue((BObject)this.weekSched.getFacets());
        this.wbCleanup.loadValue((BObject)this.weekSched.get(BWeeklySchedule.cleanupExpiredEvents));
        this.calendar.schedule = this.weekSched.getEffective();
        this.dateRange.load(this.weekSched.getEffective());
        this.defOut.setReadonly(ro);
        this.wbFacets.setReadonly(ro);
        this.wbCleanup.setReadonly(ro);
        this.dateRange.setReadonly(ro);
        this.summary.setSchedule(this.weekSched);
        this.summary.setContext(cx);
        this.summary.scheduleModified();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        if (!this.readonly()) {
            return super.doSaveValue(value, cx);
        }
        ((BComponent)this.getCurrentValue()).lease(2);
        if (this.getSpecialEventsWritable(cx)) {
            if (this.btnSave != null) {
                this.btnSave.setEnabled(false);
            }
            BAbstractSchedule sch = (BAbstractSchedule)value;
            sch.lease(10);
            BWeeklySchedule weekly = (BWeeklySchedule)sch;
            BCompositeSchedule oldSpecialEvents = weekly.getSpecialEvents();
            BCompositeSchedule newSpecialEvents = this.specialEvents.schedule;
            if (oldSpecialEvents.equivalent((Object)newSpecialEvents) && this.sameDynamicPropOrder(oldSpecialEvents, newSpecialEvents)) {
                return sch;
            }
            oldSpecialEvents.copyFrom((BAbstractSchedule)newSpecialEvents, cx);
            return sch;
        }
        return value;
    }

    private boolean sameDynamicPropOrder(BCompositeSchedule a, BCompositeSchedule b) {
        Property[] dynamicA = a.getDynamicPropertiesArray();
        Property[] dynamicB = b.getDynamicPropertiesArray();
        for (int i = 0; i < dynamicA.length; ++i) {
            if (dynamicA[i].getName().equals(dynamicB[i].getName())) continue;
            return false;
        }
        return true;
    }
}

