/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.Utils;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import java.util.Vector;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

@NiagaraType
public class BSelectomatic
extends BAbstractScheduleWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BSelectomatic.class);
    private static final int SELECT = 0;
    private static final int DESELECT = 1;
    private static final int NONE = 2;
    BBrush clrTxt = Utils.clrFg;
    int cols;
    private double[] colsX;
    boolean disabledText = false;
    private Vector<Element> elements = new Vector();
    int hCellInset = 2;
    int vCellInset = 2;
    private Element last;
    private int mouseState = 2;
    int rows;
    private double[] rowsY;
    boolean singleSelection = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSelectomatic(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
    }

    public void add(Object element, int col, int colspan, int row, int rowspan, boolean selected) {
        Element e = new Element();
        e.element = element;
        e.selected = selected;
        e.col = col;
        e.colspan = colspan;
        e.row = row;
        e.rowspan = rowspan;
        this.elements.addElement(e);
    }

    public void add(Object element, int col, int colspan, int row, int rowspan, boolean selected, boolean selectable) {
        Element e = new Element();
        e.element = element;
        e.selected = selected;
        e.selectable = selectable;
        e.col = col;
        e.colspan = colspan;
        e.row = row;
        e.rowspan = rowspan;
        this.elements.addElement(e);
    }

    public boolean add(Object element, boolean selected) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.elementAt(c, r) != null) continue;
                this.add(element, c, 1, r, 1, selected);
                return true;
            }
        }
        return false;
    }

    public boolean add(Object element, boolean selected, boolean selectable) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                if (this.elementAt(c, r) != null) continue;
                this.add(element, c, 1, r, 1, selected, selectable);
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.elements.removeAllElements();
    }

    @Override
    public void computePreferredSize() {
        BFont f = Theme.widget().getTextFont();
        double maxW = 0.0;
        int i = this.elements.size();
        Element e = null;
        while (--i >= 0) {
            e = this.elements.elementAt(i);
            e.width = (int)f.width(e.element.toString());
            maxW = Math.max(e.width / (double)e.colspan, maxW);
        }
        this.setPreferredSize((double)this.cols * (maxW + (double)(2 * this.hCellInset)), this.rows * ((int)f.getHeight() + 2 * this.vCellInset));
    }

    public void deselect(Object obj) {
        Element e = this.elementOf(obj);
        if (e != null) {
            e.selected = false;
        }
    }

    public void deselectAll() {
        int i = this.elements.size();
        Element e = null;
        while (--i >= 0) {
            e = this.elements.elementAt(i);
            e.selected = false;
        }
        this.fireModified(null);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        int i;
        int i2;
        this.computePreferredSize();
        double tw = this.getWidth();
        double th = this.getHeight();
        double w = tw / (double)this.cols;
        double h = th / (double)this.rows;
        double[] widths = new double[this.cols];
        double[] heights = new double[this.rows];
        for (i2 = 0; i2 < this.cols; ++i2) {
            widths[i2] = w;
        }
        for (i2 = 0; i2 < this.rows; ++i2) {
            heights[i2] = h;
        }
        int tmp = (int)tw % this.cols;
        w += 1.0;
        for (i = 0; i < tmp; ++i) {
            widths[i] = w;
        }
        tmp = (int)th % this.rows;
        h += 1.0;
        for (i = 0; i < tmp; ++i) {
            heights[i] = h;
        }
        this.colsX = new double[this.cols];
        this.colsX[0] = 0.0;
        tmp = 0;
        for (i = 1; i < this.cols; ++i) {
            this.colsX[i] = widths[tmp] + this.colsX[tmp];
            ++tmp;
        }
        this.rowsY = new double[this.rows];
        this.rowsY[0] = 0.0;
        tmp = 0;
        for (i = 1; i < this.rows; ++i) {
            this.rowsY[i] = heights[tmp] + this.rowsY[tmp];
            ++tmp;
        }
    }

    public Object[] elements() {
        int len = this.elements.size();
        Object[] retern = new Object[len];
        for (int i = 0; i < len; ++i) {
            retern[i] = this.elements.elementAt((int)i).element;
        }
        return retern;
    }

    public boolean isSelected(Object obj) {
        Element e = this.elementOf(obj);
        if (e == null) {
            return false;
        }
        return e.selected;
    }

    public void mouseDragged(BMouseEvent e) {
        if (this.mouseState == 2) {
            return;
        }
        Element el = this.elementAt(this.xToCol(e.getX()), this.yToRow(e.getY()));
        if (el == this.last) {
            return;
        }
        if (el != null && el.selectable) {
            if (this.mouseState == 0) {
                if (this.singleSelection) {
                    this.deselectAll();
                }
                if (!el.selected) {
                    this.toggleElement(el, e);
                }
            } else if (el.selected) {
                this.toggleElement(el, e);
            }
            this.last = el;
            this.repaint();
        }
    }

    public void mousePressed(BMouseEvent e) {
        if (this.isReadonly() || !this.isEnabled()) {
            return;
        }
        Element el = this.elementAt(this.xToCol(e.getX()), this.yToRow(e.getY()));
        if (el != null && el.selectable) {
            if (el.selected) {
                this.mouseState = 1;
            } else {
                this.mouseState = 0;
                if (this.singleSelection) {
                    this.deselectAll();
                }
            }
            this.toggleElement(el, e);
            this.last = el;
            this.repaint();
        }
    }

    public void mouseReleased(BMouseEvent e) {
        this.mouseState = 2;
        this.last = null;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        double tw = this.getWidth();
        double th = this.getHeight();
        if (this.isReadonly() || !this.isEnabled()) {
            g.setBrush(Utils.clrRoBg);
        } else {
            g.setBrush(Utils.clrBg);
        }
        g.fillRect(0.0, 0.0, tw, th);
        WidgetTheme wt = Theme.widget();
        BFont textFont = wt.getTextFont();
        g.setFont(textFont);
        int len = this.elements.size();
        double fontAscent = textFont.getAscent();
        double fontHeight = textFont.getHeight();
        for (int i = 0; i < len; ++i) {
            Element e = this.elements.elementAt(i);
            double x = this.colsX[e.col];
            double y = this.rowsY[e.row];
            int tmp = e.col + e.colspan;
            double w = tmp >= this.cols ? tw - x : this.colsX[tmp] - x;
            tmp = e.row + e.rowspan;
            double h = tmp >= this.rows ? th - y : this.rowsY[tmp] - y;
            if (e.selected) {
                g.setBrush(Utils.clrSelBg);
                g.fillRect(x, y, w, h);
            }
            g.setBrush(Utils.clrFg);
            g.strokeRect(x, y, w, h);
            if (e.selected) {
                g.setBrush(Utils.clrSelFg);
            } else {
                g.setBrush(Utils.clrFg);
            }
            g.push();
            try {
                g.clip(x, y, w, h);
                x += (w - e.width) / 2.0;
                y += (h - fontHeight) / 2.0 + fontAscent;
                if (this.disabledText || this.isReadonly() || !this.isEnabled()) {
                    wt.paintDisabledText(g, (IStylable)this, e.element.toString(), x, y);
                    continue;
                }
                g.drawString(e.element.toString(), x, y);
                continue;
            }
            finally {
                g.pop();
            }
        }
        g.setBrush(Utils.clrFg);
        g.strokeRect(0.0, 0.0, tw, th);
    }

    public void select(Object obj) {
        Element e;
        if (this.singleSelection) {
            this.deselectAll();
        }
        if ((e = this.elementOf(obj)) != null) {
            e.selected = true;
        }
        this.fireModified(null);
    }

    public Object selectionAt(int x, int y) {
        Element e = this.elementAt(this.xToCol(x), this.yToRow(y));
        if (e == null) {
            return null;
        }
        return e.element;
    }

    protected Element elementAt(int col, int row) {
        int i = this.elements.size();
        while (--i >= 0) {
            Element e = this.elements.elementAt(i);
            if (!e.spans(col, row)) continue;
            return e;
        }
        return null;
    }

    protected Element elementOf(Object o) {
        int i = this.elements.size();
        while (--i >= 0) {
            Element e = this.elements.elementAt(i);
            if (!e.element.equals(o)) continue;
            return e;
        }
        return null;
    }

    protected void toggleElement(Element e, BMouseEvent m) {
        if (e == null) {
            return;
        }
        e.selected = !e.selected;
        this.fireModified(null);
    }

    private int xToCol(double x) {
        for (int i = 1; i < this.cols; ++i) {
            if (!(x < this.colsX[i])) continue;
            return --i;
        }
        return this.cols - 1;
    }

    private int yToRow(double y) {
        for (int i = 1; i < this.rows; ++i) {
            if (!(y < this.rowsY[i])) continue;
            return --i;
        }
        return this.rows - 1;
    }

    class Element {
        Object element;
        boolean selected;
        boolean selectable = true;
        int col;
        int colspan;
        double height;
        int row;
        int rowspan;
        double width;
        double x;
        double y;

        Element() {
        }

        public boolean spans(int c, int r) {
            if (r >= 0 && (r < this.row || r >= this.row + this.rowspan)) {
                return false;
            }
            return c < 0 || c >= this.col && c < this.col + this.colspan;
        }
    }
}

