/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BCalendarWidget;
import com.tridium.schedule.ui.Utils;
import java.util.LinkedList;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;

@NiagaraType
@NiagaraAction(name="daySelected", parameterType="BAbsTime", defaultValue="BAbsTime.DEFAULT")
public class BSummary
extends BAbstractScheduleWidget {
    @Generated
    public static final Action daySelected = BSummary.newAction((int)0, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSummary.class);
    private BWeeklySchedule schedule;
    BCalendarWidget calendar;
    Model model;
    BAbsTime selected;

    @Generated
    public void daySelected(BAbsTime parameter) {
        this.invoke(daySelected, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSummary() {
        BSplitPane content = new BSplitPane();
        content.setOrientation(BOrientation.vertical);
        content.setDividerPosition(70.0);
        this.calendar = new BCalendarWidget(true);
        this.linkTo((BComponent)this.calendar, (Slot)BCalendarWidget.selected, (Slot)daySelected);
        BBorderPane bp = new BBorderPane((BWidget)this.calendar, BBorder.solid);
        bp = new BBorderPane((BWidget)bp, BBorder.inset, BInsets.DEFAULT);
        content.setWidget1((BWidget)bp);
        this.model = new Model();
        BTable table = new BTable((TableModel)this.model);
        bp = new BBorderPane((BWidget)table, BBorder.solid);
        bp = new BBorderPane((BWidget)bp, BBorder.inset, BInsets.DEFAULT);
        content.setWidget2((BWidget)bp);
        this.setContent((BWidget)content);
    }

    public void doDaySelected(BAbsTime t) {
        this.selected = t;
        this.model.updateFromSelectedDay(t);
    }

    public void scheduleModified() {
        if (this.selected != null) {
            this.doDaySelected(this.selected);
        }
        this.calendar.syncSchedule((BAbstractSchedule)this.schedule);
        this.repaint();
    }

    public void setContext(Context cx) {
        this.model.setContext(cx);
    }

    public void setSchedule(BWeeklySchedule schedule) {
        this.schedule = schedule;
        this.model.setSchedule(schedule);
    }

    static class Row {
        Object timestamp = "";
        Object value = "";
        String source = "";

        Row() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (this.value != null ? !this.value.equals(row.value) : row.value != null) {
                return false;
            }
            return this.source != null ? this.source.equals(row.source) : row.source == null;
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }
    }

    public static class Model
    extends TableModel {
        BWeeklySchedule schedule;
        LinkedList<Row> rows = new LinkedList();
        Context cx;

        public void updateFromSelectedDay(BAbsTime t) {
            this.refreshRows(t);
            this.updateTable();
            this.getTable().sizeColumnsToFit();
        }

        public void refreshRows(BAbsTime t) {
            this.rows.clear();
            BTimeZone z = null;
            if (this.cx != null) {
                z = (BTimeZone)this.cx.getFacets().get("TimeZone");
            }
            if (z == null) {
                z = BTimeZone.getLocal();
            }
            t = BAbsTime.make((int)t.getYear(), (BMonth)t.getMonth(), (int)t.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)z);
            t = BAbsTime.make((int)t.getYear(), (BMonth)t.getMonth(), (int)t.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)z);
            Row last = new Row();
            BAbsTime end = t.nextDay();
            while (t != null && t.isBefore(end)) {
                Row r = this.makeRow(t);
                if (!r.equals(last)) {
                    this.rows.add(r);
                }
                last = r;
                t = this.schedule.nextEvent(t);
            }
        }

        public LinkedList<Row> getRows() {
            return this.rows;
        }

        public void setContext(Context cx) {
            this.cx = cx;
        }

        public void setSchedule(BWeeklySchedule schedule) {
            this.schedule = schedule;
        }

        protected Row makeRow(BAbsTime t) {
            Row r = new Row();
            r.timestamp = t.toString(this.cx);
            r.value = this.schedule.getOutput(t).toString((Context)this.schedule.getFacets());
            BAbstractSchedule src = this.schedule.getOutputSource(t);
            r.source = this.schedule.getSummary(src, this.cx);
            return r;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return Utils.lex("summary.timestamp");
                }
                case 1: {
                    return Utils.lex("summary.output");
                }
                case 2: {
                    return Utils.lex("summary.source");
                }
            }
            return "";
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int r, int c) {
            Row row = this.rows.get(r);
            switch (c) {
                case 0: {
                    return row.timestamp;
                }
                case 1: {
                    return row.value;
                }
                case 2: {
                    return row.source;
                }
            }
            return "";
        }
    }
}

