/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.SimpleSortedSet;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BTimeWidget;
import com.tridium.schedule.ui.SelectionItem;
import com.tridium.schedule.ui.Utils;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addPressed"), @NiagaraAction(name="checkBoxModified"), @NiagaraAction(name="selectionModified"), @NiagaraAction(name="removePressed")})
public class BTriggerDayWidget
extends BAbstractScheduleWidget {
    @Generated
    public static final Action addPressed = BTriggerDayWidget.newAction((int)0, null);
    @Generated
    public static final Action checkBoxModified = BTriggerDayWidget.newAction((int)0, null);
    @Generated
    public static final Action selectionModified = BTriggerDayWidget.newAction((int)0, null);
    @Generated
    public static final Action removePressed = BTriggerDayWidget.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTriggerDayWidget.class);
    BButton butAdd;
    BButton butRem;
    BCheckBox checkBox;
    Context context;
    BList list;
    BWbFieldEditor rangeEnd;
    BWbFieldEditor rangeInterval;
    BDaySchedule schedule;
    SelectionSet set;
    BWbFieldEditor time;

    @Generated
    public void addPressed() {
        this.invoke(addPressed, null, null);
    }

    @Generated
    public void checkBoxModified() {
        this.invoke(checkBoxModified, null, null);
    }

    @Generated
    public void selectionModified() {
        this.invoke(selectionModified, null, null);
    }

    @Generated
    public void removePressed() {
        this.invoke(removePressed, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    BTriggerDayWidget() {
        BTime t = BTime.make((int)0, (int)0, (int)0);
        this.time = new BTimeWidget();
        this.time.loadValue((BObject)t);
        this.time.setReadonly(this.isReadonly());
        this.checkBox = new BCheckBox(this.lex("trigger.range"));
        this.checkBox.setEnabled(!this.isReadonly());
        this.linkTo((BComponent)this.checkBox, (Slot)BCheckBox.actionPerformed, (Slot)checkBoxModified);
        t = BTime.make((int)23, (int)59, (int)0);
        this.rangeEnd = new BTimeWidget();
        this.rangeEnd.loadValue((BObject)t);
        this.rangeEnd.setReadonly(true);
        this.rangeInterval = BWbFieldEditor.makeFor((BObject)BRelTime.HOUR);
        this.rangeInterval.loadValue((BObject)BRelTime.HOUR, (Context)BFacets.make((String)"showSeconds", (boolean)false));
        this.rangeInterval.setReadonly(true);
        this.butAdd = new BButton(this.lex("trigger.add"));
        this.butAdd.setEnabled(!this.isReadonly());
        this.linkTo((BComponent)this.butAdd, (Slot)BButton.actionPerformed, (Slot)addPressed);
        this.butRem = new BButton(this.lex("trigger.remove"));
        this.butRem.setEnabled(false);
        this.linkTo((BComponent)this.butRem, (Slot)BButton.actionPerformed, (Slot)removePressed);
        this.list = new BList();
        this.list.setEnabled(!this.isReadonly());
        this.linkTo((BComponent)this.list, (Slot)BList.selectionModified, (Slot)selectionModified);
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)this.list);
        BGridPane bottom = new BGridPane(1);
        bottom.setUniformColumnWidth(true);
        bottom.setColumnAlign(BHalign.fill);
        content.setBottom((BWidget)bottom);
        BGridPane gp = new BGridPane(1);
        gp.add(null, (BValue)this.time);
        gp.setColumnAlign(BHalign.left);
        gp.setHalign(BHalign.left);
        bottom.add(null, (BValue)new BBorderPane((BWidget)gp, 10.0, 0.0, 0.0, 0.0));
        bottom.add(null, (BValue)this.checkBox);
        gp = new BGridPane(2);
        gp.add(null, (BValue)new BLabel(this.lex("trigger.rangeEnd")));
        gp.add(null, (BValue)this.rangeEnd);
        gp.add(null, (BValue)new BLabel(this.lex("trigger.rangeInterval")));
        gp.add(null, (BValue)this.rangeInterval);
        bottom.add(null, (BValue)gp);
        gp = new BGridPane(2);
        gp.setUniformColumnWidth(true);
        gp.setColumnAlign(BHalign.fill);
        gp.add(null, (BValue)this.butAdd);
        gp.add(null, (BValue)this.butRem);
        bottom.add(null, (BValue)new BBorderPane((BWidget)gp, 5.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)content);
    }

    public void doAddPressed() {
        try {
            boolean modified = false;
            BTime start = (BTime)this.time.saveValue();
            SelectionItem item = this.makeSelectionItem(start);
            if (!this.set.contains(item)) {
                this.schedule.addTrigger(start.getHour(), start.getMinute());
                modified = true;
            }
            if (this.checkBox.isSelected()) {
                BTime end = (BTime)this.rangeEnd.saveValue();
                BRelTime interval = (BRelTime)this.rangeInterval.saveValue();
                BTime cur = start.add(interval);
                while (cur.isAfter(start) && (end.equals((Object)cur) || end.isAfter(cur))) {
                    item = this.makeSelectionItem(cur);
                    if (!this.set.contains(item)) {
                        this.schedule.addTrigger(cur.getHour(), cur.getMinute());
                        modified = true;
                    }
                    cur = cur.add(interval);
                }
            }
            if (modified) {
                this.loadList(this.context);
                this.fireModified(null);
            }
        }
        catch (Exception x) {
            Utils.error(this, x);
        }
    }

    public void doCheckBoxModified() {
        boolean enabled = this.checkBox.isSelected();
        this.rangeEnd.setReadonly(!enabled);
        this.rangeInterval.setReadonly(!enabled);
    }

    public void doSelectionModified() {
        if (this.list.getItemCount() == 0) {
            return;
        }
        this.butRem.setEnabled(this.list.getSelection().getItemCount() > 0);
    }

    public void doRemovePressed() {
        int[] items = this.list.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            BTime t = (BTime)((SelectionItem)this.list.getItem(items[i])).getValue();
            BTimeSchedule ts = this.schedule.effectiveAt(t);
            this.schedule.remove((BComplex)ts);
        }
        this.loadList(this.context);
        this.fireModified(null);
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
    }

    void loadList(Context cx) {
        this.context = cx;
        BTime t = BTime.make((int)0, (int)0, (int)0);
        this.time.loadValue((BObject)t);
        t = BTime.make((int)23, (int)59, (int)0);
        this.rangeEnd.loadValue((BObject)t);
        this.list.getSelection().deselectAll();
        this.list.removeAllItems();
        this.set = new SelectionSet();
        BAbstractSchedule[] ary = this.schedule.getSchedules();
        int i = ary.length;
        while (--i >= 0) {
            t = ((BTimeSchedule)ary[i]).getStart();
            this.set.add(this.makeSelectionItem(t));
        }
        SimpleSortedSet.Iterator i2 = this.set.iterator();
        while (i2.hasNext()) {
            this.list.addItem(i2.next());
        }
    }

    private SelectionItem makeSelectionItem(BTime t) {
        StringBuilder buf = new StringBuilder();
        int hour = t.getHour();
        int min = t.getMinute();
        if (hour < 10) {
            buf.append(0);
        }
        buf.append(hour).append('h');
        buf.append(" : ");
        if (min < 10) {
            buf.append(0);
        }
        buf.append(min).append('m');
        return new SelectionItem(buf.toString(), t);
    }

    static class SelectionSet
    extends SimpleSortedSet {
        SelectionSet() {
        }

        public int compare(Object o1, Object o2) {
            BTime t2;
            BTime t1 = (BTime)((SelectionItem)o1).getValue();
            if (t1.isBefore(t2 = (BTime)((SelectionItem)o2).getValue())) {
                return -1;
            }
            if (t1.isAfter(t2)) {
                return 1;
            }
            return 0;
        }
    }
}

