/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.gx.util.ColorUtil;
import com.tridium.schedule.ui.Utils;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.log.Log;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class ScheduleColors {
    private static Log LOG = Log.getLog((String)"schedule");
    private static BColor scheduleBackground;
    private static final BColor NULL_BACKGROUND_COLOR;
    private static final BColor FALSE_BACKGROUND_COLOR;
    private static final BColor TRUE_BACKGROUND_COLOR;
    private static final BColor DEFAULT_BACKGROUND_COLOR;
    public static final BColor[] DEFAULT_ENUM_COLORS;
    private static Integer lumaThreshold;
    private BColor foregroundColor;
    private BColor backgroundColor;
    private BBrush.Stop[] stops;
    private BBrush foreground = Utils.clrSelFg;
    private BBrush background = Utils.clrSelBg;
    private String css = null;
    private Context cx;
    private BStatusValue statusValue;
    private boolean built;

    public ScheduleColors(BStatusValue statusValue) {
        this.statusValue = statusValue;
    }

    private void rebuild(Context cx) {
        if (this.cx == cx && this.built) {
            return;
        }
        if (this.statusValue.getStatus().isNull()) {
            this.applyPlainColor(this.getNullColor(this.statusValue));
        } else if (this.statusValue instanceof BStatusEnum) {
            this.applyGradient(this.getBlockColor((BStatusEnum)this.statusValue));
        } else if (this.statusValue instanceof BStatusBoolean) {
            this.applyGradient(this.getBlockColor((BStatusBoolean)this.statusValue));
        } else {
            this.applyGradient(DEFAULT_BACKGROUND_COLOR);
        }
        this.cx = cx;
        this.css = null;
        this.built = true;
    }

    public BBrush getForeground(Context cx) {
        this.rebuild(cx);
        return this.foreground;
    }

    public BBrush getBackground(Context cx) {
        this.rebuild(cx);
        return this.background;
    }

    public String getCss(Context cx) {
        this.rebuild(cx);
        if (this.css == null) {
            this.css = ScheduleColors.generateCss(this);
        }
        return this.css;
    }

    private static double normalize(double v, double max) {
        return Math.max(0.0, Math.min(v, max));
    }

    private static int normalize(int v, int max) {
        return Math.max(0, Math.min(v, max));
    }

    private static double[] rgbToHsv(int r, int g, int b) {
        r = ScheduleColors.normalize(r, 255);
        g = ScheduleColors.normalize(g, 255);
        b = ScheduleColors.normalize(b, 255);
        return ColorUtil.toHsb((BColor)BColor.make((int)r, (int)g, (int)b));
    }

    private static BColor hsvToRgb(double h, double s, double v) {
        s = ScheduleColors.normalize(s, 1.0);
        v = ScheduleColors.normalize(v, 1.0);
        return ColorUtil.toRgb((double[])new double[]{h, s, v});
    }

    private void applyPlainColor(BColor color) {
        this.backgroundColor = color;
        this.foregroundColor = ScheduleColors.getContrastingColor(color);
        this.foreground = this.foregroundColor.toBrush();
        this.background = this.backgroundColor.toBrush();
    }

    private void applyGradient(BColor color) {
        int a = color.getAlpha();
        double[] hsv = ScheduleColors.rgbToHsv(color.getRed(), color.getGreen(), color.getBlue());
        double h = hsv[0];
        double s = hsv[1];
        double v = hsv[2];
        BColor rgba1 = BColor.make((BColor)ScheduleColors.hsvToRgb(h, s * 0.5, v * 1.35), (int)a);
        BColor rgba2 = BColor.make((BColor)ScheduleColors.hsvToRgb(h, s * 0.6, v * 1.25), (int)a);
        BColor rgba3 = BColor.make((BColor)ScheduleColors.hsvToRgb(h, s * 0.9, v * 1.05), (int)a);
        BColor rgba4 = BColor.make((BColor)ScheduleColors.hsvToRgb(h, s, v), (int)a);
        this.stops = new BBrush.Stop[]{BBrush.stop((double)0.0, (BColor)rgba1), BBrush.stop((double)30.0, (BColor)rgba2), BBrush.stop((double)90.0, (BColor)rgba3), BBrush.stop((double)97.0, (BColor)rgba4), BBrush.stop((double)100.0, (BColor)rgba3)};
        this.backgroundColor = rgba1;
        this.background = BBrush.makeLinearGradient((BBrush.Stop[])this.stops, (int)1, (double)270.0);
        this.foregroundColor = ScheduleColors.getContrastingColor(rgba1);
        this.foreground = this.foregroundColor.toBrush();
    }

    private static double luma(BColor color) {
        double r = color.getRed();
        double g = color.getGreen();
        double b = color.getBlue();
        if (color.getAlpha() < 255) {
            BColor background = ScheduleColors.getScheduleBackground();
            double bR = background.getRed();
            double bG = background.getGreen();
            double bB = background.getBlue();
            double a = (double)color.getAlpha() / 255.0;
            r = a * (r - bR) + bR;
            g = a * (g - bG) + bG;
            b = a * (b - bB) + bB;
        }
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private static BColor getContrastingColor(BColor color) {
        if (ScheduleColors.luma(color) > (double)ScheduleColors.getLumaThreshold()) {
            return BColor.black;
        }
        return BColor.white;
    }

    private static int getLumaThreshold() {
        if (lumaThreshold == null) {
            try {
                int parsed = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("schedule.lumaThreshold", "150")));
                lumaThreshold = parsed;
            }
            catch (Exception e) {
                lumaThreshold = 150;
            }
        }
        return lumaThreshold;
    }

    private BColor getBlockColor(BStatusEnum statusEnum) {
        BDynamicEnum en = statusEnum.getValue();
        BWeeklySchedule sched = ScheduleColors.getWeeklySchedule((BStatusValue)statusEnum);
        BColor color = ScheduleColors.getConfiguredColor(en.getOrdinal(), sched);
        if (color == null) {
            color = this.getLexiconColor(statusEnum);
        }
        if (color == null) {
            color = ScheduleColors.getDefaultColor(statusEnum);
        }
        return color;
    }

    private static BEnumRange getEnumRange(BStatusEnum statusEnum) {
        BObject obj;
        BWeeklySchedule sched;
        BDynamicEnum en = statusEnum.getValue();
        BEnumRange range = en.getRange();
        if (range == BEnumRange.DEFAULT && (sched = ScheduleColors.getWeeklySchedule((BStatusValue)statusEnum)) != null && (obj = sched.getFacets().get("range")) instanceof BEnumRange) {
            range = (BEnumRange)obj;
        }
        return range;
    }

    public static int getOrdinalIndex(BStatusEnum statusEnum) {
        BDynamicEnum en = statusEnum.getValue();
        BEnumRange range = ScheduleColors.getEnumRange(statusEnum);
        int ordinal = en.getOrdinal();
        int[] ordinals = range.getOrdinals();
        int index = ArrayUtil.indexOf((int[])ordinals, (int)ordinal);
        if (index == -1) {
            return ordinal;
        }
        return index;
    }

    private BColor getLexiconColor(BStatusEnum statusEnum) {
        int index = ScheduleColors.getOrdinalIndex(statusEnum);
        if (index >= 0) {
            String key = "EnumSchedule.colors." + index;
            return this.getColorFromLexicon(key);
        }
        return null;
    }

    private static BColor getDefaultColor(BStatusEnum en) {
        int index = ScheduleColors.getOrdinalIndex(en);
        index = Math.abs(index);
        int len = DEFAULT_ENUM_COLORS.length;
        int ord = index % (len * 2);
        int arrayIndex = ord % len;
        return DEFAULT_ENUM_COLORS[arrayIndex];
    }

    private BColor getBlockColor(BStatusBoolean statusBoolean) {
        BWeeklySchedule sched;
        boolean b = statusBoolean.getValue();
        BColor color = ScheduleColors.getConfiguredColor(b ? 1 : 0, sched = ScheduleColors.getWeeklySchedule((BStatusValue)statusBoolean));
        if (color == null) {
            color = this.getLexiconColor(b);
        }
        if (color == null) {
            color = ScheduleColors.getDefaultColor(b);
        }
        return color;
    }

    private BColor getLexiconColor(boolean b) {
        String key = "BooleanSchedule.colors." + (b ? 1 : 0);
        return this.getColorFromLexicon(key);
    }

    private static BColor getDefaultColor(boolean b) {
        return b ? TRUE_BACKGROUND_COLOR : FALSE_BACKGROUND_COLOR;
    }

    private static BColor getConfiguredColor(int ordinal, BWeeklySchedule sched) {
        BEnumRange range;
        BFacets facets;
        BObject obj;
        if (sched instanceof BWeeklySchedule && (obj = (facets = sched.getFacets()).get("colors")) instanceof BEnumRange && (range = (BEnumRange)obj).isOrdinal(ordinal)) {
            String tag = range.getDisplayTag(ordinal, null);
            try {
                return BColor.make((String)tag);
            }
            catch (Exception e) {
                LOG.error("Invalid color configured on schedule: " + tag);
            }
        }
        return null;
    }

    private BColor getColorFromLexicon(String key) {
        String value = this.getScheduleLex().get(key);
        if (value != null) {
            try {
                return BColor.make((String)value);
            }
            catch (Exception e) {
                LOG.error("Invalid color in lexicon: " + key + " = " + value);
                return null;
            }
        }
        return null;
    }

    private BColor getNullColor(BStatusValue statusValue) {
        BColor color = null;
        if (statusValue instanceof BStatusEnum) {
            color = this.getColorFromLexicon("EnumSchedule.colors.null");
        } else if (statusValue instanceof BStatusBoolean) {
            color = this.getColorFromLexicon("BooleanSchedule.colors.null");
        }
        if (color == null) {
            color = NULL_BACKGROUND_COLOR;
        }
        return color;
    }

    private static BColor getScheduleBackground() {
        if (scheduleBackground == null) {
            scheduleBackground = ((BBrush.Solid)Utils.clrBg.getPaint()).getColor();
        }
        return scheduleBackground;
    }

    private Lexicon getScheduleLex() {
        return Lexicon.make((String)"schedule", (Context)this.cx);
    }

    private static BWeeklySchedule getWeeklySchedule(BStatusValue value) {
        for (BStatusValue comp = value; comp != null && !comp.isNull(); comp = comp.getParent()) {
            if (!comp.getType().is(BWeeklySchedule.TYPE)) continue;
            return (BWeeklySchedule)comp;
        }
        return null;
    }

    private static String toRgba(BColor color) {
        StringBuilder sb = new StringBuilder();
        int a = color.getAlpha();
        if (a == 255) {
            sb.append("rgb(").append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(')');
        } else {
            double alpha = (double)Math.round((double)color.getAlpha() / 255.0 * 100.0) / 100.0;
            sb.append("rgba(").append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(',').append(alpha).append(')');
        }
        return sb.toString();
    }

    private static String createGradientPointData(double angle) {
        double rads = angle * Math.PI / 180.0;
        double cos = Math.cos(rads);
        double sin = Math.sin(rads);
        double mag = 1.0 / Math.max(Math.abs(sin), Math.abs(cos));
        double endX = cos * mag;
        double endY = -sin * mag;
        double startX = -endX;
        double startY = -endY;
        startX = Math.round((startX + 1.0) * 50.0);
        startY = Math.round((startY + 1.0) * 50.0);
        endX = Math.round((endX + 1.0) * 50.0);
        endY = Math.round((endY + 1.0) * 50.0);
        return startX + "% " + startY + "%, " + endX + "% " + endY + "%";
    }

    private static String makeWebkitGradient(BBrush.Stop[] stops) {
        StringBuilder webkitCss = new StringBuilder();
        webkitCss.append("(linear, left top, left bottom");
        for (int i = 0; i < stops.length; ++i) {
            BBrush.Stop stop = stops[i];
            BColor color = stop.getColor();
            webkitCss.append(", color-stop(").append(stop.getOffset()).append("%, ").append(ScheduleColors.toRgba(color)).append(")");
        }
        webkitCss.append(")");
        return webkitCss.toString();
    }

    private static String makeLinearGradient(BBrush.Stop[] stops) {
        StringBuilder css = new StringBuilder();
        int len = stops.length;
        int i = 0;
        css.append("(to bottom, ");
        while (i < len) {
            BBrush.Stop stop = stops[i];
            css.append(ScheduleColors.toRgba(stop.getColor())).append(" ").append(stop.getOffset()).append("%");
            if (++i >= len) continue;
            css.append(", ");
        }
        css.append(")");
        return css.toString();
    }

    private static String generateCss(ScheduleColors colors) {
        StringBuilder sb = new StringBuilder();
        sb.append(" color:").append(ScheduleColors.toRgba(colors.foregroundColor)).append(";\n");
        sb.append(" background-color:").append(ScheduleColors.toRgba(colors.backgroundColor)).append(";\n");
        BBrush.Stop[] stops = colors.stops;
        if (stops == null || stops.length == 0) {
            return sb.toString();
        }
        BColor firstColor = stops[0].getColor();
        BColor lastColor = stops[stops.length - 1].getColor();
        String linearGradient = ScheduleColors.makeLinearGradient(stops);
        sb.append(" background-image: linear-gradient").append(linearGradient).append(";\n");
        sb.append(" border-top: 1px solid ").append(ScheduleColors.toRgba(lastColor)).append(";\n");
        return sb.toString();
    }

    static {
        NULL_BACKGROUND_COLOR = BColor.make((String)"#f8cccccc");
        FALSE_BACKGROUND_COLOR = BColor.make((String)"#f8e17171");
        TRUE_BACKGROUND_COLOR = BColor.make((String)"#f865cb65");
        DEFAULT_BACKGROUND_COLOR = BColor.make((String)"#f88fbc8f");
        DEFAULT_ENUM_COLORS = new BColor[]{BColor.make((String)"#f88c0000"), BColor.make((String)"#f8387038"), BColor.make((String)"#f8703870"), BColor.make((String)"#f825255a"), BColor.make((String)"#f81f6f70"), BColor.make((String)"#f8704308"), BColor.make((String)"#f8606060"), BColor.make((String)"#f8e17171"), BColor.make((String)"#f865cb65"), BColor.make((String)"#f8cb7fcb"), BColor.make((String)"#f86c6ccb"), BColor.make((String)"#f854b7b8"), BColor.make((String)"#f8c88435"), BColor.make((String)"#f8e1e171")};
    }
}

