/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webeditors.ux.servlets;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeConfig;

@NiagaraType
public class BTypeConfigRpc
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BTypeConfigRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getTypeConfigInfo(String typeSpec, Context cx) {
        BTypeConfig typeConfig = BTypeConfigRpc.getTypeConfigInstance(typeSpec);
        if (typeConfig == null) {
            throw new IllegalArgumentException("BTypeConfig type spec required");
        }
        return BTypeConfigRpc.getTypeConfigInfo(typeConfig);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject getConfigurableInfo(String typeConfigSpec, String configurableSpec, Context cx) throws IOException {
        BTypeConfig typeConfig = BTypeConfigRpc.getTypeConfigInstance(typeConfigSpec);
        if (typeConfig == null) {
            throw new IllegalArgumentException("BTypeConfig type spec required");
        }
        BTypeConfig.IConfigurable configurable = BTypeConfigRpc.getConfigurableInstance(configurableSpec);
        if (configurable == null) {
            throw new IllegalArgumentException("BTypeConfig.IConfigurable type spec required");
        }
        typeConfig.syncFrom((BObject)configurable);
        return BTypeConfigRpc.getConfigurableInfo(typeConfig, configurable);
    }

    private static BTypeConfig getTypeConfigInstance(String typeSpec) {
        try {
            TypeInfo info = Sys.getRegistry().getType(typeSpec);
            return info.is(BTypeConfig.TYPE) ? (BTypeConfig)info.getInstance() : null;
        }
        catch (TypeNotFoundException e) {
            return null;
        }
    }

    private static JSONObject getTypeConfigInfo(BTypeConfig config) {
        JSONObject obj = new JSONObject();
        obj.put("targetType", (Object)config.getTargetType().toString());
        obj.put("defaultType", (Object)config.getTypeSpec().toString());
        return obj;
    }

    private static BTypeConfig.IConfigurable getConfigurableInstance(String typeSpec) {
        try {
            TypeInfo info = Sys.getRegistry().getType(typeSpec);
            BObject instance = info.getInstance();
            return instance instanceof BTypeConfig.IConfigurable ? (BTypeConfig.IConfigurable)instance : null;
        }
        catch (TypeNotFoundException e) {
            return null;
        }
    }

    private static JSONObject getConfigurableInfo(BTypeConfig config, BTypeConfig.IConfigurable configurable) throws IOException {
        JSONArray arr = new JSONArray();
        for (String key : configurable.listConfig()) {
            JSONObject obj = new JSONObject();
            obj.put("key", (Object)key);
            obj.put("displayName", (Object)config.getDisplayName(config.getSlot(key), null));
            obj.put("facets", (Object)BsonEncoderPlugin.marshal((BValue)configurable.getConfigFacets(key)));
            obj.put("value", (Object)BsonEncoderPlugin.marshal((BValue)configurable.getConfig(key)));
            arr.put((Object)obj);
        }
        JSONObject obj = new JSONObject();
        obj.put("config", (Object)arr);
        return obj;
    }
}

