/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webeditors.ux.servlets;

import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONWriter;
import com.tridium.nav.BINavSupport;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.RestUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.baja.nav.BINavNode;
import javax.baja.registry.ModuleInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class PaletteServlet
extends HttpServlet {
    private static final Pattern COMMA = Pattern.compile(",");

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RestUtil util = new RestUtil(req, res);
        String operation = util.get(0);
        Context cx = (Context)req.getAttribute("niagara.context");
        res.setContentType("application/json");
        HttpHeaderUtil.cacheAndRevalidateAfter((HttpServletResponse)res, (int)HttpHeaderUtil.MAX_AGE_THREE_DAYS);
        switch (operation) {
            case "list": {
                PaletteServlet.sendPaletteModuleList(res);
                break;
            }
            case "get": {
                PaletteServlet.sendPaletteData(res, PaletteServlet.getModuleNames(util.get(1)), cx);
                break;
            }
            default: {
                res.sendError(404);
            }
        }
    }

    private static Optional<BINavNode> getPaletteRoot(String moduleName) {
        try {
            BModule module = Sys.loadModule((String)moduleName);
            BINavNode node = module.getNavChild("module.palette");
            if (node instanceof BComponentSpace) {
                BComponentSpace space = (BComponentSpace)node;
                return Optional.ofNullable(space.getRootComponent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static boolean hasPalette(ModuleInfo info) {
        return info instanceof NModuleInfo && ((NModuleInfo)info).hasPalette();
    }

    private static void sendPaletteModuleList(HttpServletResponse res) throws IOException {
        BoxWriter out = new BoxWriter((Writer)res.getWriter());
        out.array();
        LinkedHashMap<String, NModuleInfo> map = new LinkedHashMap<String, NModuleInfo>();
        for (ModuleInfo info2 : Sys.getRegistry().getModules()) {
            if (!PaletteServlet.hasPalette(info2) || map.containsKey(info2.getModuleName())) continue;
            map.put(info2.getModuleName(), (NModuleInfo)info2);
        }
        map.forEach((name, info) -> out.object().key("n").value((Object)info.getModuleName()).key("d").value((Object)info.getDescription()).endObject());
        out.endArray();
    }

    private static void sendPaletteData(HttpServletResponse res, String[] moduleNames, Context cx) throws IOException {
        BoxWriter out = new BoxWriter((Writer)res.getWriter());
        out.array();
        for (String moduleName : moduleNames) {
            Optional<BINavNode> node = PaletteServlet.getPaletteRoot(moduleName);
            if (!node.isPresent()) continue;
            out.object().key("n").value((Object)moduleName).key("v").array();
            for (BINavNode kid : node.get().getNavChildren()) {
                BINavSupport.encodeToJson((BINavNode)kid, (JSONWriter)out, (BiFunction)BINavSupport.ENCODE_ALL_NAV_CHILDREN, (Context)cx);
            }
            out.endArray().endObject();
        }
        out.endArray();
    }

    private static String[] getModuleNames(String moduleNamesString) throws ServletException {
        if (moduleNamesString == null) {
            throw new ServletException("module names required");
        }
        return COMMA.split(moduleNamesString);
    }
}

