/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.tridium.authn.AbstractNiagaraLoginModule;
import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.ScramServerCallback;
import com.tridium.gauth.BGoogleAuthAuthenticator;
import com.tridium.gauth.GoogleAuthCallbackHandler;
import com.tridium.gauth.GoogleAuthenticator;
import com.tridium.nre.auth.ScramServer;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.security.BPassword;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class GoogleAuthLoginModule
extends AbstractNiagaraLoginModule {
    public boolean doLogin() throws LoginException {
        FailedLoginException e;
        String token;
        String username;
        ScramServer scramServer;
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for username and password login");
        }
        Callback[] callbacks = new Callback[]{new ScramServerCallback(), new TextInputCallback("token")};
        boolean tokenCheckRequired = true;
        try {
            BUser user;
            this.callbackHandler.handle(callbacks);
            scramServer = ((ScramServerCallback)callbacks[0]).getServer();
            username = ((ScramServerCallback)callbacks[0]).getUsername();
            token = ((TextInputCallback)callbacks[1]).getText();
            if (username != null && (user = BUserService.getService().getUser(username)) != null) {
                BGoogleAuthAuthenticator authenticator = (BGoogleAuthAuthenticator)user.getAuthenticator();
                tokenCheckRequired = authenticator.isTokenCheckRequired();
            }
            if (scramServer == null || username == null || token == null && tokenCheckRequired) {
                return false;
            }
        }
        catch (UnsupportedCallbackException e2) {
            String msg = "Provided callback handler could not handle: " + e2.getCallback().toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e2);
            throw new LoginException(msg);
        }
        catch (Exception e3) {
            String msg = "Error handling callbacks:" + e3.toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)e3);
            throw new LoginException(msg);
        }
        this.user = this.getUserService().getUser(username);
        BGoogleAuthAuthenticator authenticator = (BGoogleAuthAuthenticator)this.user.getAuthenticator();
        try {
            if (authenticator.getForceSecretKeyResetAtNextLogin() && !((GoogleAuthCallbackHandler)((Object)this.callbackHandler)).supportsSecretKeyReset()) {
                this.user = null;
                throw new NiagaraFailedLoginException(username, "Login failed: secret key reset is required but cannot be done over this transport");
            }
        }
        catch (ClassCastException cce) {
            this.user = null;
            throw new NiagaraFailedLoginException(username, "Login failed: mismatched callback handler assigned to user");
        }
        boolean validToken = false;
        if (tokenCheckRequired) {
            try {
                if (authenticator.getSecretKey().isDefault()) {
                    throw new NiagaraFailedLoginException(username, "Login failed: no google secret key has been registered");
                }
                GoogleAuthenticator gauth = new GoogleAuthenticator(AccessController.doPrivileged(() -> ((BPassword)authenticator.getSecretKey()).getValue()));
                validToken = gauth.checkToken(Long.parseLong(token));
            }
            catch (ClassCastException cce) {
                this.user = null;
                throw new NiagaraFailedLoginException(username, "Login failed: mismatched authenticator assigned to user");
            }
            catch (NumberFormatException | InvalidKeyException | NoSuchAlgorithmException oe) {
                this.user = null;
                throw new FailedLoginException("Login failed: Invalid credentials.");
            }
        }
        if (this.user != null && scramServer.isAuthenticated() && (validToken || !tokenCheckRequired)) {
            this.succeeded = true;
            return true;
        }
        if (this.user != null) {
            e = new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid credentials.");
            this.user = null;
        } else {
            e = new FailedLoginException("Login failed: Invalid credentials.");
        }
        throw e;
    }
}

