/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gauth;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.baja.sys.Clock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public class GoogleAuthenticator {
    private static final HashMap<String, HashMap<Long, QueueEntry>> tokenCache = new HashMap();
    public static final int SECRET_SIZE = 10;
    private final String secret;

    public GoogleAuthenticator(String secret) {
        this.secret = secret;
    }

    public static String createSecret() {
        byte[] buffer = new byte[10];
        new SecureRandom().nextBytes(buffer);
        String encodedKey = new Base32().encodeToString(buffer);
        return encodedKey;
    }

    public String getQRBarcodeSVG(String user, String host) throws IOException {
        String uriText = "otpauth://totp/" + user + "@" + host + "?secret=" + this.secret.toUpperCase();
        try {
            EnumMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new EnumMap<EncodeHintType, ErrorCorrectionLevel>(EncodeHintType.class);
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(uriText, BarcodeFormat.QR_CODE, 41, 41, hintMap);
            int blockSize = 4;
            int width = byteMatrix.getWidth() * blockSize;
            int height = byteMatrix.getHeight() * blockSize;
            StringBuilder svg = new StringBuilder();
            svg.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
            svg.append("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:svg=\"http://www.w3.org/2000/svg\"");
            svg.append(" width=\"").append(width).append("\"");
            svg.append(" height=\"").append(height).append("\">\n");
            for (int i = 0; i < byteMatrix.getWidth(); ++i) {
                for (int j = 0; j < byteMatrix.getHeight(); ++j) {
                    if (!byteMatrix.get(i, j)) continue;
                    svg.append("<rect width=\"").append(blockSize).append("\" height=\"").append(blockSize).append("\"");
                    svg.append(" x=\"").append(i * blockSize).append("\" y=\"").append(j * blockSize).append("\" style=\"fill:black;\"/>\n");
                }
            }
            svg.append("</svg>\n");
            return svg.toString();
        }
        catch (WriterException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkToken(long token) throws NoSuchAlgorithmException, InvalidKeyException {
        long t = new Date().getTime() / TimeUnit.SECONDS.toMillis(30L);
        byte[] decodedKey = new Base32().decode(this.secret);
        int window = 3;
        long now = Clock.ticks();
        long expired = now - (long)window * TimeUnit.SECONDS.toMillis(30L);
        boolean reused = false;
        for (int i = -window; i <= window; ++i) {
            long hash = GoogleAuthenticator.verifyToken(decodedKey, t + (long)i);
            if (hash != token) continue;
            HashMap<Long, QueueEntry> map = tokenCache.get(this.secret);
            if (map != null) {
                HashMap<Long, QueueEntry> hashMap = map;
                synchronized (hashMap) {
                    QueueEntry entry;
                    Iterator<QueueEntry> iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        if (entry.timestamp < expired) {
                            iterator.remove();
                            continue;
                        }
                        if (entry.token != token) continue;
                        reused = true;
                    }
                    if (reused) {
                        return false;
                    }
                    entry = new QueueEntry(now, token);
                    map.put(now, entry);
                }
            } else {
                QueueEntry entry = new QueueEntry(now, token);
                map = new HashMap();
                map.put(now, entry);
                tokenCache.put(this.secret, map);
            }
            return true;
        }
        return false;
    }

    private static int verifyToken(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return (int)(truncatedHash %= 1000000L);
    }

    private static class QueueEntry {
        public long timestamp;
        public long token;

        public QueueEntry(long timestamp, long token) {
            this.timestamp = timestamp;
            this.token = token;
        }
    }
}

